/*
dicepkr.c Version 1.5.0 - Dice Rolling Test
Copyright (C) 2005-2010  dondalah721@yahoo.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

/* This test is based on: */
/* Lincoln L. Chao */
/* Statistics for Management */
/* Palo Alto, CA: The Scientific Press, 1984 */
/* Chapter 6, Expected Value and Population Parameters */
/* Section 2, Population Mean and Variance */

/* Lincoln L. Chao was at California State University, */
/* Long Beach, CA, while writing this book. */

/* John Scarne */
/* Scarne's New Complete Guide to Gambling */
/* Fully revised, expanded, updated edition */
/* New York: Simon & Schuster, 1961, 1974, 1986 */
/* A Fireside book, 871 p. */
/* ISBN: 0-671-21734-8 hardback */
/* ISBN: 0-671-63063-6 paperback */
/* Chapter 11, Correct Odds In Dice Games */
/* Using Two, Three, Four, or Five Dice */

/* Sample test: */

/* dicepkr 10000 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "rnd.h"

#define HANDS       7776
#define FIVEKIND    0
#define FOURKIND    1
#define FULLHSE     2
#define STRAIGHT    3
#define THREEKIND   4
#define TWOPAIRS    5
#define ONEPAIR     6
#define MISC        7

void putstx(pgm)
char *pgm;
   {
   fprintf(stderr,"Usage: %s size\n",
      pgm);
   fprintf(stderr,"Where size is 30 to 1000000\n");
   exit(1);
   } /* putstx */

int main(argc,argv)
int argc;
char **argv;
   {
   int i;
   int size;
   int cubes;
   int pwr;
   int score;
   int maxscore;
   int degf;
   int min;
   int max;
   int resort;
   int pairsw;
   int tripletsw;
   int miscsw;
   int tmp;
   int misc;
   int onepr;
   int twopr;
   int threekind;
   int straight;
   int fullhse;
   int fourkind;
   int fivekind;
   int tothand;
   int *obs;
   int *obsptr;
   int *obsend;
   int *grpptr;
   int *grpend;
   int grp[16];
   int *sumptr;
   int *sumend;
   int *sumdice;
   int *handptr;
   int *handend;
   int *hand;
   double dblcubes;
   double dblpwr;
   double dblscore;
   double dblobs;
   double dbli;
   double dblhands;
   double zval;
   double zscore;
   double *p,*q;
   double *prob;
   double *probptr;
   double *pkrprob;
   double *pkrprobptr;
   double *pkrprobend;
   double totprob;
   double musq;
   double est_xsq;
   double popmu;
   double popvar;
   double popstdev;
   double std_err;
   double expect;
   double portion;
   double totportion;
   double mean;
   double variance,stdev;
   double diff;
   double sumchi;
   double dblsz;
   double rootsz;
   double sumx,sumxsqd;
   double negtblv,postblv;
   void chirange(int degf, double *lorange,
      double *hirange);
   if (argc != 2) putstx(*argv);
   size = atoi(*(argv+1));
   if (size < 30 || size > 1000000)
      {
      fprintf(stderr,"Invalid sample size.\n");
      putstx(*argv);
      } /* bad size */
   dblsz  = (double) size;
   rootsz = sqrt(dblsz);
   dblhands = (double) HANDS;
   cubes = 5;
   dblcubes = (double) cubes;
   maxscore = cubes * 6;
   dblpwr = (double) pow(6.0,dblcubes);
   pwr = (int) dblpwr;
   sd = (unsigned char *) rndinit();
   if (sd == NULL)
      {
      fprintf(stderr,"dicepkr: out of memory "
	 "allocating sd.\n");
      exit(1);
      } /* out of mem */
   hand = (int *) malloc(sizeof(int) * 32);
   if (hand == NULL)
      {
      fprintf(stderr,"dicepkr: out of memory "
	 "allocating hand.\n");
      exit(1);
      } /* out of mem */
   sumdice = (int *) malloc((maxscore+8) * sizeof(int));
   if (sumdice == NULL)
      {
      fprintf(stderr,"dicepkr: out of memory "
	 "allocating population array.\n");
      exit(1);
      } /* out of memory */
   prob = (double *) malloc((maxscore+8) * sizeof(double));
   if (prob == NULL)
      {
      fprintf(stderr,"dicepkr: out of memory "
	 "allocating probability array.\n");
      exit(1);
      } /* out of memory */
   pkrprob = (double *) malloc(sizeof(double) * 32);
   if (pkrprob == NULL)
      {
      fprintf(stderr,"dicepkr: out of memory "
	 "allocating poker probability array.\n");
      exit(1);
      } /* out of memory */
   obs = (int *) malloc((maxscore+8) * sizeof(int));
   if (obs == NULL)
      {
      fprintf(stderr,"dicepkr: out of memory "
	 "allocating observation array.\n");
      exit(1);
      } /* out of memory */
   printf("Total observations %d\n", size);
   printf("Probability Distribution\n");
   printf("x = score after rolling "
      "%d dice\n", cubes);
   printf("       x    P(x) "
      "                  "
      "Total P(x) "
      "            z\n");
   sumptr = (int *) sumdice;
   sumend = (int *) sumdice + maxscore + 1;
   while (sumptr < sumend) *sumptr++ = 0;
   grpptr = (int *) grp;
   grpend = (int *) grp + cubes;
   while (grpptr < grpend) *grpptr++ = 1;
   i = pwr;
   while (i--)
      {
      score = 0;
      grpptr = (int *) grp;
      grpend = (int *) grp + cubes;
      while (grpptr < grpend) score += *grpptr++;
      sumptr = (int *) sumdice + score;
      (*sumptr)++;
      grpend = (int *) grp + cubes - 1;
      grpptr = (int *) grp;
      while (grpend >= grpptr)
	 {
	 (*grpend)++;
	 if (*grpend > 6)
	    {
	    *grpend = 1;
	    grpend--;
	    } /* if carry */
	 else break;
	 } /* from low order die to high order die */
      } /* for each permutation of dice */
   p = (double *) prob;
   q = (double *) prob + maxscore + 1;;
   while (p < q) *p++ = 0.0;
   sumptr = (int *) sumdice;
   sumend = (int *) sumdice + maxscore + 1;
   p = (double *) prob;
   while (sumptr < sumend)
      {
      if (*sumptr > 0)
	 {
	 *p = (double) *sumptr / dblpwr;
	 } /* if valid score */
      p++;
      sumptr++;
      } /* for each combination */
   popmu = 0.0;
   p = prob;
   q = p + maxscore + 1;
   sumptr = (int *) sumdice;
   i = 0;
   while (p < q)
      {
      if (*sumptr > 0)
         popmu += ((double) i * *p);
      i++;
      sumptr++;
      p++;
      } /* for each score of the dice */
   musq = popmu * popmu;
   est_xsq = 0.0;
   p = (double *) prob;
   q = (double *) p + maxscore + 1;
   sumptr = (int *) sumdice;
   i = 0;
   while (p < q)
      {
      if (*sumptr > 0)
         est_xsq += ((double) (i * i) * *p);
      i++;
      sumptr++;
      p++;
      } /* for each score of the dice */
   popvar   = est_xsq -  musq;
   popstdev = sqrt(popvar);
   std_err  = popstdev / rootsz;
   degf = i = 0;
   totprob = 0.0;
   p = (double *) prob;
   q = (double *) p + maxscore + 1;
   sumptr = (int *) sumdice;
   while (p < q)
      {
      if (*sumptr > 0)
	 {
         dbli = (double) i;
         zval = (dbli - popmu) / popstdev;
         totprob += *p;
         printf("%8d %22.17f %22.17f %9.4f\n",
	    i, *p, totprob, zval);
	 degf++;
	 } /* if valid probability */
      i++;
      sumptr++;
      p++;
      } /* for each score of dice */
   printf("\n");
   pkrprobptr = (double *) pkrprob;
   pkrprobend = (double *) pkrprob + 16;
   while (pkrprobptr < pkrprobend)
      *pkrprobptr++ = 0.0;
   pkrprobptr = (double *) pkrprob;
   *pkrprobptr++ =     6.0 / HANDS;     /* 5 kind */
   *pkrprobptr++ =   150.0 / HANDS;     /* 4 kind */
   *pkrprobptr++ =   240.0 / HANDS;     /* straight */
   *pkrprobptr++ =   300.0 / HANDS;     /* full house */
   *pkrprobptr++ =  1200.0 / HANDS;     /* 3 kind */
   *pkrprobptr++ =  1800.0 / HANDS;     /* 2 pairs */
   *pkrprobptr++ =  3600.0 / HANDS;     /* 1 pair */
   *pkrprobptr++ =   480.0 / HANDS;     /* miscellaneous */

   obsptr = obs;
   obsend = obsptr + maxscore + 1;
   while (obsptr < obsend) *obsptr++ = 0;
   sumx = sumxsqd = 0.0;
   min =  999999999;
   max = -999999999;
   fivekind = fourkind = fullhse
      = straight = threekind = twopr
      = onepr = misc = 0;
   i = size;
   while (i--)
      {
      /* deal hand with replacement */
      handptr = (int *) hand;
      handend = (int *) hand + 5;
      while (handptr < handend)
	 *handptr++ = (int) rndnum(6,sd);
      *handptr++ = 99999999;
      *handptr++ = 99999999;
      *handptr++ = 99999999;
      *handptr++ = 99999999;
      *handptr++ = 99999999;
      resort = 1;
      while (resort)
	 {
	 resort = 0;
         handptr = (int *) hand;
         handend = (int *) hand + 5;
	 while (handptr < handend)
	    {
	    if (*handptr > *(handptr+1))
	       {
	       tmp = *handptr;
	       *handptr = *(handptr+1);
	       *(handptr+1) = tmp;
	       resort = 1;
	       } /* if swap */
	    handptr++;
	    } /* for each card in hand */
	 } /* for each pass of bubble sort */
      pairsw = tripletsw = miscsw = 0;
      handptr = (int *) hand;
      handend = (int *) hand + 5;
      while (handptr < handend)
	 {
         if (*handptr == *(handptr+1) - 1
            && *(handptr+1) == *(handptr+2) - 1
            && *(handptr+2) == *(handptr+3) - 1
            && *(handptr+3) == *(handptr+4) - 1)
	    {
	    straight++;
	    break;
	    } /* straight */
         if (*handptr == *(handptr+1)
            && *handptr == *(handptr+2)
            && *handptr == *(handptr+3)
            && *handptr == *(handptr+4))
	    {
	    fivekind++;
	    break;
	    } /* 5kind */
         if (*handptr == *(handptr+1)
            && *handptr == *(handptr+2)
            && *handptr == *(handptr+3))
	    {
	    fourkind++;
	    break;
	    } /* 4kind */
         if (*handptr == *(handptr+1)
            && *handptr == *(handptr+2))
	    {
	    if (pairsw)
	       {
	       fullhse++;
	       pairsw = 0;
	       break;
	       } /* if full hse */
	    tripletsw = 1;
	    handptr += 3;
	    continue;
	    } /* fullhse or 3kind */
         if (*handptr == *(handptr+1))
	    {
	    if (tripletsw)
	       {
	       fullhse++;
	       tripletsw = 0;
	       break;
	       } /* if full hse */
	    if (pairsw)
	       {
	       twopr++;
	       pairsw = 0;
	       break;
	       } /* if two pairs */
	    pairsw = 1;
	    handptr += 2;
	    continue;
	    } /* fullhse or 3kind */
	 miscsw++;
	 handptr++;
	 } /* for each card in hand */
      if (pairsw == 1) onepr++;
      else if (tripletsw == 1) threekind++;
      else if (miscsw == 5) misc++;
      score = 0;
      handptr = (int *) hand;
      handend = (int *) hand + 5;
      while (handptr < handend)
         score += (*handptr++) + 1;
      obsptr = obs + score;
      (*obsptr)++;
      dblscore = (double) score;
      sumx    += dblscore;
      sumxsqd += (dblscore * dblscore);
      if (score < min) min = score;
      if (score > max) max = score;
      } /* generate histogram */
   tothand = fivekind + fourkind + fullhse
      + straight + threekind + twopr
      + onepr + misc;
   variance = (sumxsqd - (sumx * sumx / dblsz))
      / (dblsz - 1.0);
   stdev = sqrt(variance);
   sumchi = 0.0;
   obsptr = (int *) obs;
   obsend = (int *) obsptr + maxscore + 1;
   probptr = (double *) prob;
   sumptr  = (int *) sumdice;
   while (obsptr < obsend)
      {
      if (*sumptr > 0)
	 {
         dblobs = (double) *obsptr;
         expect = (*probptr) * dblsz;
         diff = dblobs - expect;
         sumchi += (diff * diff / expect);
	 } /* if valid probability */
      obsptr++;
      probptr++;
      sumptr++;
      } /* sum chi-sq */
   mean = sumx / dblsz;
   zscore = (mean - popmu) / std_err;
   printf("             Mean "
      "      Variance   Stdev "
      "     Z Score      Min     Max\n");
   printf("Population %10.6f %10.6f %10.6f\n",
      popmu, popvar, popstdev);
   printf("Observed   %10.6f %10.6f %10.6f %10.6f %7d %7d\n",
      mean, variance, sqrt(variance), zscore, min, max);
   printf("\n");
   printf("Chi-square %f\n", sumchi);
   chirange(degf-1,&negtblv,&postblv);
   printf("Range at 95 percent: %f  to  %f\n",
      negtblv, postblv);
   printf("\n");
   variance = (sumxsqd - (sumx * sumx / dblsz))
      / (dblsz - 1.0);
   stdev = sqrt(variance);
   sumchi = 0.0;
   pkrprobptr = (double *) pkrprob;

   /* 5 kind */
   dblobs = (double) fivekind;
   expect = (*pkrprobptr++) * dblsz;
   diff = dblobs - expect;
   sumchi += (diff * diff / expect);

   /* 4 kind */
   dblobs = (double) fourkind;
   expect = (*pkrprobptr++) * dblsz;
   diff = dblobs - expect;
   sumchi += (diff * diff / expect);

   /* straight */
   dblobs = (double) straight;
   expect = (*pkrprobptr++) * dblsz;
   diff = dblobs - expect;
   sumchi += (diff * diff / expect);

   /* full house */
   dblobs = (double) fullhse;
   expect = (*pkrprobptr++) * dblsz;
   diff = dblobs - expect;
   sumchi += (diff * diff / expect);

   /* 3 kind */
   dblobs = (double) threekind;
   expect = (*pkrprobptr++) * dblsz;
   diff = dblobs - expect;
   sumchi += (diff * diff / expect);

   /* 2 pairs */
   dblobs = (double) twopr;
   expect = (*pkrprobptr++) * dblsz;
   diff = dblobs - expect;
   sumchi += (diff * diff / expect);

   /* 1 pair */
   dblobs = (double) onepr;
   expect = (*pkrprobptr++) * dblsz;
   diff = dblobs - expect;
   sumchi += (diff * diff / expect);

   /* miscellaneous */
   dblobs = (double) misc;
   expect = (*pkrprobptr++) * dblsz;
   diff = dblobs - expect;
   sumchi += (diff * diff / expect);

   est_xsq = popmu = 0.0;
   p = (double *) pkrprob;
   q = (double *) p + 16;
   while (p < q)
      {
      if (*p == 0.0) break;
      expect = *p * dblsz;
      popmu   += (expect * *p);
      est_xsq += (expect * expect * *p);
      p++;
      } /* for each hand */
   musq = popmu * popmu;
   popvar   = est_xsq -  musq;
   popstdev = sqrt(popvar);
   std_err  = popstdev / rootsz;
   printf("                    "
      "%d Dice Poker\n", cubes);
   printf("Hand        P(hand) "
      "               "
      "Total P(hand) "
      "         Z Score\n");
   totprob = 0.0;
   pkrprobptr = (double *) pkrprob;

   totprob += *pkrprobptr;
   expect = *pkrprobptr * dblsz;
   diff = expect - popmu;
   zval = diff / popstdev;
   printf("5 kind   %22.17f %22.17f %10.4f\n",
      *pkrprobptr++, totprob, zval);

   totprob += *pkrprobptr;
   expect = *pkrprobptr * dblsz;
   diff = expect - popmu;
   zval = diff / popstdev;
   printf("4 kind   %22.17f %22.17f %10.4f\n",
      *pkrprobptr++, totprob, zval);

   totprob += *pkrprobptr;
   expect = *pkrprobptr * dblsz;
   diff = expect - popmu;
   zval = diff / popstdev;
   printf("straight %22.17f %22.17f %10.4f\n",
      *pkrprobptr++, totprob, zval);

   totprob += *pkrprobptr;
   expect = *pkrprobptr * dblsz;
   diff = expect - popmu;
   zval = diff / popstdev;
   printf("full hse %22.17f %22.17f %10.4f\n",
      *pkrprobptr++, totprob, zval);

   totprob += *pkrprobptr;
   expect = *pkrprobptr * dblsz;
   diff = expect - popmu;
   zval = diff / popstdev;
   printf("3 kind   %22.17f %22.17f %10.4f\n",
      *pkrprobptr++, totprob, zval);

   totprob += *pkrprobptr;
   expect = *pkrprobptr * dblsz;
   diff = expect - popmu;
   zval = diff / popstdev;
   printf("2 pairs  %22.17f %22.17f %10.4f\n",
      *pkrprobptr++, totprob, zval);

   totprob += *pkrprobptr;
   expect = *pkrprobptr * dblsz;
   diff = expect - popmu;
   zval = diff / popstdev;
   printf("1 pair   %22.17f %22.17f %10.4f\n",
      *pkrprobptr++, totprob, zval);

   totprob += *pkrprobptr;
   expect = *pkrprobptr * dblsz;
   diff = expect - popmu;
   zval = diff / popstdev;
   printf("other    %22.17f %22.17f %10.4f\n",
      *pkrprobptr++, totprob, zval);
   printf("\n");

   sumx = sumxsqd = totportion = 0.0;
   pkrprobptr = (double *) pkrprob;
   printf("Hand        Observed "
      "      Portion "
      "     Population "
      "   Z Score\n");

   sumx    += fivekind * *pkrprobptr;
   sumxsqd += (fivekind * fivekind * *pkrprobptr);
   portion = (double) fivekind / dblsz;
   totportion += portion;
   expect = *pkrprobptr * dblsz;
   diff = fivekind - expect;
   zval = diff / std_err;
   printf("5 kind     %9d %14.8f %14.8f %10.4f\n",
      fivekind, portion,
      *pkrprobptr++, zval);

   sumx    += fourkind * *pkrprobptr;
   sumxsqd += (fourkind * fourkind * *pkrprobptr);
   portion = (double) fourkind / dblsz;
   totportion += portion;
   expect = *pkrprobptr * dblsz;
   diff = fourkind - expect;
   zval = diff / std_err;
   printf("4 kind     %9d %14.8f %14.8f %10.4f\n",
      fourkind, portion,
      *pkrprobptr++, zval);

   sumx    += straight * *pkrprobptr;
   sumxsqd += (straight * straight * *pkrprobptr);
   portion = (double) straight / dblsz;
   totportion += portion;
   expect = *pkrprobptr * dblsz;
   diff = straight - expect;
   zval = diff / std_err;
   printf("straight   %9d %14.8f %14.8f %10.4f\n",
      straight, portion,
      *pkrprobptr++, zval);

   sumx    += fullhse * *pkrprobptr;
   sumxsqd += (fullhse * fullhse * *pkrprobptr);
   portion = (double) fullhse / dblsz;
   totportion += portion;
   expect = *pkrprobptr * dblsz;
   diff = fullhse - expect;
   zval = diff / std_err;
   printf("full hse   %9d %14.8f %14.8f %10.4f\n",
      fullhse, portion,
      *pkrprobptr++, zval);

   sumx    += threekind * *pkrprobptr;
   sumxsqd += (threekind * threekind * *pkrprobptr);
   portion = (double) threekind / dblsz;
   totportion += portion;
   expect = *pkrprobptr * dblsz;
   diff = threekind - expect;
   zval = diff / std_err;
   printf("3 kind     %9d %14.8f %14.8f %10.4f\n",
      threekind, portion,
      *pkrprobptr++, zval);

   sumx    += twopr * *pkrprobptr;
   sumxsqd += (twopr * twopr * *pkrprobptr);
   portion = (double) twopr / dblsz;
   totportion += portion;
   expect = *pkrprobptr * dblsz;
   diff = twopr - expect;
   zval = diff / std_err;
   printf("2 pairs    %9d %14.8f %14.8f %10.4f\n",
      twopr, portion,
      *pkrprobptr++, zval);

   sumx    += onepr * *pkrprobptr;
   sumxsqd += (onepr * onepr * *pkrprobptr);
   portion = (double) onepr / dblsz;
   totportion += portion;
   expect = *pkrprobptr * dblsz;
   diff = onepr - expect;
   zval = diff / std_err;
   printf("1 pair     %9d %14.8f %14.8f %10.4f\n",
      onepr, portion,
      *pkrprobptr++, zval);

   sumx    += misc * *pkrprobptr;
   sumxsqd += (misc * misc * *pkrprobptr);
   portion = (double) misc / dblsz;
   totportion += portion;
   expect = *pkrprobptr * dblsz;
   diff = misc - expect;
   zval = diff / std_err;
   printf("other      %9d %14.8f %14.8f %10.4f\n",
      misc, portion,
      *pkrprobptr++, zval);

   printf("total      %9d %14.8f %14.8f\n",
      tothand,
      totportion,
      totprob);
   printf("\n");

   printf("                   Mean "
      "            Stdev "
      "        Z Score\n");
   printf("Population %16.6f %16.6f\n",
      popmu, popstdev);
   variance = sumxsqd - (sumx * sumx);
   zscore = (sumx - popmu) / std_err;
   printf("Observed   %16.6f %16.6f %12.4f\n",
      sumx, sqrt(variance), zscore);
   printf("\n");
   printf("Chi-square %f\n", sumchi);
   chirange(7,&negtblv,&postblv);
   printf("Range at 95 percent: %f  to  %f\n",
      negtblv, postblv);
   return(0);
   } /* main */
