/*
dice.c Version 1.5.0 - Dice Rolling Test
Copyright (C) 2005-2010  dondalah721@yahoo.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

/* This test is based on: */
/* Lincoln L. Chao */
/* Statistics for Management */
/* Palo Alto, CA: The Scientific Press, 1984 */
/* Chapter 6, Expected Value and Population Parameters */
/* Section 2, Population Mean and Variance */

/* Lincoln L. Chao was at California State University, */
/* Long Beach, CA, while writing this book. */

/* Sample test: */

/* dice 10000 5 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "rnd.h"

void putstx(pgm)
char *pgm;
   {
   fprintf(stderr,"Usage: %s size dice\n",
      pgm);
   fprintf(stderr,"Where size is 30 to 1000000\n");
   fprintf(stderr,"      dice is  2 to 8\n");
   exit(1);
   } /* putstx */

int main(argc,argv)
int argc;
char **argv;
   {
   int i,j;
   int size;
   int cubes;
   int pwr;
   int score;
   int maxscore;
   int degf;
   int min;
   int max;
   int *obs;
   int *obsptr;
   int *obsend;
   int *grpptr;
   int *grpend;
   int grp[16];
   int *sumptr;
   int *sumend;
   int *sumdice;
   double dblcubes;
   double dblpwr;
   double dblscore;
   double dblobs;
   double dbli;
   double zval;
   double zscore;
   double *p,*q;
   double *prob;
   double *probptr;
   double totprob;
   double musq;
   double est_xsq;
   double popmu;
   double popvar;
   double popstdev;
   double std_err;
   double expect;
   double mean;
   double variance,stdev;
   double diff;
   double sumchi;
   double dblsz;
   double rootsz;
   double sumx,sumxsqd;
   double negtblv,postblv;
   void chirange(int degf, double *lorange,
      double *hirange);
   if (argc != 3) putstx(*argv);
   size = atoi(*(argv+1));
   if (size < 30 || size > 1000000)
      {
      fprintf(stderr,"Invalid sample size.\n");
      putstx(*argv);
      } /* bad size */
   dblsz  = (double) size;
   rootsz = sqrt(dblsz);
   cubes = atoi(*(argv+2));
   if (cubes < 2 || cubes > 8)
      {
      fprintf(stderr,"Invalid number of dice.\n");
      putstx(*argv);
      } /* bad cubes */
   dblcubes = (double) cubes;
   maxscore = cubes * 6;
   dblpwr = (double) pow(6.0,dblcubes);
   pwr = (int) dblpwr;
   sd = (unsigned char *) rndinit();
   if (sd == NULL)
      {
      fprintf(stderr,"dice: out of memory "
	 "allocating sd.\n");
      exit(1);
      } /* out of mem */
   sumdice = (int *) malloc((maxscore+8) * sizeof(int));
   if (sumdice == NULL)
      {
      fprintf(stderr,"dice: out of memory "
	 "allocating population array.\n");
      exit(1);
      } /* out of memory */
   prob = (double *) malloc((maxscore+8) * sizeof(double));
   if (prob == NULL)
      {
      fprintf(stderr,"dice: out of memory "
	 "allocating probability array.\n");
      exit(1);
      } /* out of memory */
   obs = (int *) malloc((maxscore+8) * sizeof(int));
   if (obs == NULL)
      {
      fprintf(stderr,"dice: out of memory "
	 "allocating observation array.\n");
      exit(1);
      } /* out of memory */
   printf("Total observations %d\n", size);
   printf("Probability Distribution\n");
   printf("x = score after rolling "
      "%d dice\n", cubes);
   printf("    x    P(x) "
      "                  "
      "Total P(x) "
      "            z\n");
   sumptr = (int *) sumdice;
   sumend = (int *) sumdice + maxscore + 1;
   while (sumptr < sumend) *sumptr++ = 0;
   grpptr = (int *) grp;
   grpend = (int *) grp + cubes;
   while (grpptr < grpend) *grpptr++ = 1;
   i = pwr;
   while (i--)
      {
      score = 0;
      grpptr = (int *) grp;
      grpend = (int *) grp + cubes;
      while (grpptr < grpend) score += *grpptr++;
      sumptr = (int *) sumdice + score;
      (*sumptr)++;
      grpend = (int *) grp + cubes - 1;
      grpptr = (int *) grp;
      while (grpend >= grpptr)
	 {
	 (*grpend)++;
	 if (*grpend > 6)
	    {
	    *grpend = 1;
	    grpend--;
	    } /* if carry */
	 else break;
	 } /* from low order die to high order die */
      } /* for each permutation of dice */
   p = (double *) prob;
   q = (double *) prob + maxscore + 1;;
   while (p < q) *p++ = 0.0;
   totprob = 0.0;
   sumptr = (int *) sumdice;
   sumend = (int *) sumdice + maxscore + 1;
   p = (double *) prob;
   while (sumptr < sumend)
      {
      if (*sumptr > 0)
	 {
	 *p = (double) *sumptr / dblpwr;
         totprob += *p;
	 } /* if valid score */
      p++;
      sumptr++;
      } /* for each combination */
   popmu = 0.0;
   p = prob;
   q = p + maxscore + 1;
   sumptr = (int *) sumdice;
   i = 0;
   while (p < q)
      {
      if (*sumptr > 0)
         popmu += ((double) i * *p);
      i++;
      sumptr++;
      p++;
      } /* for each score of the dice */
   musq = popmu * popmu;
   est_xsq = 0.0;
   p = (double *) prob;
   q = (double *) p + maxscore + 1;
   sumptr = (int *) sumdice;
   i = 0;
   while (p < q)
      {
      if (*sumptr > 0)
         est_xsq += ((double) (i * i) * *p);
      i++;
      sumptr++;
      p++;
      } /* for each score of the dice */
   popvar   = est_xsq -  musq;
   popstdev = sqrt(popvar);
   std_err  = popstdev / rootsz;
   degf = i = 0;
   totprob = 0.0;
   p = (double *) prob;
   q = (double *) p + maxscore + 1;
   sumptr = (int *) sumdice;
   while (p < q)
      {
      if (*sumptr > 0)
	 {
         dbli = (double) i;
         zval = (dbli - popmu) / popstdev;
         totprob += *p;
         printf("%5d %22.17f %22.17f %9.4f\n",
	    i, *p, totprob, zval);
	 degf++;
	 } /* if valid probability */
      i++;
      sumptr++;
      p++;
      } /* for each # of heads */
   printf("\n");
   obsptr = obs;
   obsend = obsptr + maxscore + 1;
   while (obsptr < obsend) *obsptr++ = 0;
   sumx = sumxsqd = 0.0;
   min =  999999999;
   max = -999999999;
   i = size;
   while (i--)
      {
      score = 0;
      j = cubes;
      while (j--)
         score += (int) (rndnum(6,sd) + 1);
      obsptr = obs + score;
      (*obsptr)++;
      dblscore = (double) score;
      sumx    += dblscore;
      sumxsqd += (dblscore * dblscore);
      if (score < min) min = score;
      if (score > max) max = score;
      } /* generate histogram */
   variance = (sumxsqd - (sumx * sumx / dblsz))
      / (dblsz - 1.0);
   stdev = sqrt(variance);
   sumchi = 0.0;
   obsptr = (int *) obs;
   obsend = (int *) obsptr + maxscore + 1;
   probptr = (double *) prob;
   sumptr  = (int *) sumdice;
   while (obsptr < obsend)
      {
      if (*sumptr > 0)
	 {
         dblobs = (double) *obsptr;
         expect = (*probptr) * dblsz;
         diff = dblobs - expect;
         sumchi += (diff * diff / expect);
	 } /* if valid probability */
      obsptr++;
      probptr++;
      sumptr++;
      } /* sum chi-sq */
   mean = sumx / dblsz;
   zscore = (mean - popmu) / std_err;
   printf("             Mean "
      "      Variance   Stdev "
      "     Z Score      Min     Max\n");
   printf("Population %10.6f %10.6f %10.6f\n",
      popmu, popvar, popstdev);
   printf("Observed   %10.6f %10.6f %10.6f %10.6f %7d %7d\n",
      mean, variance, sqrt(variance), zscore, min, max);
   printf("\n");
   printf("Chi-square %f\n", sumchi);
   chirange(degf-1,&negtblv,&postblv);
   printf("Range at 95 percent: %f  to  %f\n",
      negtblv, postblv);
   return(0);
   } /* main */
