/*
coupon.c Version 1.5.0 - Coupon Collector's Test
Copyright (C) 2002-2010   dondalah721@yahoo.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

/* This test is based on */
/* Donald E. Knuth */
/* Fundamental Algorithms, Vol. 2 */
/* Chapter 3.3.2, Empirical Tests */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "stat.h"
#include "rnd.h"

void putstx(pgm)
char *pgm;
   {
   fprintf(stderr,"Usage: %s digits segments size\n",
      pgm);
   fprintf(stderr,"Where digits is 2 - 14\n");
   fprintf(stderr,"      segments  is 2 - 15\n");
   fprintf(stderr,"      size is 2 - 1000000\n");
   exit(1);
   } /* putstx */

int factorial(num)
int num;
   {
   int i,fact;
   i = 1;
   fact = 1;
   while (i++ < num) fact *= i;
   return(fact);
   } /* factorial */

int main(argc,argv)
int argc;
char **argv;
   {
   int i,j,s,r,dgts,segs,size;
   int dgt,q,k;
   int *kount;
   int *occur;
   double prob,v,rslt,negtblv,postblv;
   double tmp;
   if (argc != 4) putstx(*argv);
   dgts = atoi(*(argv+1));
   if (dgts < 2 || dgts > 14)
      {
      fprintf(stderr,"Invalid digits\n");
      putstx(*argv);
      } /* invalid digits */
   segs = atoi(*(argv+2));
   if (segs < 2 || segs > 15)
      {
      fprintf(stderr,"Invalid segments\n");
      putstx(*argv);
      } /* invalid segments */
   if (dgts >= segs)
      {
      fprintf(stderr,"Digits is not less than segments\n");
      putstx(*argv);
      } /* dgts >= segs */
   size = atoi(*(argv+3));
   if (size < 2 || size > 1000000)
      {
      fprintf(stderr,"Invalid size\n");
      putstx(*argv);
      } /* invalid size */
   if (size < ((segs-dgts+1)*10))
      {
      fprintf(stderr,"Size is too small\n");
      putstx(*argv);
      } /* size < segs */
   kount = (int *) malloc(segs * sizeof(int) + 16);
   if (kount == NULL)
      {
      fprintf(stderr,"Out of memory allocating kount\n");
      exit(1);
      } /* out of memory */
   occur = (int *) malloc(segs * sizeof(int) + 16);
   if (occur == NULL)
      {
      fprintf(stderr,"Out of memory allocating occur\n");
      exit(1);
      } /* out of memory */
   sd = (unsigned char *) rndinit();
   if (sd == NULL)
      {
      fprintf(stderr,"Out of memory allocating sd\n");
      exit(1);
      } /* out of memory */

   /* Step C1 */
   j = -1;
   s = 0;
   for (i=0;i<=segs;i++)
      {
      kount[i] = 0;
      } /* init kount */
   /* Step C2 */
   while (s < size)
      {
      q = r = 0;
      for (k=0;k<dgts;k++)
         {
         occur[k] = 0;
         } /* init occur */
      /* Step C3 */
      while (q < dgts)
         {
         do {
            r++;
            j++;
            dgt = rndnum(dgts,sd);
            } while (occur[dgt]);
         /* Step C4 */
         occur[dgt] = 1;
         q++;
         } /* while q < d */
      /* Step C5 */
      if (r >= segs) kount[segs]++;
      else kount[r]++;
      /* Step C6 */
      s++;
      } /* size loop */

   v = 0.0;
   i = dgts;
   while (i < segs)
      {
      prob = (double) factorial(dgts)
         / pow((double) dgts,(double) i);
      prob *= (double) stirl2(i-1,dgts-1);
      v += (double) ((double) kount[i]  * (double) kount[i]  / prob);
      i++;
      } /* for i = d < t */
   tmp = (double) factorial(dgts)
      / pow((double) dgts,(double) segs-1);
   tmp *= (double) stirl2(segs-1,dgts);
   prob = 1.0 - tmp;
   v += (double) ((double) kount[segs]  * (double) kount[segs]  / prob);
   rslt = (double) v / (double) size - (double) size;
   chirange(segs-dgts+1,&negtblv,&postblv);
   printf("Chi-square %f\n", rslt);
   printf("Range at 95 percent: %f  to  %f\n",
      negtblv, postblv);
   return(0);
   } /* main */
