/*
bnmsz.c Version 1.5.0 - Calculate sample size for a
binomial distribution based on:
   confidence level
   error of estimation
   probability of success
Copyright (C) 2005-2010  dondalah721@yahoo.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

/* This test is based on: */
/* Lincoln L. Chao */
/* Statistics for Management */
/* Palo Alto, CA: The Scientific Press, 1984 */
/* Chapter 9, Statistical Estimation */
/* Section 4, Determination of Sample Size */

/* Lincoln L. Chao was at California State University, */
/* Long Beach, CA, while writing this book. */

/* Sample test: */

/* bnmsz 95.0 0.01 0.6 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

void putstx(pgm)
char *pgm;
   {
   fprintf(stderr,"Usage: %s confidence "
      "error_rate p_success\n",
      pgm);
   fprintf(stderr,"Where confidence is "
      "90.0, 95.0, 98.0, 99.0\n");
   fprintf(stderr,"      error_rate is 0.001 to 0.1\n");
   fprintf(stderr,"      p_success is 0.1 to 0.9\n");
   fprintf(stderr,"Example: %s "
      "95.0 0.02 0.6\n",
      pgm);
   fprintf(stderr,"p_success is the probability "
      "of success for each simple random event\n");
   exit(1);
   } /* putstx */

int main(argc,argv)
int argc;
char **argv;
   {
   int size;
   double confidence;
   double errrate;
   double psuccess;
   int getn(double confidence, double errrate,
      double psuccess);
   if (argc != 4) putstx(*argv);
   confidence = atof(*(argv+1));
   if (confidence == 90.0 || confidence == 95.0
      || confidence == 98.0 || confidence == 99.0);
   else
      {
      fprintf(stderr,"Invalid confidence level %s.\n",
	 *(argv+1));
      putstx(*argv);
      } /* bad confidence */
   errrate = atof(*(argv+2));
   if (errrate < 0.001 || errrate > 0.1)
      {
      fprintf(stderr,"Invalid error rate %s.\n",
	 *(argv+2));
      putstx(*argv);
      } /* bad error rate */
   psuccess = (double) atof(*(argv+3));
   if (psuccess < 0.1)
      {
      fprintf(stderr,"Probability of success "
	 "is too small.\n");
      putstx(*argv);
      } /* psuccess too small */
   if (psuccess > 0.9)
      {
      fprintf(stderr,"Probability of success "
	 "is too large.\n");
      putstx(*argv);
      } /* if psuccess too large */
   size = getn(confidence, errrate, psuccess);
   printf("Sample size is %d\n", size);
   return(0);
   } /* main */
