/* tst.c Version 1.5.0. test datagen library */
/* Copyright (C) 2004-2010   dondalah721@yahoo.com (Dondalah) */

/* This program is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* This program is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       59 Temple Place - Suite 330 */
/*       Boston, MA  02111-1307, USA. */

/* This program is compiled with Free Turbo C 2.0 */
/* From the command line, use: */

/*                make -fdatagen.mak     */

/* When you design your own test data program, */
/* copy this program and re-arrange the subroutine */
/* calls to fit your format */

/* copy datagen.mak */
/* include your test data program where */
/* tst.exe and tst.obj are compiled */
/* you won't need the subroutines in your */
/* make file, because they will be already */
/* compiled into your subroutine library, */
/* called datagen.lib */
/* leave CFLAGS and LDFLAGS the same in your */
/* own make file */
/* see "sample.mak" for a sample make file */

#include "datagen.h"

int main(int argc,char **argv)
   {
   int i;
   int rslt;
   dgfmt *dg;            /* global parameters */
   slctfmt *slct1;       /* first selection list */
   char *code1;          /* code list for dgltr */
   char *hxcode;         /* hexadecimal characters for dgltr */
   char *bincode;        /* binary      characters for dgltr */
   char optfname[128];   /* output file name */
   unsigned char mainseed[32];   /* hold for primary seed */
   unsigned char seed1[32];      /* field seed */
   if (argc > 3) putstx(*argv);  /* too many arguments */
   dg = (dgfmt *) dginit();      /* initialize global structure */
   if (dg == NULL)
      {
      fprintf(stderr,"tst: out of memory "
         "initializing dg structure\n");
      } /* out of mem */
   optfname[0] = '\0';     /* default: stdout */
   i = 1;
   while (i < argc)
      {
      rslt = strcmp(*(argv+i),"-v");
      if (!rslt)
         {
         dg->verbose = 1;
         i++;
         continue;
         }
      rslt = strcmp(*(argv+i),"-h");
      if (!rslt)
         {
         putstx(*argv);        /* syntax help */
         i++;
         continue;
         }
      rslt = strcmp(*(argv+i),"-o");
      if (!rslt)
         {
         if (i+1 < argc)
            {
            strcpy(optfname,*(argv+i+1));    /* output file */
            dg->opthndl = opnopt(optfname);  /* open */
            i += 2;
            continue;
            } /* if parm available */
         else
            {
            fprintf(stderr,"tst: missing "
               "output file name\n");
            putstx(*argv);
            } /* bad optfile */
         } /* if output file */
      else
         {
         fprintf(stderr,"tst: invalid "
            "parameter %s\n",
            *(argv+i));
         putstx(*argv);
         } /* invalid parm */
      } /* for each parm */
   slct1 = (slctfmt *) slctinit(dg);     /* set up first */
   if (slct1 == NULL)                        /* selection list */
      {
      fprintf(stderr,"tst: out of memory "
         "initializing the slct1 structure\n");
      } /* out of mem */
   slctisrt(dg,slct1,"abcdef");             /* three values */
   slctisrt(dg,slct1,"ghi");
   slctisrt(dg,slct1,"jklmnopqrstu");
   code1   = (char *) "012";                 /* code definitions */
   hxcode  = (char *) "0123456789ABCDEF";
   bincode = (char *) "01";
   putstr(dg->opthndl,"abc ");         /* dummy title line */
   putstr(dg->opthndl,"\n");

   /***********************************************/
   /*                                             */
   /*         regression test seed                */
   /*                                             */
   /* First byte should be odd.                   */
   /*                                             */
   /***********************************************/
   strncpy((char *) dg->sd,"abcdefgh        ",16);
			 /* ....+....1....+....2 */
   *dg->sd |= (unsigned char) 1;
   i = 64;
   while (i--) rnd(dg->sd);

   i = 11;                    /* first transaction of */
   while (i--)                /* 11 records */
      {                       /* a transaction is a */
      dg->lentype = CONSTANTLEN;          /* record group */
      dg->totlen  = 0;
      dg->fromlen = 10;
      dg->tolen   = 0;
      dg->padstr  = NULL;
      dgseq(dg);                /* transaction number */
      putstr(dg->opthndl,":");      /* delimiter */
      dg->lentype = CONSTANTLEN;
      dg->totlen  = 0;
      dg->tolen   = 0;
      dg->fromlen = 4;              /* upper and lower case */
      dgalfa(dg);                   /* alpha */
      putstr(dg->opthndl,":");      /* delimiter */
      dg->lentype = CONSTANTLEN;
      dg->totlen  = 0;
      dg->fromlen = 4;
      dg->tolen   = 0;
      dgnum(dg);                   /* numeric */
      putstr(dg->opthndl,":abc\" \"def:");    /* delimiter with */
      dg->lentype = CONSTANTLEN;             /* embedded quotes */
      dg->totlen  = 0;
      dg->tolen   = 0;
      dg->fromlen = 4;
      dgalfa(dg);
      putstr(dg->opthndl,":");      /* delimiter */
      dg->lentype = CONSTANTLEN;
      dg->fromlen = 7;              /* integer length */
      dg->tolen   = 0;
      dg->dec     = 5;              /* decimals */
      dg->sign    = POSTSIGN;
      dgreal(dg);              /* real number */
      putstr(dg->opthndl,"\n");
      dg->slctmax = 3;            /* see initialization above */
      dgslct(dg,slct1);        /* select between values */
      putstr(dg->opthndl,":");      /* delimiter */
      dg->lentype = CONSTANTLEN;
      dg->fromlen = 7;
      dg->dec     = 5;
      dg->sign    = PRESIGN;      /* real with different */
      dgreal(dg);              /* sign position */
      putstr(dg->opthndl,":");      /* delimiter */
      dg->lentype = CONSTANTLEN;
      dg->fromlen = 7;
      dg->dec     = 5;
      dg->sign    = ACCTSIGN;     /* real with different */
      dgreal(dg);              /* sign position */
      putstr(dg->opthndl,":");      /* delimiter */
      dg->lentype = CONSTANTLEN;
      dg->fromlen = 5;
      dg->dec     = 0;            /* real with no decimals */
      dg->sign    = PRESIGN;
      dgreal(dg);
      putstr(dg->opthndl,"\n");
      dg->lentype = CONSTANTLEN;
      dg->fromlen = 64;
      dgtext(dg);             /* alpha with embedded spaces */
      putstr(dg->opthndl,"\n");
      dg->lentype = CONSTANTLEN;
      dg->padding = 0;
      dg->totlen  = 0;
      dg->tolen   = 0;
      dg->fromlen = 64;          /* see initialization above */
      dgltr(dg,code1);        /* coded data */
      putstr(dg->opthndl,"\n");
      dg->lentype = CONSTANTLEN;
      dg->padding = 0;
      dg->totlen  = 0;
      dg->tolen   = 0;
      dg->fromlen = 64;
      dgltr(dg,hxcode);       /* hexadecimal */
      putstr(dg->opthndl,"\n");
      dg->lentype = CONSTANTLEN;
      dg->padding = 0;
      dg->totlen  = 0;
      dg->tolen   = 0;
      dg->fromlen = 64;
      dgltr(dg,bincode);      /* binary */
      putstr(dg->opthndl,"\n");
      /* financial test data requires small and */
      /* large numbers to test extreme conditions */
      /* logarithmic distribution is base 2 */
      dg->lentype = CONSTANTLEN;     /* 11 decimal */
      dg->fromlen = 24;              /* 24 bit integer */
      dg->dec     = 11;              /* logarithmic distrib */
      dg->sign    = PRESIGN;         /* good for financial */
      dgamt(dg);                     /* data */
      putstr(dg->opthndl,":");       /* delimiter */
      dg->loflrng = -999.0;          /* flat distribution */
      dg->hiflrng =  999.0;          /* floating point range */
      dg->dec     = 7;
      dg->sign    = PRESIGN;
      dgflrng(dg);
      putstr(dg->opthndl,":");       /* delimiter */
      dg->lointrng = -999.0;         /* flat distribution */
      dg->hiintrng =  999.0;         /* integer range */
      dg->fromlen  = 7;
      dg->dec      = 0;
      dg->sign     = PRESIGN;
      dgintrng(dg);
      putstr(dg->opthndl,"\n");
      dg->loflrng = -999.0;          /* bell curve distrib */
      dg->hiflrng =  999.0;          /* floating point range */
      dg->dec     = 7;
      dg->sign    = PRESIGN;
      dgafrng(dg);
      putstr(dg->opthndl,":");       /* delimiter */
      dg->lointrng = -999.0;         /* bell curve distrib */
      dg->hiintrng =  999.0;         /* integer range */
      dg->fromlen  = 7;
      dg->dec      = 0;
      dg->sign     = PRESIGN;
      dgairng(dg);
      putstr(dg->opthndl,"\n");
      } /* transaction loop */
   dg->rcdnum = 0L;
   i = 11;                            /* second record group */
   while (i--)
      {
      dg->lentype = CONSTANTLEN;
      dg->fromlen = 10;
      dgseq(dg);                  /* sequence number */
      putstr(dg->opthndl,":");    /* delimiter */
      dg->lentype = LENRANGE;
      dg->padding = 0;
      dg->totlen  = 0;
      dg->fromlen = 4;
      dg->tolen   = 8;            /* variable length alpha */
      dgalfa(dg);
      putstr(dg->opthndl,":");    /* delimiter */
      dg->lentype = LENRANGE;
      dg->fromlen = 4;            /* log base 10 distrib */
      dg->tolen   = 8;            /* variable length integer */
      dgnum(dg);
      putstr(dg->opthndl,":");    /* delimiter */
      dg->lentype = LENRANGE;
      dg->padding = 0;
      dg->totlen  = 0;
      dg->fromlen = 4;
      dg->tolen   = 8;
      dgalfa(dg);
      putstr(dg->opthndl,":");    /* delimiter */
      dg->lentype = LENRANGE;     /* log base 10 distrib */
      dg->fromlen = 7;            /* variable length real */
      dg->tolen   = 14;
      dg->dec     = 5;
      dg->sign    = POSTSIGN;
      dgreal(dg);
      putstr(dg->opthndl,"\n");
      dg->lentype = LENRANGE;     /* log base 10 distrib */
      dg->fromlen = 7;            /* variable length real */
      dg->tolen   = 14;           /* different sign position */
      dg->dec     = 5;
      dg->sign    = PRESIGN;
      dgreal(dg);
      putstr(dg->opthndl,":");    /* delimiter */
      dg->lentype = LENRANGE;     /* log base 10 distrib */
      dg->fromlen = 7;            /* variable length real */
      dg->tolen   = 14;           /* different sign position */
      dg->dec     = 5;
      dg->sign    = ACCTSIGN;
      dgreal(dg);
      putstr(dg->opthndl,":");    /* delimiter */
      dg->lentype = LENRANGE;     /* log base 10 distrib */
      dg->fromlen = 5;            /* variable length real */
      dg->tolen   = 14;           /* different sign position */
      dg->dec     = 0;            /* no decimals */
      dg->sign    = PRESIGN;
      dgreal(dg);
      putstr(dg->opthndl,"\n");
      dg->lentype = LENRANGE;     /* variable length text */
      dg->fromlen = 10;
      dg->tolen   = 64;
      dgtext(dg);
      putstr(dg->opthndl,"\n");
      dg->lentype = LENRANGE;     /* variable length  */
      dg->padding = 0;
      dg->totlen  = 0;
      dg->fromlen = 10;           /* coded data */
      dg->tolen   = 64;
      dgltr(dg,code1);
      putstr(dg->opthndl,"\n");
      dg->lentype = LENRANGE;     /* variable length  */
      dg->padding = 0;
      dg->totlen  = 0;
      dg->fromlen = 10;           /* hexadecimal */
      dg->tolen   = 64;
      dgltr(dg,hxcode);
      putstr(dg->opthndl,"\n");
      dg->lentype = LENRANGE;     /* variable length  */
      dg->fromlen = 10;           /* binary */
      dg->tolen   = 64;
      dg->padding = 0;
      dg->totlen  = 0;
      dgltr(dg,bincode);
      putstr(dg->opthndl,"\n");
      dg->lentype = LENRANGE;     /* right justified */
      dg->fromlen = 10;           /* left padded */
      dg->tolen   = 50;           /* variable length alpha */
      dg->totlen  = 64;
      dg->padding = LPAD;
      dg->padstr  = (char *) "01";
      dgalfa(dg);
      putstr(dg->opthndl,"\n");
      dg->lentype = LENRANGE;     /* left justified */
      dg->fromlen = 10;           /* right padded */
      dg->tolen   = 50;           /* variable length alpha */
      dg->totlen  = 64;
      dg->padding = RPAD;
      dg->padstr  = (char *) "01";
      dgalfa(dg);
      putstr(dg->opthndl,"\n");
      dg->lentype = LENRANGE;     /* right justified */
      dg->fromlen = 10;           /* left padded */
      dg->tolen   = 50;           /* variable length */
      dg->totlen  = 64;           /* binary */
      dg->padding = LPAD;
      dg->padstr  = (char *) "ab";
      dgltr(dg,"01");
      putstr(dg->opthndl,"\n");
      dg->lentype = LENRANGE;     /* left justified */
      dg->fromlen = 10;           /* right padded */
      dg->tolen   = 50;           /* variable length */
      dg->totlen  = 64;           /* binary */
      dg->padding = RPAD;
      dg->padstr  = (char *) "ab";
      dgltr(dg,"01");
      /************************************************************/
      dg->tolen   = 0;            /* clean parameters */
      dg->totlen  = 0;
      dg->padding = 0;
      /************************************************************/
      putstr(dg->opthndl,"\n");
      dg->lentype = CONSTANTLEN;    /* 64 bit */
      dg->fromlen = 64;             /* logarithmic distrib */
      dgint(dg);                 /* integer */
      putstr(dg->opthndl,"\n");
      } /* transaction loop */
   dg->rcdnum = 0L;                  /* third record group */
   dg->sinestep = M_PI / 6.0;       /* sine delta x */
   dg->sinex    = - dg->sinestep;  /* smallest x value */
   i = 11;
   while (i--)
      {
      dg->lentype = CONSTANTLEN;
      dg->fromlen = 10;
      dgseq(dg);                 /* sequence number */
      putstr(dg->opthndl,":");    /* delimiter */
      dg->lentype = CONSTANTLEN;    /* 128 bit integer */
      dg->fromlen = 128;
      dgint(dg);
      putstr(dg->opthndl,"\n");
      dg->lentype = LENRANGE;       /* 128-192 bit integer */
      dg->fromlen = 128;
      dg->tolen   = 192;
      dgint(dg);
      putstr(dg->opthndl,"\n");
      dg->loflrng = 3.0;        /* sine magnitude */
      dg->hiflrng = 5.0;        /* sine axis      */
      dg->dec = 9;
      dgsine(dg);            /* plot sine wave */
      putstr(dg->opthndl,":");    /* delimiter */
      dg->dec = 11;               /* scientific julian day */
      dgjul(dg);
      putstr(dg->opthndl,"\n");
      dg->loflrng = -3.0;          /* e^x */
      dg->hiflrng =  3.0;
      dg->dec     = 11;
      dgexp(dg);
      putstr(dg->opthndl,":");     /* delimiter */
      dg->lentype = CONSTANTLEN;
      dg->fromlen = 15;
      dg->loflrng =   0.03;        /* log(x) */
      dg->hiflrng = 300.0;
      dg->dec     = 11;
      dg->sign    = PRESIGN;
      dglog(dg);
      putstr(dg->opthndl,":");     /* delimiter */
      dg->lentype = CONSTANTLEN;
      dg->fromlen = 2;
      dg->tolen   = 0;
      dg->dec     = 0;
      dg->sign    = 0;
      dg->trials  = 10;            /* binomial(n,p) */
      dg->prob    = 0.6;           /* prints # of successes */
      dgbinom(dg);
      putstr(dg->opthndl,":");     /* delimiter */
      dg->lentype = CONSTANTLEN;
      dg->fromlen = 2;
      dg->tolen   = 0;
      dg->dec     = 0;
      dg->sign    = 0;
      dg->prob    = 0.0;           /* prob and trials are */
      dg->trials  = 0;             /* calculated */
      dg->mu      = 2;             /* poisson(mu) */
      dgpois(dg);                  /* prints # of successes */
      putstr(dg->opthndl,"\n");
      dgyear(dg);                  /* date/time fields */
      putstr(dg->opthndl,"/");
      dgmonth(dg);
      putstr(dg->opthndl,"/");
      dgday(dg);
      putstr(dg->opthndl," ");
      dghour(dg);
      putstr(dg->opthndl,":");
      dgmin(dg);
      putstr(dg->opthndl,":");
      dgsec(dg);
      putstr(dg->opthndl," ");
      dg->lentype = CONSTANTLEN;
      dg->fromlen = 10;           /* ticks */
      dgticks(dg);
      putstr(dg->opthndl,"\n");
      /*********************************************************/
      /* Create a tm structure of a random date between */
      /* two julian days. */
      {
      struct tm t;
      char str[128];
      /* first jd is from, second jd is to */
      dgdtrng(dg,2453026.6666666666666666667,
         2453361.6666666666666667, &t);
      /* print the contents of the tm structure */
      /* time is always standard time */
      sprintf(str,"%d %d %d %d %d %d "
         "%d %d isdst %d",
         t.tm_year, t.tm_mon+1, t.tm_mday,
         t.tm_hour, t.tm_min, t.tm_sec,
         t.tm_yday, t.tm_wday, t.tm_isdst);
      putstr(dg->opthndl,str);
      }
      /*********************************************************/
      putstr(dg->opthndl,"\n");
      } /* transaction loop */
   dg->rcdnum = 0L;           /* fourth record group */
   /* Demonstrate field level seed, "seed1". */
   /* Columns are alpha based on: */
   /* sequence  seed1  seed1  mainseed  */
   /* Initialize seed1 to fixed value. */
   /* Each execution of program will have same data. */
   /* This is a technique for regression testing. */
   dgncpy(seed1,
      (unsigned char *) "abcdefgh        ",16);
                      /* ....+....1....+....2 */
   /* randomize seed1 for 64 cycles */
   /* before starting to test */
   i = 64;
   while (i--) rnd(seed1);
   i = 11;
   while (i--)
      {
      dg->lentype = CONSTANTLEN;
      dg->fromlen = 10;
      dgseq(dg);               /* sequence number */
      putstr(dg->opthndl,":");
      /**********************************************************/
      dgncpy(mainseed,dg->sd,16);
      dgncpy(dg->sd,seed1,16);
      dg->lentype = CONSTANTLEN;
      dg->padding = 0;
      dg->totlen  = 0;
      dg->tolen   = 0;
      dg->fromlen = 4;            /* two identical columns */
      dgalfa(dg);
      putstr(dg->opthndl,":");    /* delimiter */
      dgncpy(dg->sd,seed1,16);
      dg->lentype = CONSTANTLEN;
      dg->padding = 0;
      dg->totlen  = 0;
      dg->tolen   = 0;
      dg->fromlen = 4;
      dgalfa(dg);
      dgncpy(seed1,dg->sd,16);
      dgncpy(dg->sd,mainseed,16);
      /**********************************************************/
      putstr(dg->opthndl,":");    /* delimiter */
      dg->lentype = CONSTANTLEN;
      dg->padding = 0;
      dg->totlen  = 0;
      dg->tolen   = 0;
      dg->fromlen = 4;          /* third column is random */
      dgalfa(dg);
      putstr(dg->opthndl,"\n");
      } /* transaction loop */
   cls(dg->opthndl);
   return(0);
   }  /* main */
