/* dgltr.c Version 1.5.0. Generate character set field */
/* Copyright (C) 2004-2010   dondalah721@yahoo.com (Dondalah) */

/* This program is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* This program is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       59 Temple Place - Suite 330 */
/*       Boston, MA  02111-1307, USA. */

/* This program is compiled with Free Turbo C 2.0 */
/* From the command line, use: */

/*                make -fdatagen.mak     */

#include "datagen.h"

void rndltr(dgfmt *dg,char *code)
   {
   int i;
   int ofst;
   int len;
   int padlen;
   int codelen;
   char *p;
   codelen = (int) strlen(code);
   len = (int) calclen(dg);
   dg->strptr = (char *) dg->str;
   padlen = 0;
   if (dg->totlen > len
      && dg->padding == LPAD)
      {
      padlen = dg->totlen - len;
      dgpad(dg,padlen);
      dg->strptr += padlen;
      } /* if padding */
   p = (char *) dg->strptr;
   i = len;
   while (i--)
      {
      ofst = (int) rndnum(codelen,dg->sd);
      *p++ = (char) *(code + ofst);
      } /* for each character set letter */
   *p = '\0';
   if (dg->totlen > len
      && dg->padding == RPAD)
      {
      padlen = dg->totlen - len;
      dg->strptr = (char *) dg->str + len;
      dgpad(dg,padlen);
      } /* if padding */
   } /* rndltr */

void dgltr(dgfmt *dg,char *code)
   {
   rndltr(dg,code);
   putstr(dg->opthndl,dg->str);
   } /* dgltr */
