/* dgintrng.c Version 1.5.0. Generate integer range */
/* Copyright (C) 2004-2010   dondalah721@yahoo.com (Dondalah) */

/* This program is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* This program is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       59 Temple Place - Suite 330 */
/*       Boston, MA  02111-1307, USA. */

/* This program is compiled with Free Turbo C 2.0 */
/* From the command line, use: */

/*                make -fdatagen.mak     */

#include "datagen.h"

void dgintrng(dgfmt *dg)
   {
   int negsw;
   int pfxlen;
   double diff;
   double rslt;
   char str[64];
   if (dg->hiintrng < dg->lointrng)
      {
      fprintf(stderr,"\ndgintrng: invalid "
         "integer range %f to %f\n",
         dg->lointrng, dg->hiintrng);
      fprintf(stderr,"Low end larger than "
         "high end\n");
      exit(1);
      } /* invalid integer range */
   if (dg->lointrng < -999999999999.0)
      {
      fprintf(stderr,"\ndgintrng: invalid "
         "integer range %f to %f\n",
         dg->lointrng, dg->hiintrng);
      fprintf(stderr,"Low end too small.\n");
      exit(1);
      } /* invalid integer range */
   if (dg->hiintrng > 999999999999.0)
      {
      fprintf(stderr,"\ndgintrng: invalid "
         "integer range %f to %f\n",
         dg->lointrng, dg->hiintrng);
      fprintf(stderr,"High end too large.\n");
      exit(1);
      } /* invalid integer range */
   diff = dg->hiintrng - dg->lointrng + 1.0;
   rslt = dg->lointrng + (rndfrac(dg->sd) * diff);
   if (rslt < 0.0) negsw = 1;
   else negsw = 0;
   if (negsw)
      {
      if (dg->sign == PRESIGN)
         putstr(dg->opthndl,"-");
      else if (dg->sign == ACCTSIGN)
         putstr(dg->opthndl,"(");
      } /* if negative */
   sprintf(str,"%.0f",fabs(rslt));
   pfxlen = dg->fromlen - strlen(str);
   if (pfxlen > 0)
      {
      while (pfxlen--)
         putstr(dg->opthndl,"0");
      } /* if leading zeros */
   putstr(dg->opthndl,str);
   if (negsw)
      {
      if (dg->sign == POSTSIGN)
         putstr(dg->opthndl,"-");
      else if (dg->sign == ACCTSIGN)
         putstr(dg->opthndl,")");
      } /* if negative */
   } /* dgintrng */
