/* calclen.c Version 1.5.0. Calculate field length */
/* Copyright (C) 2004-2010   dondalah721@yahoo.com (Dondalah) */

/* This program is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* This program is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to: */

/*       Free Software Foundation, Inc. */
/*       59 Temple Place - Suite 330 */
/*       Boston, MA  02111-1307, USA. */

/* This program is compiled with Free Turbo C 2.0 */
/* From the command line, use: */

/*                make -fdatagen.mak     */

#include "datagen.h"

/* The field length is either fixed, */
/* a range, or an average length. */
/* The average length is the average of */
/* the same range calculated twice. */
/* Therefore it has a rather flat bell curve. */

int calclen(dgfmt *dg)
   {
   int i,totlen,len;
   int diff;
   unsigned int lmt;
   if (dg->fromlen < 0)
      {
      fprintf(stderr,"calclen: invalid "
         "dg->fromlen %d\n", dg->fromlen);
      exit(1);
      } /* invalid fromlen */
   if (dg->lentype == CONSTANTLEN)
      {
      dg->totlen = dg->fromlen;
      return(dg->fromlen);
      } /* if constant length */
   else if (dg->lentype == LENRANGE)
      {
      if (dg->tolen < 0)
         {
         fprintf(stderr,"calclen: invalid "
            "dg->tolen %d\n", dg->tolen);
         exit(1);
         } /* invalid tolen */
      if (dg->tolen < dg->fromlen)
         {
         fprintf(stderr,"calclen: invalid "
            "dg->fromlen %d "
            "dg->tolen %d\n",
	    dg->fromlen, dg->tolen);
         fprintf(stderr,"tolen is less "
	    "than fromlen\n");
         exit(1);
         } /* invalid range */
      diff = (int) (dg->tolen - dg->fromlen + 1);
      lmt = (unsigned int) diff;
      i = (int) rndnum(lmt,dg->sd);
      len = i + dg->fromlen;
      return(len);
      } /* if length range */
   else if (dg->lentype == AVERAGELEN)
      {
      if (dg->tolen < 0)
         {
         fprintf(stderr,"calclen: invalid "
            "dg->tolen %d\n", dg->tolen);
         exit(1);
         } /* invalid tolen */
      if (dg->tolen < dg->fromlen)
         {
         fprintf(stderr,"calclen: invalid "
            "dg->fromlen %d "
            "dg->tolen %d\n",
	    dg->fromlen, dg->tolen);
         fprintf(stderr,"tolen is less "
	    "than fromlen\n");
         exit(1);
         } /* invalid range */
      diff = (int) (dg->tolen - dg->fromlen + 1);
      lmt = (unsigned int) diff;
      i = (int) rndnum(lmt,dg->sd);
      totlen = i + dg->fromlen;
      i = (int) rndnum(lmt,dg->sd);
      totlen += i;
      totlen += dg->fromlen;
      len = totlen >> 1;
      return(len);
      } /* if average length */
   return(dg->fromlen);
   } /* calclen */
