#!/usr/bin/perl

# PROGRAM: menu.pl - Menu Interface - by Adam Fladwood (adam@ols.com)
# VERSION: Version 2.1
#   OTHER: Send questions, comments, and bug reports to adam@ols.com.

# Before using this program make sure that you have read the README file.
# Same goes before making *ANY* changes.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

# If you redistrubute this program you MUST include the origional README
# as is! It does not need to remain the same name, just has to be included
# somewhere within the package. Thank You.

###########################################################################
###              Menu Interface v2.1 Configuration Section              ###
###########################################################################

# 0 = Off
# 1 = On

#### Shell Configurations ####

$File = "/etc/shell.db";                    # Path to Shell Datebase File
$ShellPath = "/usr/local/bin/bash";         # Path to Shell
$ShowShell = "1";                           # Show Shell Access On Menu?
# If this is off, users allowd shell access can still press `S` to get
# into the shell.

#### Misc. Options / Configurations ####

$Passwd = "1";                              # Allow Passwd Changes?
$FingerInfo = "1";                          # Allow CHFN?
$WebSite = "http://127.0.0.1/";             # WebSite Address (For Lynx)
$TelnetAddress = "127.0.0.1";               # Default Telnet Address
$FTPAddress = "127.0.0.1";                  # Default FTP Address

#### Editing Options ####

$AllowEdit = "1";                           # Allow access to edit menu?
$DefaultEdit = "PICO";                      # Name of Text Editor
$EditPath = "/usr/local/bin/pico";        # Path to Editor

#### IRC Options/Configuration ####

$AllowIRC = "1";                            # Allow access to IRC menu?
$IrcClient = "/usr/local/bin/irc";          # Path to IRC Client
$Network1 = "Unix Hackers";                 # Name of IRC Network #1
$Address1 = "irc.unixhackers.com:9000";     # Address of IRC Network #1
$Network2 = "DALnet";                       # Name of IRC Network #2
$Address2 = "irc.dal.net";                  # Address of IRC Network #2
$Network3 = "EFnet";                        # Name of IRC Network #3
$Address3 = "irc.uci.edu";                  # Address of IRC Network #3

#### Mail Options/Configuration ####

$AllowMail = "1";                           # Allow access to Mail menu?
$MailName1 = "ELM";                         # Name of E-Mail Client #1
$MailPath1 = "/usr/local/bin/elm";          # Path to E-Mail Client #1
$MailName2 = "PINE";                        # Name of E-Mail Client #2
$MailPath2 = "/usr/local/bin/pine";         # Path to E-Mail Client #2
$MailName3 = "MAIL";                        # Name of E-Mail Client #3
$MailPath3 = "/usr/bin/mail";               # Path to E-Mail Client #3

###########################################################################
###           End of Menu Interface v2.1 Configuration                  ###
###########################################################################

&shell_access;
srand;
sub get_rand {
        local($a,$b) = @_;
        local(@array,$c);
        $c = 0;
        while ($a <= $b) {
                $array[$c++] = $a;
                $a++;
        }
        return int(rand(@array));
}
1;
sub shell_access {
	$found = 0;
	$user = &GetUserName;
	open(UDB, "$File") || die "Error, Can't Open Datebase ($File).\n";
	while($udb = <UDB>) {
        	chop($udb);
        	if($udb eq $user) {
                	$found = 1;
                	break;
        	}
	}
	&SplashScreen
}
sub SplashScreen {
        $hostname = `hostname`;
        system("clear");
	print "\033[1;41m                                                                      Main Menu \n";
	print "\033[0;0m\n\n";
	print "\033[1;32m              M  E  N  U     I  N  T  E  R  F  A  C  E     2  .  0\n\n";
	print "\033[1;32mUsername: $user\n";
	print "\033[1;32mHostname: $hostname\n";
	sleep 1;
	print "\n";
	print "\033[1;31m";
	print "Menu Interface is written by Adam Fladwood (adam\@ols.com).\n";
	print "Please feel free to copy and chage this program, but please\n";
	print "read the README before doing so, Thank-You.\n";
	print "\033[0;0m";
	sleep 5;
	&PrintMenu;
}
sub PrintMenu {
	system("clear");
	print "\033[1;41m                                                                      Main Menu \n";
	print "\n";
 	if($AllowMail eq "1") {
	print "\033[1;44m M \033[0;0m         Electronic Mail\n";
	}
	if($AllowIRC eq "1") {
	print "\033[1;44m I \033[0;0m         Internet Relay Chat\n";
	}
	print "\033[1;44m B \033[0;0m         Browse The Internet\n";
	print "\033[1;44m A \033[0;0m         Account Setup\n";
	if($AllowEdit eq "1") {
	print "\033[1;44m E \033[0;0m         Edit A File\n";
	}
	print "\033[1;44m T \033[0;0m         Telnet\n";
	print "\033[1;44m F \033[0;0m         FTP\n";
	print "\033[1;44m C \033[0;0m         Finger\n";
	print "\033[1;44m W \033[0;0m         Who Is Logged In\n";
	print "\033[1;44m L \033[0;0m         Talk\n";
	print "\n";
	if($ShowShell eq "1") {
	print "\033[1;44m S \033[0;0m         Execute A Shell\n";
	}
	print "\033[1;44m Q \033[0;0m         Exit Menu/System\n";	
	print "\n";
	print "\033[1;41m                            Please Make A Selection                             \n";
	print "\033[0;0mSelection: ";
	$prompt = <STDIN>;
	chop($prompt);
	if($prompt =~ /^m\b/i) {
		if($AllowMail eq "1") {
		&MailMenu;
		}
		&PrintMenu;
	}
	elsif($prompt =~ /^a\b/i) {
		&AccountMenu;
		&PrintMenu;
	}
	elsif($prompt =~ /^i\b/i) {
		if($AllowIRC eq "1") {
		&IrcMenu;
		}
		&PrintMenu;
	}
	elsif($prompt =~ /^b\b/i) {
		system("lynx $WebSite");
		&PrintMenu;
	}
	elsif($prompt =~ /^t\b/i) {
		&TelnetMenu;
	}
	elsif($prompt =~ /^l\b/i) {
		&TalkMenu;
	}
	elsif($prompt =~ /^w\b/i) {
		&WhoMenu;
	}
	elsif($prompt =~ /^c\b/i) {
		&FingerMenu;
	}
	elsif($prompt =~ /^f\b/i) {
		&FtpMenu;
	}
	elsif($prompt =~ /^e\b/i) {
		if($AllowEdit eq "1") {
		&FileMenu;
		}
		&PrintMenu;
	}
	elsif($prompt =~ /^s\b/i) {
		if($found == 0) {
			system("clear");
			print "\n";
			print "Scanning Datebases.\n";
			sleep 1;
			print "User ($user) not found in Datebase.\n\n";
			print "Access Denied, Returining to Main Menu.\n";
			sleep 2;
		} else {
		if($found == 1) {
                        system("clear");
                        print "Your are now using a shell, $ShellPath, when you have\n";
			print "finished your work please type: exit.\n\n";
                        sleep 1;
			system("$ShellPath");
			}
		}
		&PrintMenu;
	}
	elsif($prompt =~ /^q\b/i) {
		system("clear");
		exit;
	}
	else {
		&PrintMenu;
}
}
sub IrcMenu {
	system("clear");
	print "\033[1;41m                                                            Internet Relay Chat \n";
	print "\n";
	print "\033[0;0mConnect to:\n";
	print "\n";
	print "\033[1;44m 1 \033[0;0m         $Network1\n";
	print "\033[1;44m 2 \033[0;0m         $Network2\n";
	print "\033[1;44m 3 \033[0;0m         $Network3\n";
	print "\033[1;44m O \033[0;0m         Other\n";
	print "\n";
	print "\033[1;44m M \033[0;0m         Main Menu\n";	
	print "\033[1;44m Q \033[0;0m         Exit Menu/System\n";
	print "\n";
	print "\033[1;41m                            Please Make A Selection                             \n";
	print "\033[0;0mSelection: ";
	$prompt = <STDIN>;
	chop($prompt);
	print "\n";
	if($prompt =~ /^1\b/i) {
		$address = "$Address1";
		print "Nickname: ";
		$nickname = <STDIN>;
		chop($nickname);
		$number = &get_rand (10,99);
		if($nickname eq "") {
			$nickname = "User-$number";
		}
		system("$IrcClient $nickname $address");
		&IrcMenu;
	}
	elsif($prompt =~ /^2\b/i) {
		$address = "$Address2";
		print "Nickname: ";
		$nickname = <STDIN>;
		chop($nickname);
		$number = &get_rand (10,99);
		if($nickname eq "") {
			$nickname = "User-$number";
		}
		system("$IrcClient $nickname $address");
		&IrcMenu;
	}
	elsif($prompt =~ /^3\b/i) {
		$address = "$Address3";
		print "Nickname: ";
		$nickname = <STDIN>;
		chop($nickname);
		$number = &get_rand (10,99);
		if($nickname eq "") {
			$nickname = "User-$number";
		}
		system("$IrcClient $nickname $address");

		&IrcMenu;
	}
	elsif($prompt =~ /^o\b/i) {
		print "Server Address: ";
		$address = <STDIN>;
		chop($address);
		print "Nickname: ";
		$nickname = <STDIN>;
		chop($nickname);
		$number = &get_rand (10,99);
		if($nickname eq "") {
			$nickname = "User-$number";
		}
		system("$IrcClient $nickname $address");

		&IrcMenu;
	}
	elsif($prompt =~ /^m\b/i) {
		&PrintMenu;
	}
	elsif($prompt =~ /^q\b/i) {
		system("clear");
		exit;
	}

	else {
		&IrcMenu;
}
}
sub FileMenu {
	system("clear");
	print "\033[1;41m                                                                   Edit A File \n";
	print "\033[0;0m\n";
	print "On this system we use $DefalutEdit as the default editor.\n\n";
	print "Please type in the name of an existing file or the name\n";
	print "of a new file in which you would like to create.\n";
	print "\n";
	print "To return to the Main Menu just enter '.' for a filename.\n\n";
	print "\033[1;41m                          Please Enter The Filename                             \n";
	print "\033[0;0mFilename: ";
	$filename = <STDIN>;
	chop($filename);
	if($filename eq ".") {
			&PrintMenu;
	}
	system("$EditPath $filename");
	&FileMenu
}
sub MailMenu {
	system("clear");
	print "\033[1;41m                                                                Electronic Mail \n";
	print "\n";
	print "\033[0;0mE-Mail Client:\n";
	print "\n";
	print "\033[1;44m 1 \033[0;0m         $MailName1\n";
	print "\033[1;44m 2 \033[0;0m         $MailName2\n";
	print "\033[1;44m 3 \033[0;0m         $MailName3\n";
	print "\033[1;44m C \033[0;0m         Just Check Messages - No Reading\n";
	print "\n";
	print "\033[1;44m M \033[0;0m         Main Menu\n";	
	print "\033[1;44m Q \033[0;0m         Exit Menu/System\n";
	print "\n";
	print "\033[1;41m                            Please Make A Selection                             \n";

	print "\033[0;0mSelection: ";
	$prompt = <STDIN>;
	chop($prompt);
	print "\n";

	if($prompt =~ /^1\b/i) {
		system("$MailPath1");
		&MailMenu;
	}
	elsif($prompt =~ /^2\b/i) {
		system("$MailPath2");
		&MailMenu;
	}
	elsif($prompt =~ /^3\b/i) {
		system("$MailPath3");
		&MailMenu;
	}
	elsif($prompt =~ /^c\b/i) {
		system("clear");
		system("messages");
		sleep 2;
		&MailMenu;
	}
	elsif($prompt =~ /^m\b/i) {
		&PrintMenu;
	}
	elsif($prompt =~ /^q\b/i) {
		system("clear");
		exit;
	}

	else {
		&MailMenu;
}
}
sub TelnetMenu {
	system("clear");
	print "\033[1;41m                                                                         Telnet \n";
	print "\033[0;0m\n";
	print "Please enter the address of the host that you would like to\n";
	print "connect to. Press enter for default ($TelnetAddress).\n";
	print "\n";
	print "To return to the Main Menu just enter '.' for the address.\n\n";
	print "\033[1;41m                            Please Enter The Address                            \n";
	print "\033[0;0mConnect: ";
	$connect = <STDIN>;
	chop($connect);
	if($connect eq ".") {
		&PrintMenu;
	}
	if($connect eq "") {
		system("telnet $TelnetAddress");
		&TelnetMenu
	}
	system("telnet $connect");
	&TelnetMenu
}
sub TalkMenu {
	system("clear");
	print "\033[1;41m                                                                           Talk \n";
	print "\033[0;0m\n";
	print "Please enter the username \& address of the user that you would like to\n";
	print "chat with. EXAMPLE: Local, enter: adam  Other System, enter adam\@ols.com\n";
	print "\n";
	print "To return to the Main Menu just enter '.' for the user.\n\n";
	print "\033[1;41m                            Please Enter The User                               \n";
	print "\033[0;0mUsername: ";
	$talk = <STDIN>;
	chop($talk);
	if($talk eq ".") {
		&PrintMenu;
	}
	if($talk eq "") {
		&TalkMenu
	}
	system("talk $talk");
	&TalkMenu
}
sub FtpMenu {
	system("clear");
	print "\033[1;41m                                                                            FTP \n";
	print "\033[0;0m\n";
	print "Please enter the address of the host that you would like to\n";
	print "connect to. Press enter for default ($FTPAddress).\n";
	print "\n";
	print "To return to the Main Menu just enter '.' for the address.\n\n";
	print "\033[1;41m                            Please Enter The Address                            \n";
	print "\033[0;0mConnect: ";
	$connect = <STDIN>;
	chop($connect);
	if($connect eq ".") {
		&PrintMenu;
	}
	if($connect eq "") {
		system("ftp $FTPAddress");
		&FtpMenu
	}
	system("ftp $connect");
	&FtpMenu
}
sub AccountMenu {
	system("clear");
	print "\033[1;41m                                                                  Account Setup \n";
	print "\n";
	print "\033[0;0mAccount Options:\n";
	print "\n";
	if($FingerInfo eq "1") {
	print "\033[1;44m F \033[0;0m         Change Finger Information\n";
	}
	if($Passwd eq "1") {
	print "\033[1;44m P \033[0;0m         Chage Login Password\n";
	}
	print "\033[1;44m U \033[0;0m         Check Quota\n";
	print "\n";
	print "\033[1;44m M \033[0;0m         Main Menu\n";	
	print "\033[1;44m Q \033[0;0m         Exit Menu/System\n";
	print "\n";
	print "\033[1;41m                            Please Make A Selection                             \n";
	print "\033[0;0mSelection: ";
	$prompt = <STDIN>;
	chop($prompt);
	print "\n";
	if($prompt =~ /^f\b/i) {
		if($FingerInfo eq "1") {
		system("clear");
		print "\033[1;41m                                                                                \n";
		print "\033[0;0m\n";
		system("chfn");
		sleep 1;
		}
		&AccountMenu;
	}
	elsif($prompt =~ /^p\b/i) {
		if($Passwd eq "1") {
		system("clear");
		print "\033[1;41m                                                                                \n";
		print "\033[0;0m\n";
		system("passwd");
		sleep 1;
		}
		&AccountMenu;
	}
	elsif($prompt =~ /^u\b/i) {
		system("clear");
		print "\033[1;41m                                                                                \n";
		print "\033[0;0m\n";
		system("quota");
		print "\033[0;0m\n";
		print "\033[1;41m                                                                                \n";
		print "\033[0;0mPress Enter To Return To Account Setup Menu.";
		$done = <STDIN>;
		&AccountMenu;
	}
	elsif($prompt =~ /^m\b/i) {
		&PrintMenu;
	}
	elsif($prompt =~ /^q\b/i) {
		system("clear");
		exit;
	}
	else {
		&AccountMenu;
}
}
sub FingerMenu {
	system("clear");
	print "\033[1;41m                                                                         Finger \n";
	print "\033[0;0m\n";
	print "Please enter the username and address of the user that you\n";
	print "would like to finger. If the user is a user of this machine\n";
	print "you do not need to enter an address, just the users login,\n";
	print "example: user\n";
	print "but if the user was not a user on this machine you will need to\n";
	print "enter the address, example: user\@a.server.on.the.net.\n";
	print "\n";
	print "Just press enter to view the list of users currently logged in.\n";
	print "\n";
	print "To return to the Main Menu just enter '.' for the finger.\n\n";
	print "\033[1;41m                           Please Enter The Username                            \n";
	print "\033[0;0mFinger: ";
	$finger = <STDIN>;
	chop($finger);
	if($finger eq ".") {
		&PrintMenu;
	} else {
	system("clear");
	print "\033[1;41m                                                                                \n";
	print "\033[0;0m\n";
	system("finger $finger");
	print "\n\033[1;41m                                                                                \n";
	print "\033[0;0mPress Enter To Return To Finger Menu.";
	$done = <STDIN>;
	&FingerMenu
}
}
sub GetUserName {
        ($user, $junk) = getpwuid($<);
        return $user;
}
sub WhoMenu {
	system("clear");
	print "\033[1;41m                                                                            Who \n";
	print "\033[0;0m\n";
	system("w");
	print "\n\033[1;41m                                                                                \n";
	print "\033[0;0mPress Enter To Return To The Main Menu.";
	$done = <STDIN>;
	&PrintMenu;
}
