/*
   2mgui for Linux project
   A project by Santiago Garcia Mantinan (manty@geocities.com)
   Facultad de Informtica, Universidad de La Corua (Spain)
   based on the 2mgui technology by Ciriaco Garcia de Celis (ciri@gui.uva.es)
   (C) 1997 distribute freely
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/ioctl.h>
#include <sys/fcntl.h>
#include <linux/fd.h>
#include <linux/fdreg.h>

#define bufmaxlen 1024*32

#define boot_sector_bytes *((WORD *)(buffer+0x0B))
#define boot_cluster_sectors buffer[0x0D]
#define boot_reserved_sectors *((WORD *)(buffer+0x0E))
#define boot_fats buffer[0x10]
#define boot_root_entries *((WORD *)(buffer+0x11))
#define boot_sectors *((WORD *)(buffer+0x13))
#define boot_fat_sectors *((WORD *)(buffer+0x16))
#define boot_volume *((DWORD *)(buffer+0x27))
#define boot_fat buffer+0x36
#define boot_format_release *((WORD *)(buffer+0x74))
#define boot_data_rate_dd buffer[0x78]&0x0F
#define boot_hd_dd_frontier buffer[0x79]
#define boot_track_size_hd *((WORD *)(buffer+0x7A))
#define boot_track_size_dd *((WORD *)(buffer+0x7C))
#define sizeofINFODIR 13+2+sizeof buffer

typedef unsigned char BYTE;
typedef unsigned short int WORD;
typedef unsigned int DWORD;

typedef struct {
        	DWORD files;
                DWORD bytes;
                DWORD allocated;
               } DTOTALS;

typedef struct {
        	DWORD files;
                DWORD bytes;
               } CTOTALS;

typedef struct {
                WORD cluster;
                void *next;
        	BYTE name [13];
               } INFODIR;

WORD track_size_hd=bufmaxlen, track_size_dd;
BYTE hd_dd_frontier, data_rate_dd, data_rate_hd=0;
long offset_frontier;

BYTE *buffer; /* must be at least 1 word greater than the real data on track */
BYTE fdn;
int fd, last_track=-1, last_head=-1;

char label [12]="UNLABELED";
DWORD volume,free_bytes=0;

WORD *fat16;

BYTE *root;
BYTE *cluster_directory;
BYTE *directory;
long offsetd=-32;
long clusterd=0;

BYTE *cluster;
int cluster_bytes;
long offset_cluster0;

/* Makes the checksum of the data in the buffer to see if it was ok */

WORD check_sum (WORD len)
{
WORD sum=0, cont;

cont=len>>1;
if (len&1) sum+= buffer[len-1];
while (cont)
  {
  cont--;
  sum+=((WORD *)buffer)[cont];
  }

if (cont=~sum-*((WORD *)(buffer+len))) last_head=-1;

return (cont);
}

/* Reads the physical track to the internal buffer using the ioctl services
   of the linux floppy driver, we need read and write permision on the floppy
   device to be able to do this */

int read_track (BYTE rate, long dma_size, BYTE track, BYTE head)
{
struct floppy_raw_cmd cmd;

cmd.data=buffer;
cmd.flags=FD_RAW_INTR|FD_RAW_NEED_DISK|FD_RAW_READ;
cmd.cmd_count=9;
cmd.track=track;
cmd.cmd[0]=FD_READ;
cmd.cmd[1]=(fdn&3)|(head<<2);
cmd.cmd[2]=track;
cmd.cmd[3]=head;
cmd.cmd[4]=0;
if ((cmd.rate=rate)==3) cmd.cmd[5]=8;
else {cmd.cmd[5]=7;if (dma_size>16384) dma_size=16384;}
cmd.length=dma_size;
cmd.cmd[6]=0;
cmd.cmd[7]=8;
cmd.cmd[8]=128;

if (last_track != track) cmd.flags|=FD_RAW_NEED_SEEK;

if ( ioctl( fd, FDRAWCMD, &cmd) < 0 )
  {
  last_track = -1;
  if ( errno == EBUSY )
    {
    fprintf(stderr,"FDC busy, sleeping for a second\n");
    sleep(1);
    return (1);
    }
  if ( errno == EIO )
    {
    fprintf(stderr,"Resetting controller\n");
    if(ioctl(fd, FDRESET, 2)  < 0) {perror("Error resetting"); exit(1);}
    return(1);
    }
  perror("Error reading the source device");
  exit(1);
  }

if ((cmd.reply[0]&0xf8)!=0x40 || cmd.reply[1]!=0x20 || cmd.reply[2]!=0x20)
  { last_track = -1; return (1); }
last_track = track; last_head = head; return 0;
}

/* Reads the track into the internal buffer and tests to see if its contents
   are OK, as no check can be done by the controller, Ciri has put a ~(WORD
   checksum) at the end of the data to make sure the data is what should be */

int read_n_test_track (BYTE track, BYTE head)
{
int i;
BYTE rate;
long track_size;

if (track==last_track && head==last_head) return (0);

if (track>=hd_dd_frontier) {rate=data_rate_dd; track_size=track_size_dd;}
else {rate=data_rate_hd; track_size=track_size_hd;}

for (i=0;i<3;i++)
  if ( !read_track (rate, track_size+2, track, head)
       &&
       !check_sum (track_size) )
     return (0);

fprintf(stderr,"Too many errors reading, giving up\n");
exit (1);
}

/* Reads a cluster to the cluster buffer based on the cluster_bytes and the
   argument wich is the cluster number */

void read_cluster (long clustern, BYTE *cluster_buffer)
{
long offset;
int bytes;
WORD track_size=track_size_hd;
BYTE track=0, head;

offset=offset_cluster0+clustern*cluster_bytes;
if (offset>=offset_frontier)
  {offset-=offset_frontier;track_size=track_size_dd;track=hd_dd_frontier;}
head=offset/track_size;
track+=head>>1;
head&=1;
read_n_test_track (track, head);
offset%=track_size;
bytes=track_size-offset;
if (cluster_bytes>bytes)
  {
  memcpy (cluster_buffer,buffer+offset,bytes);
  if (++head==2) {track++;head=0;}
  read_n_test_track (track, head);
  memcpy (cluster_buffer+bytes,buffer,cluster_bytes-bytes);
  }
else memcpy (cluster_buffer,buffer+offset,cluster_bytes);
}

/* Makes an image of the disk, on entry the disk (fd) is already opened, so
   it only opens the output file, reads the disk and writes its contents to
   the file that it has opened */

int image (char *name,long size)
{
BYTE track=0, head=0;
long track_size=track_size_hd;
int tf;

printf ("\nCreating image file %s (%ld bytes)\n\n",name,size);
tf=open(name,O_WRONLY|O_CREAT|O_TRUNC|O_NDELAY,0666);
if (tf <0)
  {perror ("Error openning the target file");exit(1);}

while (size)
  {
  read_n_test_track (track, head);

  if (size<=track_size) track_size=size;
  if (write (tf,buffer,track_size)<0)
    {perror ("Error writing the target file");exit(1);}

  size-=track_size;
  if (++head==2) {track++;head=0;}
  if (track==hd_dd_frontier) track_size=track_size_dd;
  }
exit (0);
}

/* Gets the path normalizing it if necesary, returns the pointer to it
   Normalization makes every path a /path/ compliant path ;-) */

char *getpath (char *path)
{
char *last, nopath[]="/";
int len;

path+=2;
if (!(last=strrchr (path,'/')))
  {path=nopath; last=nopath;}
len=last-path+1;
if (!(last=malloc(len+1))) {perror ("Error allocating memory"); exit (1);}
if (*path!='/') {last[0]='/';strncpy(last+1,path,len);len++;}
else strncpy(last,path,len);
last[len]='\0';
return (last);
}

/* Gets the name normalizing it if necesary, returns the pointer to it
   Normalization is done in 4dos dir way, this is . = *.* / .x = *.x /
   whateveritiswhithoutpoint = whateveritiswithoutpoint.* / any. = any. */

char *getname (char *path)
{
char *first, *last, noname[]="*.*";
int len;

if (first=strrchr(path,'/')) first++;
else first=path+2;
if (!strlen(first)) first=noname;
if (!(last=malloc((len=strlen(first))+3))) {perror ("Error allocating memory"); exit (1);}
if (first[0]=='.')
  if (first[1])
    if (first[1]=='.') strcpy(last,first);
    else {last[0]='*'; strcpy(last+1,first);}
  else strcpy(last,noname);
else
  {
  strcpy(last,first);
  if (!strchr(first,'.')) strcpy(last+len,noname+1);
  }
return (last);
}

/* Converts a dos dir entry name to a linux name (lowering and all that) */

void dos_to_linux (BYTE *linux_name, BYTE *dos)
{
int i,j;

if (*dos==5) {*linux_name='';i=1;}
else i=0;
while (i<8 && dos[i]!=' ') {linux_name[i]=tolower(dos[i]);i++;}
if (dos[8]!=' ') {linux_name[i]='.';i++;}
for (j=8;j<11 && dos[j]!=' ';j++,i++) linux_name[i]=tolower(dos[j]);
linux_name[i]=0;
}

/* Pushes a directory into the infodir structure allocating the necesary
   memory to do so, this is used to recurse into that directory afterwards */

INFODIR *pushd (INFODIR *last,BYTE *dirname,WORD cluster)
{
INFODIR *ptr;

if (!(ptr=malloc(sizeofINFODIR))) {perror ("Error allocating memory"); exit (1);}
if (last) last->next=ptr;
dos_to_linux (ptr->name,dirname);
ptr->cluster=cluster;
ptr->next=NULL;
return (ptr);
}

/* Pops a directory out of the infodir structure freeing up the space */

INFODIR *popd (INFODIR *last)
{
INFODIR *infodir;

infodir=last->next;
free (last);
return (infodir);
}

/* Expands path to see if entry can match it and returns true if so */

int search_entry (BYTE *entry, int maxlen, BYTE *path)
{
int i,j;

for (i=0; i<maxlen; i++)
  switch (path[i])
    {
    case '*':
      j=i+1;
      if (path[j]=='\0' || path[j]=='.' || path[j]=='/') return (1);
      for (;i<maxlen;i++) if (search_entry(entry+i,maxlen-i,path+j)) return (1);
      return (0);
      break;
    case '?':
      break;
    case '.':
      if (path [i+1]=='.')
        if (strncmp(entry,"..      ",8)) return (0);
        else return (1);
      for (;i<maxlen;i++) if (entry[i]!=' ') return (0);
      break;
    case '\0':
      for (;i<maxlen;i++) if (entry[i]!=' ') return (0);
      break;
    case '/':
      for (;i<maxlen;i++) if (entry[i]!=' ') return (0);
      break;
    default:
      if (path[i]!=entry[i]) return (0);
    }
return (1);
}

/* Searches the directory for the files that can match a path expresion
   returns the starting cluster of the file or <0 if the file was not found
   the offset of the entry is offsetd */

long search_dir (BYTE *path,int rec,INFODIR **first_dir,INFODIR **last_dir)
{
BYTE *last,*ptr;

while (((offsetd+=32)>=cluster_bytes && clusterd && fat16[clusterd]!=0xFFFF) ||
       (!clusterd && *(directory+offsetd)) ||
       (offsetd<cluster_bytes && *(directory+offsetd)))
  {
  if (offsetd>=cluster_bytes && clusterd) /* root can be n.n clusters ;-) */
    {
    offsetd=0;
    clusterd=fat16[clusterd];
    read_cluster (clusterd, directory);
    }
  if (last=strchr(path,'.'))  {if (*++last=='.') last++;}
  else (last=strchr(path,'/'));
  if (*(ptr=directory+offsetd)!=0xE5)
    {
    if (rec && (ptr[0xB]&0x18)==0x10 && *(ptr)!='.')
       {
       *last_dir=pushd (*last_dir,ptr,*((WORD *)(ptr+0x1A)));
       if (!*first_dir) *first_dir=*last_dir;
       }
    if (path[0]==0xE5)
      {if (*(ptr)==05 && search_entry (ptr+1,7,path+1) && search_entry (ptr+8,3,last))
         return(*((WORD *)(ptr+0x1A)));}
    else
      if (search_entry (ptr,8,path) && search_entry (ptr+8,3,last))
        return(*((WORD *)(ptr+0x1A)));
    }
  }
return (-1);
}

/* Opens the directory specified by path (recursive function) */

BYTE *rcd (char *path)
{
long i;
BYTE *ptr,*rptr;
BYTE tmp[14];

if (!path || !*++path) 
   {
   if (!(rptr=malloc(1))) {perror ("Error allocating memory"); exit (1);}
   *rptr=0;
   return (rptr);
   }
while ((i=search_dir(path,0,NULL,NULL))>=0 && !(*(directory+offsetd+0xB)&0x10));
if (i<0) return (NULL);
*tmp='/';
dos_to_linux (tmp+1, directory+offsetd);
clusterd=i;
offsetd=-32;
if (clusterd) {directory=cluster_directory;read_cluster (clusterd, directory);}
else directory=root;
ptr=rcd(strchr(path,'/'));
i=strlen(tmp);
if (!(rptr=malloc(i+strlen(ptr)+1))) {perror ("Error allocating memory"); exit (1);}
strcpy (rptr,tmp);
strcpy (rptr+i,ptr);
free (ptr);
return (rptr);
}

/* Opens the directory pointed by infodir */

BYTE *dcd (INFODIR *infodir,BYTE *fpath)
{
int i;
BYTE *ptr;

clusterd=infodir->cluster;
offsetd=-32;
if (clusterd) {directory=cluster_directory;read_cluster (clusterd, directory);}
else directory=root;
if (!(ptr=malloc((i=strlen(fpath))+strlen(infodir->name)+2))) {perror ("Error allocating memory"); exit (1);}
strcpy (ptr,fpath);
ptr[i]='/';
strcpy (ptr+i+1,infodir->name);
return (ptr);
}

/* Recursive part of dir (auxiliary function) */

DTOTALS rdir (char drive, BYTE *fpath, char *name, int rec)
{

INFODIR *infodir=NULL,*last=NULL;
BYTE *ptr,attribute;
DWORD bytes;
DTOTALS partial,total={0,0,0};

while (search_dir(name,rec,&infodir,&last)>=0)
  if (!((attribute=*((ptr=directory+offsetd)+0xB))&8))
    {
    if (!total.files) printf ("\n Directory of %c:%s/%s\n\n",tolower(drive),fpath,name);
    total.files++;
    if (*ptr==5) printf ("%.7s %.3s ",ptr+1,ptr+8);
    else printf ("%.8s %.3s ",ptr,ptr+8);
    if (attribute&0x10) printf ("<DIR>      ");
    else {bytes=*((DWORD *)(ptr+0x1C));printf ("%10lu ",bytes);total.bytes+=bytes;total.allocated+=bytes+((bytes%cluster_bytes)?cluster_bytes-bytes%cluster_bytes:0);}
    printf ("%02d-%02d-%4d %02d:%02d:%02d ",
      (*((WORD *)(ptr+0x18))>>5)&15, ptr[0x18]&31, (ptr[0x19]>>1)+1980,
      ptr[0x17]>>3, (*((WORD *)(ptr+0x16))>>5)&0x3F, (ptr[0x16]&31)<<1);
    printf ("%c%c%c%c%c\n",attribute&1?'R':'_',attribute&2?'H':'_',attribute&4?'S':'_',attribute&32?'A':'_',attribute&16?'D':'_');
    }
if (total.files) printf (" %10lu bytes in %ld file(s) %lu bytes allocated\n",total.bytes,total.files,total.allocated);
while (infodir)
  {
  ptr=dcd (infodir,fpath);
  partial=rdir (drive, ptr, name, rec);
  total.bytes+=partial.bytes;
  total.allocated+=partial.allocated;
  total.files+=partial.files;
  free (ptr);
  infodir=popd(infodir);
  }
if (rec && total.files) 
  {
  printf ("\n Total of: %c:%s/%s\n",tolower(drive),fpath,name);
  printf (" %10lu bytes in %ld file(s) %lu bytes allocated\n",total.bytes,total.files,total.allocated);
  }
return (total);
}

/* Opens a directory and prints info of the files in it */

int dir (char drive, char *path, char *name, int rec)
{
char all[]="*.*";
BYTE *ptr,*rptr,*fpath;
int bytes;

if (!(fpath=rcd(path))) {fprintf (stderr,"Error, directory %c:%s doesn't seem to exist\n",drive,path);return(1);}
printf ("\n Volume in drive %c is %s\n",drive,label);
printf (" Volume Serial Number is %.8X",volume);
if (!strchr(name,'?') && !strchr(name,'*'))
  if (search_dir(name,0,NULL,NULL)>=0 && (*(directory+offsetd+0xB))&0x10)
    {
    offsetd-=32;
    ptr=rcd(name-1);
    bytes=strlen(fpath);
    if (!(rptr=malloc(bytes+strlen(ptr)+1))) {perror ("Error allocating memory"); exit (1);}
    strcpy (rptr,fpath);
    strcpy (rptr+bytes,ptr);
    free (ptr);
    free (fpath);
    fpath=rptr;
    name=all;
    }
  else offsetd=-32;
if (!(rdir(drive, fpath, name, rec).files))
  printf ("\n Directory of %c:%s/%s\n\n          0 bytes in 0 file(s) 0 bytes allocated\n",tolower(drive),fpath,name);
printf (" %10lu bytes free\n\n",free_bytes);
free (fpath);
return (0);
}

/* Recursive part of copy (auxiliary function) */

CTOTALS rcopy (char drive,BYTE *spath,BYTE *name,BYTE *tpath,BYTE *target,int rec)
{
CTOTALS partial,total={0,0};
INFODIR *infodir=NULL,*last=NULL;
BYTE *nspath, *ntpath, attribute;
long file_cluster,bytes;
int size,tf;
char linux_name[256];
char source_name[13];

while ((file_cluster=search_dir(name,rec,&infodir,&last))>=0)
  if (!((attribute=*((nspath=directory+offsetd)+0xB))&0x18))
    {
    total.files++;
    dos_to_linux (source_name,nspath);
    if (target) strncpy (linux_name,target,sizeof linux_name);
    else dos_to_linux (linux_name,nspath);
    bytes=*((DWORD *)(nspath+0x1C));
    size=cluster_bytes;
    if (attribute&1) tf=open(linux_name,O_WRONLY|O_CREAT|O_TRUNC|O_NDELAY,0444);
    else tf=open(linux_name,O_WRONLY|O_CREAT|O_TRUNC|O_NDELAY,0666);
    if (tf<0)
      if (errno != EISDIR)
        {perror ("Error openning the target file");exit(1);}
      else
        {
        chdir (linux_name);
        dos_to_linux (linux_name,nspath);
        if (attribute&1) tf=open(linux_name,O_WRONLY|O_CREAT|O_TRUNC|O_NDELAY,0444);
        else tf=open(linux_name,O_WRONLY|O_CREAT|O_TRUNC|O_NDELAY,0666);
        if (tf<0) {perror ("Error openning the target file");exit(1);}
        }

    printf("Copying %c:%s/%s => %s/%s %lu bytes\n",tolower(drive),spath,source_name,tpath,linux_name,bytes);
    
    total.bytes+=bytes;    
    while (bytes)
      {
      read_cluster(file_cluster,cluster);
      if (bytes<=cluster_bytes) size=bytes;
      if (write (tf,cluster,size)<0)
        {perror ("Error writing the target file");exit(1);}
      bytes-=size;
      file_cluster=fat16[file_cluster];
      }
    close (tf);
    }
while (infodir)
  {
  if (chdir(infodir->name)) 
    if (mkdir(infodir->name,0777)) {perror ("Error creating target directory");exit(1);}
    else if (chdir(infodir->name)) {perror ("Error changing to target directory");exit(1);}
  if (!(ntpath=malloc((size=strlen(tpath))+strlen(infodir->name)+2))) {perror ("Error allocating memory"); exit (1);}
  strcpy (ntpath,tpath);
  ntpath[size]='/';
  strcpy (ntpath+size+1,infodir->name);
  nspath=dcd(infodir,spath);
  partial=rcopy(drive,nspath,name,ntpath,target,rec);
  total.bytes+=partial.bytes;
  total.files+=partial.files;
  free(nspath);
  free(ntpath);
  if (chdir("..")) {perror ("Error changing directory");exit(1);}
  infodir=popd(infodir);
  }      
return (total);
}

/* Copies files expecified by path and name into target, if name is a 
   directory all files in it are copied */

int copy (char drive, char *path, char *name, char *target, int rec)
{
char all[]="*.*";
BYTE *spath,*tpath;
int len,i;
CTOTALS total={0,0};

printf("\nStarting the copy process...\n");
if (!(spath=rcd(path))) {fprintf (stderr,"Error, directory %c:%s doesn't seem to exist\n",drive,path);return(1);}
if (!(tpath=malloc((len=strlen(target))+strlen(name)+2))) {perror ("Error allocating memory"); exit (1);}
strcpy (tpath,target);
if (!strchr(name,'?') && !strchr(name,'*'))
  if (search_dir(name,0,NULL,NULL)>=0)
    if ((*(directory+offsetd+0xB))&0x10)
      {
      if (chdir(target)) 
        if (mkdir(target,0777)) {perror ("Error creating target directory");exit(1);}
        else if (chdir(target)) {perror ("Error changing to target directory");exit(1);}
      offsetd-=32;
      rcd (name-1);
      for (i=strlen(name)-1;i>=0;i--) name[i]=tolower(name[i]);
      if (target[len-1]=='/')
        {
        if (mkdir(name,0777)) {perror ("Error creating target directory");exit(1);}
        else if (chdir(name)) {perror ("Error changing to target directory");exit(1);}
        strcpy (tpath+len,name);
        }
      name=all;
      target=NULL;
      }
    else offsetd-=32;
  else offsetd=-32;
else 
  {
  if (chdir(target)) 
    if (mkdir(target,0777)) {perror ("Error creating target directory");exit(1);}
    else if (chdir(target)) {perror ("Error changing to target directory");exit(1);}
  target=NULL;
  }
len=strlen(tpath)-1;
if (tpath[len]=='/') tpath[len]='\0';
total=rcopy(drive,spath,name,tpath,target,rec);
printf (" %lu bytes copied in %ld file(s)\n\n",total.bytes,total.files);
free (tpath);
return (0);
}

/* Types the files expecified by path and name in the stdout */

int type (char drive, char *path, char *name)
{
BYTE *spath,*nspath;
char source_name[13];
long file_cluster,bytes;
int size=-1;

if (!(spath=rcd(path))) {fprintf (stderr,"Error, directory %c:%s doesn't seem to exist\n",drive,path);return(1);}
while ((file_cluster=search_dir(name,0,NULL,NULL))>=0)
  if (!(*((nspath=directory+offsetd)+0xB)&0x18))
    {
    if (strchr(name,'?') || strchr(name,'*'))
      {
      dos_to_linux (source_name,nspath);
      printf("\n Typing %c:%s/%s\n\n",tolower(drive),spath,source_name);
      }
    bytes=*((DWORD *)(nspath+0x1C));
    size=cluster_bytes;
    while (bytes)
      {
      read_cluster(file_cluster,cluster);
      if (bytes<=cluster_bytes) size=bytes;
      if (fwrite (cluster,1,size,stdout)<0)
        {perror ("Error typing");exit(1);}
      bytes-=size;
      file_cluster=fat16[file_cluster];
      }
    }
if (size<0) printf ("\nFile not found\n\n");
return (0);
}

/* Translates the command string to a command number */

int get_command (char *command)
{
if (!strcmp(command,"gimage")) return (1);
if (!strcmp(command,"gdir")) return (2);
if (!strcmp(command,"gcopy")) return (3);
if (!strcmp(command,"gtype")) return (4);
return(0);
}

/* MAIN procedure, identifies the disk, gets all physical data and reads the
   fat and root directory into memory for future use */

int main (int argc, char **argv)
{
char drivea[]="/dev/fd0";
char driveb[]="/dev/fd1";
char *command, *path, *name;
void *ptr;
long i, j, k, fat12=0, fat_entries, root_entries, offset_root,
     sector_bytes, sectors,
     real_cluster_bytes, real_offset_cluster0;
int gcommand,rec=0;

if (command = strrchr(argv[0],'/')) command++;
else command = argv[0];

if (!(gcommand=get_command (command)))
  {printf ("\n2mgui for Linux project v0.1.0\nA project by Santiago Garca Mantin (manty@geocities.com)\nFacultad de Informtica, Universidad de La Corua (Spain)\nbased on the 2mgui technology by Ciriaco Garca de Celis (ciri@gui.uva.es)\n(C) 1997 distribute freely\n\nSupported commands are:\n  gtype      <source files>\n  gdir   [-] <source files>\n  gcopy  [-] <source files> [target]\n  gimage     <source drive> <target file>\n\n");exit(0);}

switch (gcommand)
  {
  case 1:
  if (argc!=3)
    {fprintf (stderr,"\nUsage: gimage <source drive> <target file>\n\n");exit (1);}
  break;
  case 2:
  if (argc<2 || argc>3 || (argc==3 && !(rec=(*argv[1]=='-'))))
    {fprintf (stderr,"\nUsage: gdir [-] <source files>   (use - for a recursive dir)\n\n");exit (1);}
  break;
  case 3:
  if (argc<2 || argc>4)
    {fprintf (stderr,"\nUsage: gcopy [-] <source files> [target]   (use - for a recursive copy)\n\n");exit (1);}
  if (argc>=3) rec=*argv[1]=='-';
  break;
  case 4:
  if (argc!=2)
    {fprintf (stderr,"\nUsage: gtype <source files>\n\n");exit (1);}
  break;
  }

if (rec)
  {
  argv[1]=argv[2];
  if (argc>3) argv[2]=argv[3];
  argc--;
  }

if (*(argv[1]+1)!=':')
 {fprintf (stderr,"The source drive must be either A: or B:\n");exit (1);}

for (i=0;i<strlen(argv[1]);i++) argv[1][i]=toupper(argv[1][i]);

if (*(argv[1])=='A') {fdn=0;ptr=drivea;}
else if (*(argv[1])=='B') {fdn=1;ptr=driveb;}
     else {fprintf (stderr,"The source drive must be either A: or B:\n");exit (1);}

/* Gonna try to read track 0 head 0 to identify the disk */

fd=open(ptr,O_RDONLY|O_NDELAY);
if (fd <0)
  {perror ("Error openning the source device");exit(1);}

if (!(buffer=malloc(bufmaxlen))) {perror ("Error allocating memory"); exit (1);}

do
  {
  for (i=3;i>0;i--)
    if (!read_track (data_rate_hd, track_size_hd, 0, 0)
       && boot_format_release==0x100
       && (track_size_hd=boot_track_size_hd)<bufmaxlen 
       && !check_sum (track_size_hd))
       i=-1;
  if (!i)
    if (data_rate_hd) data_rate_hd+=2;
    else data_rate_hd++;
  }
while (!i && data_rate_hd<4);
if (!i) {fprintf(stderr,"Too many errors reading, giving up\n");exit(1);}

/* Disk identified, gonna copy the relevant boot data (local/global) */

track_size_dd=boot_track_size_dd;
data_rate_dd=boot_data_rate_dd;
hd_dd_frontier=boot_hd_dd_frontier;
offset_frontier=track_size_hd*hd_dd_frontier*2;
sector_bytes=boot_sector_bytes;
sectors=boot_sectors;
real_cluster_bytes=sector_bytes*boot_cluster_sectors;
offset_cluster0=boot_reserved_sectors*sector_bytes;
offset_root=offset_cluster0+(boot_fats*boot_fat_sectors)*sector_bytes;
root_entries=boot_root_entries;
real_offset_cluster0=offset_root+root_entries*32-real_cluster_bytes*2;
fat_entries=(sectors-boot_reserved_sectors-boot_fats*boot_fat_sectors-
             (boot_root_entries*32/sector_bytes))/boot_cluster_sectors+2;
if (strncmp(boot_fat,"FAT16  ",7)) fat12=1;
volume=boot_volume;

 /* We release the part of the buffer we know we won't use */

ptr=buffer;
if (!(buffer=realloc(ptr,track_size_hd+2)))
  {perror ("Error reallocating memory"); exit (1);}
if (buffer!=ptr) last_head=-1;

/* GIMAGE is the only command that doesn't need any of the logical data, so
   no sense in having all that allocated, we'll call it right here */

if (gcommand==1) image (argv[2],sectors*sector_bytes);

/* Allocation for the system areas (root directory+cluster buffer+FAT)
   as when we pocess a directory other than root root procesing will be over
   we'll use it's space for the directory cluster buffer */

if ( !(root=malloc((root_entries+1)*32))
     ||
     !(cluster=malloc(real_cluster_bytes*2))
     ||
     !(fat16=malloc(fat_entries*2)) )
  {perror ("Error allocating memory"); exit (1);}
cluster_directory=cluster+real_cluster_bytes;
directory=root;

/* We read the fat using a trick, a false cluster scheme ;-)
   12 bits fats are converted into 16 bits ones to have just one type :-) */

cluster_bytes=120;
i=0;
k=0;
while (k<fat_entries)
  {
  read_cluster(i, cluster);
  i++;
  if (fat12)
    for (j=0 ; j<80 && k<fat_entries ; j++,k++)
      {
      fat16[k]=*((WORD *)(cluster+(j*3/2)));
      if (j&1) fat16[k]>>=4;
      else fat16[k]&=0xFFF;
      if (fat16[k]>=0xFF0) fat16[k]|=0xF000;
      }
  else
    for (j=0 ; j<60 && k<fat_entries ; j++,k++)
      fat16[k]=((WORD *)cluster)[j];
  }

/* We now do the same with the root */

  offset_cluster0=offset_root;
  cluster_bytes=32;
  ptr=root;
  for (i=0; i<root_entries; i++,ptr+=32) read_cluster (i,ptr);
memset (ptr,0,32);

/* We now put the real logical cluster data as no more tricks will come,
   I guess... one exception is the pointer wich by now points to the root
   directory as we'll simulate that it is a normal directory with clusters
   and all that stuff. */

cluster_bytes=real_cluster_bytes;	/* the real size */
offset_cluster0=real_offset_cluster0; /* the real offset */

/* We get the normalized path and name */

name=getname (argv[1]);
path=getpath (argv[1]);
for (i=2;i<fat_entries;i++) if (!fat16[i]) free_bytes+=cluster_bytes;

/* We try to see if there is a label in the root directory */

while (search_dir("*.*",0,NULL,NULL)>=0) if ((*(directory+offsetd+0xB)&0xF)==8) strncpy (label,directory+offsetd,11);
offsetd=-32;

/* Finally we'll proceed executing the rest of the commands */

if (gcommand==2) dir (*(argv[1]), path, name, rec);

if (gcommand==3)
  if (argc==3) copy (*(argv[1]), path, name, argv[2], rec);
  else copy (*(argv[1]), path, name, ".", rec);

if (gcommand==4) type (*(argv[1]), path, name);
  
exit(0);
}
