#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>

#include <sys/ipc.h>
#include <sys/sem.h>

#include "interface.h"
#include "ringbuff.h"
#include "semshm.h"

#undef WARN_INTERRUPT
#undef _DEBUG
#include <assert.h>


#define BASE bufferCdda
#define entry_size (nsectors*CD_FRAMESIZE_RAW + OFF)

unsigned char **fill_buffer;
unsigned char **last_buffer;
static unsigned char *previous_read_buffer;
static unsigned int total_buffers;

#define FREE_SEM 0
#define DEF_SEM 1
#define SEMS 2

#define INC(a) (BASE + ((((a)-BASE)/entry_size + 1) % total_buffers)*entry_size)

static ushort valarr[SEMS];

static int get_snapshot(void)
{
  union my_semun mysemun;

  mysemun.array = valarr;
  return semctl(sem_id,0,GETALL,mysemun);
}

#define free_buffers() (valarr[FREE_SEM])
#define occupied_buffers() (total_buffers - valarr[FREE_SEM])
#define defined_buffers() (valarr[DEF_SEM])

void set_total_buffers(unsigned int num_buffers, int mysem_id)
{
  union my_semun mysemun;

  mysemun.val   = 0;
  if (semctl(mysem_id,DEF_SEM,SETVAL,mysemun) < 0) {
    perror("semctl DEF_SEM");
  }

  mysemun.val   = num_buffers;
  if (semctl(mysem_id,FREE_SEM,SETVAL,mysemun) < 0) {
    perror("semctl FREE_SEM");
  }

  total_buffers = num_buffers;
  *fill_buffer = *last_buffer = previous_read_buffer = NULL;
}

const unsigned char *get_previous_read_buffer(void)
{
  assert(previous_read_buffer != NULL);
  assert(previous_read_buffer != *fill_buffer);
  return previous_read_buffer;
}

const unsigned char *get_fill_buffer(void)
{
  assert(*fill_buffer != NULL);
  assert(previous_read_buffer != *fill_buffer);
  return *fill_buffer;
}

void define_buffer(void)
{
#ifdef _DEBUG
  get_snapshot();

  assert(defined_buffers() < total_buffers);

  fprintf(stderr,"stop  reading  %p - %p\n",*fill_buffer, *fill_buffer + entry_size -1);
#endif

  if (*last_buffer == NULL)
    *last_buffer = *fill_buffer;

  semrelease(sem_id,DEF_SEM);
}

void drop_buffer(void)
{
#ifdef _DEBUG
  get_snapshot();
  assert(free_buffers() < total_buffers);
  assert(occupied_buffers() > 0);

  fprintf(stderr," stop  writing %p - %p ",*last_buffer, *last_buffer + entry_size -1);
#endif

  if (*last_buffer == NULL)
    *last_buffer = *fill_buffer;
  else
    *last_buffer = INC(*last_buffer);
  semrelease(sem_id,FREE_SEM);
}

static void occupy_buffer(void)
{
#ifdef _DEBUG
  get_snapshot();
  assert(occupied_buffers() <= total_buffers);
#endif

  previous_read_buffer = *fill_buffer;

  if (*fill_buffer == NULL) {
    *fill_buffer = BASE;
  } else {
    *fill_buffer = INC(*fill_buffer);
  }
}

unsigned char * get_next_buffer(void)
{
#ifdef WARN_INTERRUPT
  get_snapshot();
  if (free_buffers() <= 0) {
    fprintf(stderr, "READER waits!!\n");
  }
#endif

  /* wait for a new buffer to become available */
  if (semrequest(sem_id,FREE_SEM) != 0) {
    /* semaphore operation failed.
       try again...
       */
    fprintf(stderr, "child reader sem request failed, retry\n");
    if (semrequest(sem_id,FREE_SEM) != 0) {
      exit(3);
    }
  }

  occupy_buffer();

#ifdef _DEBUG
  fprintf(stderr,"start reading  %p - %p\n",*fill_buffer, *fill_buffer + entry_size);
#endif
  return *fill_buffer;
}

unsigned char *get_oldest_buffer(void)
{
  unsigned char *retval;

  /* wait for buffer to be defined */
  if (semrequest(sem_id,DEF_SEM) != 0) {
    /* semaphore operation failed.
       try again...
       */
    fprintf(stderr, "parent writer sem request failed, retry\n");
    if (semrequest(sem_id,DEF_SEM) != 0) {
      exit(3);
    }
  }

  retval = *last_buffer;

#ifdef _DEBUG
  fprintf(stderr," begin writing %p - %p\n", retval, retval + entry_size);
#endif

  return retval;
}

