/*
Copyright Technical Research Centre of Finland (VTT), 
Information Technology Institute (TTE) 1993, 1994 - All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of VTT or TTE not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission. 

VTT DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
VTT BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
*/

/* $Id: smbmount.h,v 1.2 1995/01/03 18:11:26 tml Exp $ */

typedef struct smb_dirlist_struct smb_dirlist;

/* Types of file handles */
#define SMBMFH_UNKNOWN 0	/* Unknown yet */
#define SMBMFH_DIR 1		/* A directory */
#define SMBMFH_FILE 2		/* A file */
#define SMBMFH_CONTROL 3	/* The control file users "log in" through */

/*
 * Smbmount uses a pointer to the following structure as a file handle.
 * Yes, this is extremely stateful, but smbmount is used only from the
 * local host anyway. (And, I don't know a way to encode which directory
 * or file on an SMB server a handle refers to in just 32 bytes, anyway.)
 */

typedef struct smb_fh_struct *smb_fh;

struct smb_fh_struct
{
  char fh_type;			/* Type of file handle */
  fstring fh_path;		/* The pathname of the dir or file */
#define UID_LOGIN_FAILED -1
#define UID_NOT_OPEN -2
  smb_dirlist *fh_dir;		/* Directory list if readdir has been done */
				/* recently. */
  smb_fh fh_link;		/* Link to next fh */
};

extern int toplevel_fh_allocation[];

struct smb_dirlist_struct
{
  time_t dl_timestamp;
  int dl_nentries;
  char **dl_entries;
};

/*
 * Each potential or open SMB session has an smb_user structure.
 *
 * These structures are allocated when an UNIX user "logs in" to an 
 * smbmount-mounted SMB server, that is tells smbmount what NetBIOS
 * user name and password to use if and when the user's processes
 * eventually access the SMB server.
 */

typedef struct smb_user
{
  uid_t u_uxuid;		/* UNIX uid */
  short u_uid;			/* SMB UID number, or magic flag */
  short u_tid;			/* SMB TID */
  char *u_name;			/* NetBIOS user name */
  char *u_passwd;		/* NetBIOS password */
  char u_mark;			/* Used in "garbage collecting" */
  time_t u_timestamp;		/* Also used in GC */
  struct smb_user *u_link;
} smb_user;

extern int smbversion;

extern int debug;
#define DEBUG_TRACENFS 0x001

extern int Protocol;

extern int DEBUGLEVEL;		/* Used by Samba code */

extern int open_for_attr;

extern smb_user guest;

extern unsigned char local_to_smb[];
extern unsigned char smb_to_local[];

/* File name translation modes.  */

#define TRANSL_NONE 0		/* No translation (except '\\' <-> '/') */
#define TRANSL_LATIN1 1		/* ISO Latin-1 */

extern int fntransl;

/* Open files time out and are closed after TIMEOUT seconds.  */

#ifndef TIMEOUT
#define TIMEOUT 10
#endif

extern char revision[];

extern char *InBuffer, *OutBuffer;
extern BOOL readbraw_supported, writebraw_supported;
extern int Client;
extern int max_xmit;

extern void terminate P((int signo));
extern void init_nfs_subr P((void));
extern void nfs_timeout P((time_t now));
extern void setup_pkt P((char *outbuf, int command, const smb_user *user));

/* Error-checking versions of malloc() etc. */
extern void *xmalloc P((size_t nbytes));
extern void *xrealloc P((void *ptr, size_t nbytes));
extern void *xzalloc P((size_t nbytes));

#define xstrdup(s) strcpy(xmalloc(strlen(s) + 1), s)
