#!/bin/sh

# $Id: smblogin.sh,v 1.2 1994/11/18 08:19:00 tml Exp $

usage() 
{
	echo "Usage: $0 mountpoint [ username [ password ] ]"
	echo ' mountpoint is the directory where the file system is to be mounted.'
	echo ' username is the NetBIOS user name you want to use (default is'
	echo ' your UNIX login), and password is its password.'
	echo ' If no password is given, it is read from standard input.'
}

if [ "`echo -n`" = '-n' ]; then
	ECHO=echo
	C='\c'
else
	ECHO='echo -n'
	C=''
fi

if [ $# -lt 1 ]; then
	usage
	exit 255
fi

if [ "$2" ]; then
	user="$2"
else
	user="$LOGNAME"
	[ -z "$user" ] && user="$USER"
	[ -z "$user" ] && user="`logname`"
	if [ -z "$user" ]; then
		echo 'Who are you?'
		exit 255
	fi
fi


if [ "$3" ]; then
	password="$3"
else
	if [ -t 0 -a -t 1 ]; then
		trap "stty `stty -g`" 0
		trap "exit" 2
		stty -echo
		$ECHO "Password: $C"
	fi
	read password
	[ -t 0 -a -t 1 ] && echo
fi

echo login "$user" "$password" >$1/.control
