.\" COPYRIGHT (C) 1998 By Arthur Naseef
.\"
.\" This file is covered under the GNU General Public License Version 2.  For
.\"  more information, see the file COPYING.
.\"
.\"
.\" FILE: ovl.m
.\"
.\" DESCRIPTION: Manual page for the overlay filesystem.
.\"
.\" SCCS ID: @(#) ovl.m 1.3
.\"
.\"
.\" REVISION HISTORY
.\"
.\" DATE	AUTHOR		DESCRIPTION
.\" ===========	===============	==============================================
.\" 03/08/1998	ARTHUR N.	Initial Release
.\" 03/10/1998	ARTHUR N.	Changed tmac.an to tmac.asn to remove the
.\"				 conflict with the man page tmac.an file.
.\" 03/10/1998	ARTHUR N.	Added the shortcuts for options.
.\"
.\"
.\" M4 definitions:
include(tmac.asn)dnl
define(m4_concat, $1$2$3$4$5$6$7$8$9)dnl
define(CURRENT_DATE, translit(esyscmd(date), `
', `'))dnl
define(OVL_VERSION, translit(esyscmd(awk '{print $1; exit}' Version), `
', `'))dnl
.\"
.\"
.\"
.ad l
.TH ovl 8 "CURRENT_DATE" "Arthur Naseef" "Linux System Admin"
.\"
.\" SECTION BREAK
.\"
.SH NAME
ovl.o -
overlay pseudo filesystem.
.\"
.\" SECTION BREAK
.\"
.SH VERSION
This manual page covers version OVL_VERSION of the overlay filesystem.
.\"
.\" SECTION BREAK
.\"
.SH SYNOPSIS
modprobe ovl.o
.br
mount -t ovl \fIovl0\fR /mnt -o root=\fIrootdir1\fR,storage=\fIrootdir2\fR
.\"
.\" SECTION BREAK
.\"
.SH DESCRIPTION
The overlay filesystem is a pseudo filesystem that allows any filesystem,
including a read-only filesystem, to be modified by saving the changes in
another filesystem.
.P
There is a lot of documentation on the issues of using the overlay filesystem
that is included with the source distribution.
This manual page is intended only to clarify how to use the filesystem.
.\"
.\" SECTION BREAK
.\"
.SH USAGE
In order to use the overlay filesystem,
determine the root directories of the base and storage filesystems,
and any special mount options to use.
Then, the mount command may be used to mount the filesystem.
As shown in the SYNOPSIS above,
use the mount command to mount the filesystem.
The device name is not important, and can be chosen at your leisure,
because the filesystem does not use a device.
.P
For example, if the root of the base filesystem is \fB/cdrom\fR
the root of the storage filesystem is \fB/cdrom_ovl\fR,
the storage file is \fB/.cdrom_stg\fR,
and the mount point is \fB/mnt\fR,
then the following mount command can be used:
.P
.in +4n
.hy 0
.HI /sbin/mount
\-t ovl cdrom_ovl \fB/mnt\fR \-o root=\fB/cdrom\fR,storage=\fB/cdrom_ovl\fR,\
stg_file=\fB/.cdrom_stg\fR
.HE
.hy 1
.in
.\"
.\" SUB-SECTION BREAK
.\"
.SS MOUNT OPTIONS
The overlay filesystem supports many mount time options.
The general purpose options available are
nostorage,
maxmem,
xmnt,
and noxmnt.
In addition, the following options may be used to specify
the storage of inode mappings, if compiled into the filesystem driver:
storemaps, nostoremaps,
basemap, nobasemap,
stgmap, and nostgmap
Last, the following options are available for the magic directories,
if compiled into the driver:
magic, nomagic,
hidemagic, showmagic,
basemagic, nobasemagic,
ovlmagic, noovlmagic,
smagic, and bmagic.
Note that there are shortcuts for these options;
see the subsection, \fBShortcuts\fR, for more information.
.BL
.P
.nr wd 8
.LI
root=\fIdir\fR\ -
.Tf \n(wdn
.HI
set the root of the base filesystem to the named directory;
this is the only way to specify this information.
The string \fBbase_root=\fR may be used in place of root=.
.HE
.P
.LI
storage=\fIdir\fR\ -
.Tf \n(wdn
.HI
set the root of the storage filesystem to the named directory;
this is the only way to specify this information.
The string \fBstorage_root=\fR may be used in place of storage=.
.HE
.P
.LI
stg_file=\fIpath\fR\ -
.Tf \n(wdn
.HI
set the path to the storage file to the named path.
All inode information and inode mapping information is
saved between mounts in the storage file.
.HE
.P
.LI
nostorage\ -
.Tf \n(wdn
.HI
turn off the use of storage.
This option does not work yet.
.HE
.P
.LI
maxmem\ -
.Tf \n(wdn
.HI
turn on checking of the amount of available memory before
allocating more memory for inode storage for the overlay filesystem.
From testing, it seems that this option is better left off.
.HE
.P
.LI
xmnt\ -
.Tf \n(wdn
.HI
turn on the crossing of mount points in the base
and storage filesystems.
See the file, Options, distributed with
the source tree for more information.
.HE
.P
.LI
noxmnt\ -
.Tf \n(wdn
.HI
turn off the crossing of mount points in the base
and storage filesystems.
See the file, Options, distributed with
the source tree for more information.
.HE
.P
.LI
storemaps\ -
.Tf \n(wdn
.HI
store all inode mapping information in the storage file.
.HE
.P
.LI
nostoremaps\ -
.Tf \n(wdn
.HI
do not store any inode mapping information in the storage file.
.HE
.P
.LI
basemap\ -
.Tf \n(wdn
.HI
store the inode mapping information for the base filesystem
in the storage file.
.HE
.P
.LI
nobasemap\ -
.Tf \n(wdn
.HI
do not store the inode mapping information for the base filesystem
in the storage file.
.HE
.P
.LI
stgmap\ -
.Tf \n(wdn
.HI
store the inode mapping information for the storage filesystem
in the storage file.
.HE
.P
.LI
nostgmap\ -
.Tf \n(wdn
.HI
do not store the inode mapping information for the storage filesystem
in the storage file.
.HE
.P
.LI
hidemagic\ -
.Tf \n(wdn
.HI
do not display the magic directories in directory listings.
In other words, with this option,
the readdir() function will not include the magic directories.
.HE
.P
.LI
showmagic\ -
.Tf \n(wdn
.HI
display the magic directories in directory listings.
This is the opposite of the hidemagic option.
.HE
.P
.LI
magic\ -
.Tf \n(wdn
.HI
turn on the default magic directory options.
At the time of this writing, the default options include
basemagic, ovlmagic, and hidemagic.
.HE
.P
.LI
basemagic\ -
.Tf \n(wdn
.HI
turn on the magic directory for the base filesystem.
.HE
.P
.LI
nobasemagic\ -
.Tf \n(wdn
.HI
turn off the magic directory for the base filesystem.
.HE
.P
.LI
ovlmagic\ -
.Tf \n(wdn
.HI
turn on the magic directory for the storage filesystem.
.HE
.P
.LI
noovlmagic\ -
.Tf \n(wdn
.HI
turn off the magic directory for the storage filesystem.
.HE
.P
.LI
smagic=\fIdir\fR\ -
.Tf \n(wdn
.HI
set the name of the magic directory for the storage filesystem
to the specified name.
Do not include any slashes in this name.
The option, \fBmagic=\fIdir\fR, is a synonym for this option.
.HE
.P
.LI
bmagic=\fIdir\fR\ -
.Tf \n(wdn
.HI
set the name of the magic directory for the base filesystem
to the specified name.
Do not include any slashes in this name.
The option, \fBmagicr=\fIdir\fR, is a synonym for this option.
.HE
.LE
.SS Shortcuts
All of the supported mount options have shortcuts to
help reduce the length of the mount options on the command line.
.P
.BL
.LI
nostorage
.Tf 24n
nost
.LI
maxmem
.Tf 24n
mm
.LI
xmnt
.Tf 24n
xm
.LI
noxmnt
.Tf 24n
noxm
.LI
updmntonly
.Tf 24n
um
.LI
noupdmntonly
.Tf 24n
noum
.LI
base_root=<dir>
.Tf 24n
br=<dir>
.LI
storage_root=<dir>
.Tf 24n
sr=<dir>
.LI
stg_file=<path>
.Tf 24n
sf=<path>
.LI
storemaps
.Tf 24n
ma
.LI
nostoremaps
.Tf 24n
noma
.LI
basemap
.Tf 24n
bm
.LI
nobasemap
.Tf 24n
nobm
.LI
stgmap
.Tf 24n
sm
.LI
nostgmap
.Tf 24n
nosm
.LI
hidemagic
.Tf 24n
hm
.LI
magic
.Tf 24n
mg
.LI
nomagic
.Tf 24n
nomg
.LI
basemagic
.Tf 24n
mb
.LI
nobasemagic
.Tf 24n
nomb
.LI
ovlmagic
.Tf 24n
mo
.LI
noovlmagic
.Tf 24n
nomo
.LI
showmagic
.Tf 24n
ms
.LI
smagic=<name>
.Tf 24n
sn=<name>
.LI
bmagic=<name>
.Tf 24n
bn=<name>
.LE
.\"
.\" SECTION BREAK
.\"
.SH WARNINGS
The overlay filesystem in many ways emulates the VFS.
There are many possible ways that the use of the overlay
filesystem may cause problems.
A few of the most important issues are mentioned here.
Please see the rest of the documentation included with the source
for more information.
.P
Note that in spite of all of these warnings, and all others
documented for the overlay filesystem,
the use of the overlay filesystem should not cause any corruption
to any of the filesystems involved.
However, for your own safety, it is a good idea to backup ALL
filesystems on the host before using the overlay filesystem.
.P
.BL
.LI
Do not attempt to use a storage root that is a subdirectory of the
base root directory, or vice versa.
.P
.LI
All inodes that are not regular files or directories,
such as device files, pipes, and sockets,
may be directly accessed for reading and writing
through the overlay filesystem.
.P
.LI
The access and change times of the inodes in the base filesystem
may be affected by the use of the overlay filesystem,
although the modification times should not be affected -
except for files that are not directories or regular files.
.P
.LI
Any change to a file in the base filesystem causes the entire
file to be copied into the storage filesystem, even if only
one byte of the file is modified, and regardless of the size
of the file.
.P
.LI
Since names are only pointers to inodes, files and directories that
need to be created in the storage filesystem to store changes from
the base filesystem, may take a name other than the one being
accessed in the base filesystem.
This should only happen with files that have more than one hard link.
.P
.LI
Removing files from the overlay filesystem does not remove their inodes.
The only way to cleanup old inodes in the overlay filesystem is to remove
the storage file, or use a new storage file, for the filesystem.
.LE
.\"
.\" SECTION BREAK
.\"
.SH COPYRIGHT
This manual page and associated source code is licensed under the
GNU General Public License Version 2.
Of course, all source derived from the linux kernel source is copyrighted
by the original author of that source.
.sp 1
COPYRIGHT (C) 1998 By Arthur Naseef
