/*
 *  nwboprops.c
 *
 *  List properties of a bindery object
 *
 *  Copyright (C) 1996 by Volker Lendecke
 *
 */

#include "ncplib.h"
#include <unistd.h>
#include <stdlib.h>

static char *progname;

static void
usage(void)
{
	fprintf(stderr, "usage: %s [options]\n", progname);
}

static void
help(void)
{
	printf("\n");
	printf("usage: %s [options]\n", progname);
	printf("\n"
	       "-h             Print this help text\n"
	       "-S server      Server name to be used\n"
	       "-U username    Username sent to server\n"
	       "-P password    Use this password\n"
	       "-n             Do not use any password\n"
	       "-C             Don't convert password to uppercase\n"
	       "\n"
	       "-o object_name Name of object inspected\n"
	       "-t type        Object type (decimal value)\n"
	       "-v             Verbose listing\n"
	       "\n");
}

int
main(int argc, char *argv[])
{
	struct ncp_conn *conn;
	char *object_name = NULL;
	int object_type = -1;
	long err;

	struct ncp_property_info info;

	int result = 1;
	int verbose = 0;
	int opt;

	progname = argv[0];

	if ((conn = ncp_initialize(&argc, argv, 1, &err)) == NULL)
	{
		com_err(argv[0], err, "when initializing");
		goto finished;
	}
	while ((opt = getopt(argc, argv, "h?o:t:v")) != EOF)
	{
		switch (opt)
		{
		case 'o':
			object_name = optarg;
			str_upper(object_name);
			break;
		case 't':
			object_type = atoi(optarg);
			break;
		case 'v':
			verbose = 1;
			break;
		case 'h':
		case '?':
			help();
			goto finished;
		default:
			usage();
			goto finished;
		}
	}

	if (object_type < 0)
	{
		fprintf(stderr, "%s: You must specify an object type\n",
			argv[0]);
		goto finished;
	}
	if (object_name == NULL)
	{
		fprintf(stderr, "%s: You must specify an object name\n",
			argv[0]);
		goto finished;
	}
	info.search_instance = 0xffffffff;

	while (ncp_scan_property(conn, object_type, object_name,
				 info.search_instance, "*", &info) == 0)
	{
		if (verbose != 0)
		{
			printf("%s %d %02x %d\n",
			       info.property_name, info.property_flags,
			       info.property_security,
			       info.value_available_flag);
		} else
		{
			printf("%s\n", info.property_name);
		}
	}

      finished:
	ncp_close(conn);
	return result;
}
