/*   user1.cc : February 1, 1994    */

/* Copyright (C) 1994-1999  Sekhar Bala, Rama Bala, and
 *                          Alphax System, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <malloc.h>
#include <string.h>

#include "std.h"
#include "wildcard.h"
#include "parse.h"
#include "symtab.h"
#include "input.h"

#include "main.h"
#include "dump.h"
#include "ext2fs.h"
#include "diskio.h"


/*-------------------------------------------------------------------------*/

#define SUPERBLOCK_BLOCK         1
#define GROUP_BLOCK              2

STATIC INT_4      sb_at             = SUPERBLOCK_BLOCK;
STATIC INT_4      groups_at         = GROUP_BLOCK;
STATIC INT_4      groups_len_fake   = -1;

#define MAX_CWDSIZE                 256
STATIC CHAR       cwd[MAX_CWDSIZE]  = { 0, };
STATIC CHAR       cwd_idx           = 0;

STATIC CHAR      *block             = NULL;
STATIC INT_4      block_num         = 1;

#define MAX_SLIST                   20

typedef struct slist_typ {
   CHAR           *name;
   INT_2           name_len;
   BOOLEAN         matched;
} SLIST_TYP;

STATIC INT_2      slist_len         = 0;
STATIC SLIST_TYP  slist[MAX_SLIST]  = { {NULL, 0, FALSE}, };
STATIC INT_4      sblock            = 0;
STATIC INT_4      eblock            = 0;

/*-------------------------------------------------------------------------*/


GLOBAL BOOLEAN exec_dump( VOID )
{
 BOOLEAN     yesno;
 INT_2       i;
 INT_2       j;
 INT_4       value;
 INT_4       g_idx;
 INT_4       totals;
 INT_2       blocksize;
 INT_2       imode;
 DIR_TYP    *pdir;
 FILE       *fp;
 INODE_TYP  *pinode;

   if ( !WC::streq(P.word, "DUMP") )
      return( FALSE );

   if ( P.get() )
      return( TRUE );

   if ( WC::streq(P.word, "DISK") ) {
      dumpdisk();
      return( TRUE );
   }

   if ( WC::streq(P.word, "PARTITION") ) {
      if ( g_disk == 0xFFFF ) {
         set_errhdl( ERR_SYS_NOINIT );
      } else {
         yesno = FALSE;
         if ( (!P.get()) && (WC::streq(P.word, "HEX")) )
            yesno = TRUE;
         dumppart( yesno, outfp );
      }
      return( TRUE );
   }

   if ( WC::streq(P.word, "SUPERBLOCK") ) {
      if ( g_p_idx == -1 ) {
         set_errhdl( ERR_SYS_NOINIT );
      } else {
         yesno = TRUE;
         if ( (!P.get()) && (WC::streq(P.word, "VERBOSE")) )
            yesno = FALSE;
         dumpsb( sb, yesno, outfp );
      }
      return( TRUE );
   }

   if ( WC::streq(P.word, "GROUPS") ) {
      if ( g_p_idx == -1 ) {
         set_errhdl( ERR_SYS_NOINIT );
         return( TRUE );
      }
      g_idx = -1;
      if ( !P.get() ) {
         if ( WC::streq(P.word, "INDEX") ) {
            if ( !eval_expr(&g_idx) )
               return( TRUE );
         } else {
            set_errhdl( ERR_CMD_UNKNOWN );
            return( TRUE );
         }
      }
      dumpgroups( groups, groups_len, g_idx, outfp );
      return( TRUE );
   }

   if ( WC::streq(P.word, "INODE") ) {
      if ( (sb == NULL) || (groups == NULL) ) {
         set_errhdl( ERR_SYS_NOINIT );
      } else {
         if ( P.get() ) {
            dumpinode( inode_no, &inode, outfp );
            return( TRUE );
         }
         if ( WC::streq(P.word, "TABLE") ) {
            dumpiblocks( inode_no, &inode, outfp );
            return( TRUE );
         }
         if ( WC::streq(P.word, "BLOCKS") ) {
            getblock_FS( NULL, NULL );
            i      = 0;
            totals = 0;
            imode  = _MKMODE( inode.i_mode );
            while (TRUE) {
               j = getblock_FS( &g_idx, &value );
               if ( j != 0 ) {
                  if ( j != -1 )
                     fprintf( outfp, "Next block error %d\n", j );
                  break;
               }
               if ( g_idx == 0 )
                  break;
               fprintf( outfp, "%5d) x%08lX - ", i++, g_idx );
               if ( imode == IMODE_SLINK ) {
                  fprintf( outfp, "'%-4.4s'\n", (CHAR *) &g_idx );
               } else {
                  fprintf( outfp, "%8lu\n", g_idx );
               }
               totals += value;
            }
            fprintf( outfp, "total = %lu as %lu\n", totals, inode.i_size );
            return( TRUE );
         }
         set_errhdl( ERR_CMD_UNKNOWN );
      }
      return( TRUE );
   }

   if ( WC::streq(P.word, "DIRECTORY") ) {
      if ( P.get(PARSE::_FILENAME) )
         goto x_done;
      if ( dir == NULL ) {
         set_errhdl( ERR_SYS_NOINIT );
         return( TRUE );
      }
      if ( (!S_ISDIR(inode.i_mode)) || (inode.i_block[1] != 0) ) {
         set_errhdl( ERR_IO_NOTDIR );
         return( TRUE );
      }
      fp = fopen( P.word, "w" );
      if ( fp == NULL ) {
         set_errhdl( ERR_SYS_FILE );
         return( TRUE );
      }
      fprintf( fp, ";\n;\n;\n\n" );
      fprintf( fp, "fs dir begin\n" );
      for( pdir=dir; (pdir != NULL); pdir=pdir->next ) {
         fprintf( fp, "fd dir entry \"%s\" %ld\n",
                  pdir->name, pdir->inode_num );
      }
      value = inode.i_block[0];
      fprintf( fp, "fs dir end %ld\n", value );
      fprintf( fp, "\n;\n;\n;\n\n" );
      fclose( fp );
      return( TRUE );
   }

   if ( WC::streq(P.word, "BLOCK") ) {
      if ( sb == NULL ) {
         set_errhdl( ERR_SYS_NOINIT );
         return( TRUE );
      }
      blocksize = ( EXT2_BASE_BLOCK << sb->s_log_block_size );
      if ( block == NULL ) {
         block = (CHAR *) ::malloc( blocksize );
         if ( block == NULL ) {
            set_errhdl( ERR_SYS_NOMEM );
            return( TRUE );
         }
      }
      if ( !eval_expr(&value) )
         return( TRUE );
      if ( read_LIBIO(block, blocksize, blocksize*value) == 0 )
          dumpdata( block, blocksize, value, outfp );
      block_num = value;
      return( TRUE );
   }

   if ( WC::streq(P.word, "NEXT") ) {
      blocksize = ( EXT2_BASE_BLOCK << sb->s_log_block_size );
      if ( block == NULL ) {
         block = (CHAR *) ::malloc( blocksize );
         if ( block == NULL ) {
            set_errhdl( ERR_SYS_NOMEM );
            return( TRUE );
         }
      }
      block_num++;
      if ( read_LIBIO(block, blocksize, blocksize*block_num) == 0 )
         dumpdata( block, blocksize, block_num, outfp, 256 );
      return( TRUE );
   }

   if ( WC::streq(P.word, "PREVIOUS") ) {
      blocksize = ( EXT2_BASE_BLOCK << sb->s_log_block_size );
      if ( block == NULL ) {
         block = (CHAR *) ::malloc( blocksize );
         if ( block == NULL ) {
            set_errhdl( ERR_SYS_NOMEM );
            return( TRUE );
         }
      }
      block_num--;
      if ( read_LIBIO(block, blocksize, blocksize*block_num) == 0 )
         dumpdata( block, blocksize, block_num, outfp, 256 );
      return( TRUE );
   }

   if ( WC::streq(P.word, "BADINODE") ) {
      for( i=0; (i < badinode_len); i++ ) {
         pinode = &badinode[i].inode;
         printf( "%3d) ",  i );
         printf( "%8ld ",  badinode[i].inode_num );
         printf( "%8ld ",  pinode->i_size );
         printf( "{ %8ld ... ", pinode->i_block[0] );
         for( j=0; (j < 12); j++ )
            if ( pinode->i_block[j] == 0 )
               break;
         if ( j == 1 ) {
            printf( "}\n" );
         } else {
            printf( " %8ld }\n", pinode->i_block[j-1] );
         }
      }
      return( TRUE );
   }

x_done:

   set_errhdl( ERR_CMD_UNKNOWN );
   return( TRUE );

} /* exec_dump */


GLOBAL BOOLEAN exec_set( VOID )
{
 INT_4   value;

   if ( !WC::streq(P.word, "SET") )
      return( FALSE );

   if ( P.get() )
      return( TRUE );

   if ( WC::streq(P.word, "DISK") ) {
      if ( eval_expr(&value) ) {
         init_LIBIO( (INT_2) value );
      }
      return( TRUE );
   }

   if ( WC::streq(P.word, "SUPERBLOCK") ) {
       if ( !P.get() ) {
         if ( WC::streq(P.word, "AT") ) {
            if ( eval_expr(&value) )
               sb_at = value;
         } else {
            set_errhdl( ERR_CMD_UNKNOWN );
         }
         return( TRUE );
       }
       sb_at = SUPERBLOCK_BLOCK;
       return( TRUE );
   }

   if ( WC::streq(P.word, "GROUPS") ) {
      if ( !P.get() ) {
         if ( WC::streq(P.word, "LEN") ) {
            groups_len_fake = -1;
            if ( eval_expr(&value) )
               groups_len_fake = value;
            return( TRUE );
         }
         if ( WC::streq(P.word, "AT") ) {
            groups_at = GROUP_BLOCK;
            if ( eval_expr(&value) )
               groups_at = value;
            return( TRUE );
         }
         goto x_done;
      }
      return( TRUE );
   }

   if ( WC::streq(P.word, "PARTITION") ) {
      if ( eval_expr(&value) ) {
         if ( ((INT_2) value < 1) || ((INT_2) value > g_p_len) ) {
            set_errhdl( ERR_IO_FS );
         } else {
            g_p_idx = ((INT_2) value) - 1;
            init_FS();
            if (
                 (loadsb_FS(sb_at*1024L) == 0) ||
                 (groups_len_fake != -1)
               ) {
               if (
                    (loadgroups_FS(groups_len_fake, groups_at*1024L) == 0) &&
                    (automatic)
                  ) {
                  if ( loadinode_FS(2) == 0 )
                     loaddir_FS();
                  memset( cwd, (cwd_idx=0), MAX_CWDSIZE );
               }
            }
            if ( block != NULL )
               ::free( block );
            block = NULL;
         }
      }
      return( TRUE );
   }

   if ( WC::streq(P.word, "OUTPUT") ) {
      if ( !P.get(PARSE::_FILENAME) ) {
         if ( outfp != stdout )
            fclose( outfp );
         outfp = fopen( P.word, "w" );
         if ( outfp == NULL ) {
            set_errhdl( ERR_INP_FNAME );
            outfp = stdout;
         }
      } else {
         set_errhdl( ERR_CMD_UNKNOWN );
      }
      return( TRUE );
   }

   if ( WC::streq(P.word, "CLOSE") ) {
      if ( outfp != stdout )
         fclose( outfp );
      outfp = stdout;
      return( TRUE );
   }

x_done:

   set_errhdl( ERR_CMD_UNKNOWN );
   return( TRUE );

} /* exec_set */


GLOBAL BOOLEAN exec_read( VOID )
{
 INT_4   i;
 INT_4   value;
 INT_2   blocksize;
 CHAR   *pblock;

   blocksize = 0;
   if ( !WC::streq(P.word, "READ") )
      return( FALSE );

   if ( P.get() )
      goto x_done;

   if ( WC::streq(P.word, "INODE") ) {
      if ( eval_expr(&value) ) {
         loadinode_FS( value );
      }
      return( TRUE );
   }

   if ( WC::streq(P.word, "DIRECTORY") ) {
      loaddir_FS();
      if ( inode_no == 2 )
         memset( cwd, (cwd_idx=0), MAX_CWDSIZE );
      return( TRUE );
   }

   if ( WC::streq(P.word, "TEST") ) {
      if ( !eval_expr(&value) )
         return( TRUE );
      inode.i_block[0] = value;
      return( TRUE );
   }

   if ( WC::streq(P.word, "BLOCK") ) {
      if ( !eval_expr(&value) )
         goto x_done;
      if ( block == NULL ) {
         blocksize = ( EXT2_BASE_BLOCK << sb->s_log_block_size );
         block     = (CHAR *) ::malloc( blocksize );
         if ( block == NULL ) {
            set_errhdl( ERR_SYS_NOMEM );
            return( TRUE );
         }
      }
      if ( read_LIBIO(block, blocksize, blocksize*value) != 0 ) {

         pblock = block;
         i      = 0;

         // *** YOUR SPECIFC BLOCK SEARCH CODE ***

         while ( *pblock != 0 ) {
            i++;
            pblock++;
         }
         printf( "Block %ld has %ld chars\n", value, i );

         // *** YOUR SPECIFC BLOCK SEARCH CODE ***

      } /* endif */
      return( TRUE );
   }

x_done:

   set_errhdl( ERR_CMD_UNKNOWN );
   return( TRUE );

} /* exec_read */


GLOBAL BOOLEAN exec_ls( VOID )
{
 STATIC CHAR         fname[256];
 DIR_TYP            *pdir;
 INT_2               col;
 INT_2               tmp;
 INT_2               nlen     = 0;
 INT_2               lcnt     = 0;
 BOOLEAN             verbose  = FALSE;

   if ( (!WC::streq(P.word, "LS")) && (!WC::streq(P.word, "DIR")) )
      return( FALSE );

   if ( (!P.get()) && (WC::streq(P.word, "-LONG")) )
      verbose = TRUE;

   // obtain man dir-entry name length
   pdir = dir;
   while (pdir != NULL) {
      tmp  = strlen( pdir->name );
      if ( tmp > nlen )
         nlen = tmp;
      pdir = pdir->next;
   }
   nlen++;

   // loop thu each entry while printing
   pdir = dir;
   col  = 80 / (nlen+9);
   tmp  = 0;
   while ( pdir != NULL ) {

      printf( "%6lu ",  pdir->inode_num );

      if ( verbose ) {
         if (S_ISDIR(pdir->inode.i_mode))
            printf("d");
         else if (S_ISREG(pdir->inode.i_mode))
            printf("-");
         else if (S_ISLNK(pdir->inode.i_mode))
            printf("l");
         else if (S_ISCHR(pdir->inode.i_mode))
            printf("c");
         else if (S_ISBLK(pdir->inode.i_mode))
            printf("b");
         else if (S_ISFIFO(pdir->inode.i_mode))
            printf("p");
         else if (S_ISSOCK(pdir->inode.i_mode))
            printf("s");
         else
            printf("?");
         printf(" ");
      }

      if ( verbose ) {
         printf("%c%c%c%c%c%c%c%c%c ",
                     pdir->inode.i_mode&S_IRUSR ? 'r' : '-',
                     pdir->inode.i_mode&S_IWUSR ? 'w' : '-',
                     pdir->inode.i_mode&S_IXUSR ? 'x' : '-',
                     pdir->inode.i_mode&S_IRGRP ? 'r' : '-',
                     pdir->inode.i_mode&S_IWGRP ? 'w' : '-',
                     pdir->inode.i_mode&S_IXGRP ? 'x' : '-',
                     pdir->inode.i_mode&S_IROTH ? 'r' : '-',
                     pdir->inode.i_mode&S_IWOTH ? 'w' : '-',
                     pdir->inode.i_mode&S_IXOTH ? 'x' : '-');
      }

      if ( verbose ) {
         if (S_ISCHR(pdir->inode.i_mode) || S_ISBLK(pdir->inode.i_mode))
            printf("%3ld, %3ld ",
                   pdir->inode.i_block[0]>>8,
                   pdir->inode.i_block[0]&0xff);
         else
            printf("%8ld ", pdir->inode.i_size);
      }

      if ( verbose ) {
         printf( "%*.*s", nlen, nlen, pdir->name );
         if (S_ISLNK(pdir->inode.i_mode))
            printf(" -> %s",(CHAR*)pdir->inode.i_block);
         else if (S_ISDIR(pdir->inode.i_mode))
            printf( "/" );
      } else {
         strcpy( fname, pdir->name );
         if (S_ISLNK(pdir->inode.i_mode))
            strcat( fname, "@" );
         else if (S_ISDIR(pdir->inode.i_mode))
            strcat( fname, "/" );
         printf( "%-*.*s", nlen, nlen, fname );
      }

      if ( verbose ) {
         printf( "\n" );
         if ( ++lcnt == 22 ) {
            printf( "Pause: " );
            lcnt = getchar();
            if ( lcnt == 0 )
               getchar();
            if (
                 (lcnt == 'q') || (lcnt == 'Q') ||
                 (lcnt == 'x') || (lcnt == 'X') ||
                 (lcnt == 0x1b)
               )
               break;
            lcnt= 0;
         }
      } else {
         if ( (tmp+1) >= col ) {
            printf( "\n" );
            tmp =  -1;
            if ( ++lcnt == 22 ) {
               printf( "Pause: " );
               lcnt = getchar();
               if ( lcnt == 0 )
                  getchar();
               if (
                    (lcnt == 'q') || (lcnt == 'Q') ||
                    (lcnt == 'x') || (lcnt == 'X') ||
                    (lcnt == 0x1b)
                  )
                  break;
               lcnt= 0;
            }
         } else {
            printf( " " );
         }
         tmp++;
      }
      pdir = pdir->next;
   }
   if ( !verbose )
      printf( "\n" );

   // done
   return( TRUE );

} /* exec_ls */


GLOBAL BOOLEAN exec_cd( VOID )
{
 INT_4            save_ino;
 CHAR             save_cwd[MAX_CWDSIZE];
 INT_2            save_cwd_idx;
 BOOLEAN          first;
 DIR_TYP         *pdir;

   if ( !WC::streq(P.word, "CD") )
      return( FALSE );

   // save current settings
   save_ino = inode_no;
   memcpy( save_cwd, cwd, MAX_CWDSIZE );
   save_cwd_idx = cwd_idx;
   P.seperators( " /" );

   // loop thru each
   first = TRUE;
   while (TRUE) {

      if ( P.get(PARSE::_ASIS|PARSE::_STRIP) ) {
         if ( first ) {
            P.seperators();
            set_errhdl( ERR_CMD_UNKNOWN );
            return( TRUE );
         }
         break;
      }

      if ( P.word[0] == '/' ) {
         if ( first ) {
            first = FALSE;
            memset( cwd, (cwd_idx=0), MAX_CWDSIZE );
            if ( loadinode_FS(2) != 0 )
               goto x_restore;
            if ( loaddir_FS() != 0 )
               goto x_restore;
         }
         continue;
      }

      pdir = dir;
      while ( pdir != NULL ) {
         if ( strcmp(P.word, pdir->name) == 0 )
            break;
         pdir = pdir->next;
      }

      if ( pdir == NULL ) {
         printf( "Not a directory\n" );
         goto x_restore;
      }

      if ( strcmp(pdir->name, "..") == 0 ) {
         if ( cwd_idx <= 2 ) {
            memset( cwd, (cwd_idx=0), MAX_CWDSIZE );
         } else {
            cwd_idx -= 2;
            while ( (cwd_idx >= 0) && (cwd[cwd_idx] != 0) ) {
               cwd[cwd_idx--] = 0;
            }
            cwd_idx++;
         }
      } else {
         strcpy( &cwd[cwd_idx], pdir->name );
         while ( cwd[cwd_idx] != 0 )
            cwd_idx++;
         cwd_idx++;
         cwd[cwd_idx] = 0;;
      }
      if ( loadinode_FS(pdir->inode_num) != 0 )
         goto x_restore;
      if ( _MKMODE(inode.i_mode) == IMODE_SLINK ) {
         set_errhdl( ERR_IO_SLINK );
         goto x_restore;
      }
      if ( loaddir_FS() != 0 )
         goto x_restore;

      first = FALSE;

   } /* endwhile */

   goto x_done;

x_restore:

   memcpy( cwd, save_cwd, MAX_CWDSIZE );
   cwd_idx =  save_cwd_idx;
   if ( loadinode_FS(save_ino) == 0 )
      loaddir_FS();

x_done:

   P.seperators();
   return( TRUE );

} /* exec_cd */


GLOBAL BOOLEAN exec_pwd( VOID )
{
 CHAR   *pwd;

   if ( !WC::streq(P.word, "PWD") )
      return( FALSE );

   pwd = cwd;
   if ( *pwd == 0 )
      printf( "/" );
   while ( *pwd != 0 ) {
      printf( "/" );
      while ( *pwd != 0 )
         printf( "%c", *pwd++ );
      pwd++;
   }
   printf( "\n" );

   return( TRUE );

} /* exec_pwd */


STATIC BOOLEAN dosearch( VOID )
{
 INT_2       i;
 INT_4       idx;
 INT_4       blocksize;
 CHAR       *pblock;
 INT_2       pblock_i;
 BOOLEAN     found;
 INT_2       maxname_len;
 INT_2       minname_len;
 INT_2       zerocnt;
 SLIST_TYP  *plist;

   // setup
   blocksize = ( EXT2_BASE_BLOCK << sb->s_log_block_size );
   if ( block == NULL ) {
      block = (CHAR *) ::malloc( blocksize );
      if ( block == NULL ) {
         set_errhdl( ERR_SYS_NOMEM );
         return( TRUE );
      }
   }

   // set max name len
   maxname_len = 0;
   minname_len = 100;
   for( i=0; (i < slist_len); i++ ) {
      zerocnt = slist[i].name_len;
      if ( zerocnt > maxname_len )
         maxname_len = zerocnt;
      if ( zerocnt < minname_len )
         minname_len = zerocnt;
   }

   // for each requested block
   for( idx=sblock; (idx <= eblock); idx++ ) {

      // get the block of interest
      if ( read_LIBIO(block, blocksize, blocksize*idx) != 0 ) {
         fprintf( outfp, "%9ld contains BAD BLOCK ****\n", idx );
         continue;
      }

       // set all entries to match
      zerocnt  = 0;
      pblock   = block;
      pblock_i = 0;

      // init the match list
      for( i=0; (i < slist_len); i++ )
         slist[i].matched = FALSE;

      // loop it
      while (pblock_i < blocksize-minname_len+1) {

         if ( pblock[pblock_i] == 0 ) {
            if ( ++zerocnt == 20 )
               break;
            pblock_i++;
            continue;
         } else {
            zerocnt = 0;
         }

         found = TRUE;
         for( i=0; (i < slist_len); i++ ) {
            plist = &slist[i];
            if ( plist->matched )
               continue;
            if (strncmp(plist->name,&pblock[pblock_i],plist->name_len) == 0)
               plist->matched = TRUE;
            else
               found = FALSE;
         }
         if ( found )
            break;

         pblock_i++;

      } /* end while */

      // display matches
      for( i=0; (i < slist_len); i++ ) {
         if ( !slist[i].matched )
            continue;
         fprintf( outfp, "%9ld contains \"%s\"\n", idx, slist[i].name );
      }

   } /* end for */

    // done
    return( TRUE );

} /* dosearch */


GLOBAL BOOLEAN exec_search( VOID )
{
 INT_2      i;
 CHAR      *pname;
 INT_2      pname_len;

   if ( !WC::streq(P.word, "SEARCH") )
      return( FALSE );

   if ( P.get() )
      goto x_done;

   if ( WC::streq(P.word, "LIST") ) {
      while ( !P.get() ) {
         if ( slist_len == MAX_SLIST ) {
            set_errhdl( ERR_SYS_NOMEM );
            return( TRUE );
         }
         if ( (P.word[0] == '\"') || (P.word[0] == '\'') ) {
            if ( P.delimited() )
               return( FALSE );
         }
         pname_len = strlen(P.word);
         pname     = (CHAR *) ::malloc( pname_len+1 );
         if ( pname == NULL ) {
            set_errhdl( ERR_SYS_NOMEM );
            return( TRUE );
         }
         strcpy( pname, P.word );
         slist[slist_len].name     = pname;
         slist[slist_len].name_len = pname_len;
         slist_len++;
      }
      return( TRUE );
   }

   if ( WC::streq(P.word, "DUMP") ) {
      for( i=0; (i < slist_len); i++ )
         printf( "%3d) \"%s\"\n", i+1, slist[i].name );
      return( TRUE );
   }

   if ( WC::streq(P.word, "CLEAR") ) {
      for( i=0; (i < slist_len); i++ ) {
         if ( slist[i].name != NULL )
            ::free( slist[i].name );
         memset( &slist[i], 0, sizeof(SLIST_TYP) );
      }
      slist_len = 0;
      return( TRUE );
   }

   if ( WC::streq(P.word, "EXEC") ) {
      if ( !eval_expr(&sblock, ",-") )
         return( TRUE );
      if ( !eval_expr(&eblock) )
         return( TRUE );
      if ( slist_len == 0 ) {
         set_errhdl( ERR_SYS_NOINIT );
         return( TRUE );
      }
      if ( sblock > eblock )
         goto x_done;
      if ( !dosearch() )
         goto x_done;
      return( TRUE );
   }

x_done:

   set_errhdl( ERR_CMD_UNKNOWN );
   return( TRUE );

} /* exec_search */


/*-------------------------------------------------------------------------*/

