/*   user0.cc : February 1, 1994    */

/* Copyright (C) 1994-1999  Sekhar Bala, Rama Bala, and
 *                          Alphax System, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <string.h>

#include "std.h"
#include "wildcard.h"
#include "parse.h"
#include "symtab.h"
#include "input.h"

#include "main.h"
#include "dump.h"
#include "ext2fs.h"
#include "diskio.h"


/*-------------------------------------------------------------------------*/


STATIC VOID setup_HLP( VOID )
{

   //

   set_sum_help( "dump <subcmd> ...        : dump specific information"     );
   set_sum_help( "set  <subcmd> ...        : set specific information"      );
   set_sum_help( "read <subcmd> ...        : read specific information"     );
   set_sum_help( "ls  [-long]              : display directory listing"     );
   set_sum_help( "dir [-long]              : display directory listing"     );
   set_sum_help( "cd <path>                : change directory"              );
   set_sum_help( "pwd                      : print working directory"       );
   set_sum_help( "search <subcmds> ...     : raw disk-data search"          );
   set_sum_help( "cp [-dv] file-pattern    : copy files from ext2 to dos"   );
   set_sum_help( "fs <subcmds> ...         : special purpose recovery cmds" );
   set_sum_help( "                         : type help \"variables\""       );

   // 

   set_desc_help( "DUMP",
      "FMT: DUMP  <subcmd> ...\n"
      "     ----------------------------------------------------------\n"
      "FMT: DUMP  disk                  - show disk parameters\n"
      "FMT: DUMP  partition [hex]       - show partition tables\n"
      "FMT: DUMP  superblock [verbose]  - show superblock parameters\n"
      "FMT: DUMP  groups [index #]      - show group-desc tables\n"
      "FMT: DUMP  inode                 - show current inode\n"
      "FMT: DUMP  inode table           - show inode's block table\n"
      "FMT: DUMP  inode blocks          - show inode's used blocks\n"
      "FMT: DUMP  dir <fname>           - dump dir as 'fs dir' cmdfile\n"
      "FMT: DUMP  block #               - dump data block #\n"
      "FMT: DUMP  [next | previous]     - dump next|[rev seq data block\n"
      "FMT: DUMP  badinode              - show bad inode list\n"
                );

   set_desc_help( "SET",
      "FMT: SET  <subcmd> ...\n"
      "     ----------------------------------------------------------\n"
      "FMT: SET  disk [0,1,128-n]       - set source disk\n"
      "FMT: SET  superblock [AT #]      - read sb at # or reset default\n"
      "FMT: SET  groups [AT #]          - set group-desc at # or reset\n"
      "FMT: SET  partition n            - select active partition\n"
      "FMT: SET  output <fname>         - redirect all output to fname\n"
      "FMT: SET  close                  - close above output fname\n"
                );

   set_desc_help( "READ",
      "FMT: READ  <subcmd> ...\n"
      "     ----------------------------------------------------------\n"
      "FMT: READ  inode #               - read specific inode #\n"
      "FMT: READ  directory             - read current inode as directory\n"
      "FMT: READ  block #               - read block #\n"
                );

   set_desc_help( "LS",
      "FMT: LS  [-long]\n"
      "     display listing of current directory optionally in long format\n"
                );

   set_desc_help( "DIR",
      "FMT: DIR  [-long]\n"
      "     display listing of current directory optionally in long format\n"
                );

   set_desc_help( "CD",
      "FMT: CD  <path>\n"
      "     change current directory to <path>\n"
                );

   set_desc_help( "PWD",
      "FMT: PWD \n"
      "     print current working directory\n"
                );

   set_desc_help( "SEARCH",
      "FMT: SEARCH  <subcmd> ...\n"
      "     -----------------------------------=--------------------------\n"
      "FMT: SEARCH  list string [string] ...   - set search strings\n"
      "FMT: SEARCH  clear                      - clear search string-list\n"
      "FMT: SEARCH  dump                       - show string-list\n"
      "FMT: SEARCH  exec sblock# <,-> eblock#  - execute search @ starting\n"
      "                                          block to ending block\n"
                );

   set_desc_help( "CP",
      "FMT: CP  [-dv]  linux-file-pattern\n"
      "     copy files from ext2 to dos current directory\n"
      "     opts are:\n"
      "       -d  - debug mode; just display what would be done\n"
      "       -v  - verbosely execute command\n"
                );

   set_desc_help( "FS",
      "FMT: FS  [subcmd] ...\n"
      "     subcmds are: DIR, BCKCPY, BAD\n"
      "     -----------------------------------=--------------------------\n"
      "\n"
      "FMT: FS  DIR  BEGIN\n"
      "     FS  DIR  ENTRY \"fname\" inode-#\n"
      "     FS  DIR  END [block-#]\n"
      // create a directory-header internally and write it out to disk
      "\n"
      "FMT: FS  BCKCPY  [-vrd]  src-pattern  target-dos-dir\n"
      "     opts are:\n"
      "       -v  - verbosely execute command\n"
      "       -r  - recurse into the subdirectories\n"
      "       -d  - debug mode; create/document files without actual data\n"
      "     copies from multiple linux-files to dos-files\n"
      "     type HELP SFORM for more info\n"
      // files.dat with mangled names etc...
      "\n"
      "FMT: FS  BAD INODE #, mode-#, size { b-#, b-#, ... }\n"
      "     mode-#  -> can be $M_DIR or $M_FILE\n"
      "     size {} -> can use 'block# - block#' for a ranges\n"
      // set internal mem/cache with a list of bad inodes (like marking them)
                );

   set_desc_help( "SFORM",
      "About FS BCKCPY command:\n"
      "  This command creates 2 sys-files 'files.lst', 'files.bad', and,\n"
      "  each of the appropriate data files tagged and renamed.  The\n"
      "  'files.lst' contains actual linux dir-names and file-names.  The\n"
      "  'files.bad' contains names/inodes of files with bad disk data\n"
      "  Each data-file is named 'fxxxxxxx.dat' where xxxxxxx is a nunber.\n"
      "  This done so that DOS short-names and Linux long-names resolve.\n"
                );

   set_desc_help( "VARIABLES",
      "The following variables are available for manipulation\n"
      "  verbose              - $TRUE or $FALSE\n"
      "  diskio_verbose       - $TRUE or $FALSE => debug level verboseness\n"
      "  retry                - # to specify number of disk-io retries\n"
      "  M_DIR                - specify a directory mode entry\n"
      "  M_FILE               - specify a file mode entry\n"
      "  automatic            - set automatic mode\n"
#if !defined(GO32)
      "  readonly             - open /dev/... as readonly (def: $TRUE)\n"
      "  devicename           - set device name (def: /dev/hda)\n"
#endif
                );

   return;

} /* setup_help */


GLOBAL BOOLEAN init_APP( VOID )
{
 SYMBOL_TYP       sym;

   // general
   setup_HLP();

   // internal vars
   sym.type       = ST_TYPE_INT;
   if ( WC::strxfer(sym.symbol, "VERBOSE") != 0 )
      return( FALSE );
   sym.value      = (VOID *) &verbose;
   sym.value_len  = sizeof(BOOLEAN);
   sym.value_free = FALSE;
   symtab.insert( &sym );
   //
   sym.type       = ST_TYPE_INT;
   if ( WC::strxfer(sym.symbol, "RETRY") != 0 )
      return( FALSE );
   sym.value      = (VOID *) &g_retry;
   sym.value_len  = sizeof(INT_U2);
   sym.value_free = FALSE;
   symtab.insert( &sym );
   //
   sym.type       = ST_TYPE_INT;
   if ( WC::strxfer(sym.symbol, "DISKIO_VERBOSE") != 0 )
      return( FALSE );
   sym.value      = (VOID *) &g_verbose_libio;
   sym.value_len  = sizeof(INT_U2);
   sym.value_free = FALSE;
   symtab.insert( &sym );
   //
   sym.type       = ST_TYPE_INT;
   if ( WC::strxfer(sym.symbol, "AUTOMATIC") != 0 )
      return( FALSE );
   sym.value      = (VOID *) &automatic;
   sym.value_len  = sizeof(INT_U2);
   sym.value_free = FALSE;
   symtab.insert( &sym );
#if !defined(GO32)
   //
   sym.type       = ST_TYPE_INT;
   if ( WC::strxfer(sym.symbol, "readonly") != 0 )
      return( FALSE );
   sym.value      = (VOID *) &g_readonly;
   sym.value_len  = sizeof(INT_U2);
   sym.value_free = FALSE;
   symtab.insert( &sym );
   //
   sym.type       = ST_TYPE_CHAR;
   if ( WC::strxfer(sym.symbol, "devicename") != 0 )
      return( FALSE );
   sym.value      = (VOID *) g_devname;
   sym.value_len  = 20;
   sym.value_free = FALSE;
   symtab.insert( &sym );
#endif

   init_FS();
   init_LIBIO( 0xFFFF );

   // done
   return( TRUE );

} /* init_APP */


GLOBAL VOID clean_APP( VOID )
{

   clean_FS();
   clean_LIBIO();
   return;

} /* clean_APP */


/*-------------------------------------------------------------------------*/


