/*   main.cc : February 1, 1994    */

/* Copyright (C) 1994-1999  Sekhar Bala, Rama Bala, and
 *                          Alphax System, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <string.h>

#include "std.h"
#include "wildcard.h"
#include "parse.h"
#include "symtab.h"
#include "input.h"

#include "main.h"

/*-------------------------------------------------------------------------*/

#define FEXT              ".e2"

GLOBAL BOOLEAN            done                       = FALSE;
GLOBAL BOOLEAN            verbose                    = FALSE;
GLOBAL BOOLEAN            automatic                  = TRUE;

STATIC CHAR       *localdefs[] = {
// { "ECHO ON"           },
   { "INT TRUE"          },
   { "INT FALSE"         },
   { "INT ON"            },
   { "INT OFF"           },
   { "INT ROOT"          },
   { "INT32 M_FILE"      },
   { "INT32 M_DIR"       },
   { "ON = 1"            },
   { "FALSE = 0"         },
   { "TRUE = 1"          },
   { "OFF = 0"           },
   { "ROOT = 1"          },
   { "M_FILE = 0100755"  },
   { "M_DIR  = 0040755"  },
   { NULL                }
};
#define localdefs_len   ( (sizeof(localdefs)/sizeof(localdefs[0])) - 1 )

/*-------------------------------------------------------------------------*/


STATIC VOID load_localdefs( VOID )
{
 INT_2   i;
 INT_2   len;
 CHAR    buf[80];

   for( i=localdefs_len-1; (i >= 0); i-- ) {
      if ( localdefs[i] == NULL )
         break;
      len = strlen( localdefs[i] );
      memset( buf, 0, sizeof(buf) );
      strcpy( buf, localdefs[i] );
      input.push( buf, len+2 );
   }

} /* load_localdefs */


/*+
 *      NAME : process
 *
 *  FUNCTION : main command loop processor
 *
 *     ENTRY : none
 *
 *   RETURNS : none
 *
-*/
STATIC VOID process( VOID )
{
 CHAR       prompt[MAX_PROMPTBUF];
 BOOLEAN    is_keyboard;
 BOOLEAN    is_file;
 BOOLEAN    is_funct;
 BOOLEAN    echo;

   // header
   printf( "\n" );
   printf( MAIN_HDR );
   printf( "\n" );
   load_localdefs();

   // setup
   done   = FALSE;
   echo   = FALSE;
   strcpy( prompt, MAIN_PROMPT );

   // loop until done
   while ( !done ) {

      // handle error displays
      if ( errs[0] != 0 ) {
         errhdl( "ERROR" );
         printf("\n");
      }

      // determine type of input source
      is_keyboard = input.is_keyboard();
      is_file     = input.is_file();
      is_funct    = input.is_funct();

      // get input & register with Parser
      if ( !input.setup(prompt) )
         continue;

      // respond to current echo level
      if ( (!is_keyboard) && (echo) ) {
         for( INT_2 i=0; (i < (INT_2) strlen(prompt)-1); i++ )
            printf( "%c", ((is_file) ? '<' : '>')  );
         printf( " " );
         printf( P.cmd );
         printf( "\n" );
      }

      // get first keyword
      if ( P.get() )                // discard complete blank lines
         continue;

      // discard commented lines
      if ( P.word[0] == '#' )       // discard comment lines
         continue;

      // 
      // general keyword semantics
      //
      if ( exec_ifctl() )
         continue;

      // termination
      if ( WC::streq(P.word, "EXIT") || WC::streq(P.word, "QUIT") )
         break;

      // command-file execution redirection
      if ( P.word[0] == '@' ) {
         if ( P.get(PARSE::_FILENAME) ) {
            set_errhdl( ERR_CMD_FILENAME );
         } else
            input.push( P.word, FEXT );
         continue;
      }

      // return
      if ( WC::streq(P.word, "RETURN") ) {
         if ( (is_file) || (is_funct) ) {
            input.pop();
            continue;
         }
         set_errhdl( ERR_CMD_RETURN );
         continue;
      }

      // general psuedo language related
      if ( exec_debug() )
         continue;
      if ( exec_echo(&echo) )
         continue;
      if ( exec_quote() )
         continue;
      if ( exec_file() )
         continue;
      if ( exec_print() )
         continue;
      if ( exec_show() )
         continue;
      if ( exec_defvar() )
         continue;
      if ( exec_get() )
         continue;
      if ( exec_deffunct() )
         continue;
      if ( exec_call() )
         continue;
      if ( exec_while() )
         continue;
      if ( exec_for() )
         continue;
      if ( exec_loopctl() )
         continue;
      if ( exec_if() )
         continue;
      if ( exec_delete() )
         continue;

      // app related
      if ( exec_set() )
         continue;
      if ( exec_dump() )
         continue;
      if ( exec_read() )
         continue;
      if ( exec_ls() )
         continue;
      if ( exec_cd() )
         continue;
      if ( exec_pwd() )
         continue;
      if ( exec_fs() )
         continue;
      if ( exec_cp() )
         continue;
      if ( exec_search() )
         continue;

      if ( exec_expr() )
         continue;
      if ( exec_shell() )
         continue;
      if ( exec_help() )
         continue;
      set_errhdl( ERR_CMD_UNKNOWN );

   } /* end while */

   if ( errs[0] != 0 ) {
      errhdl( "ERROR" );
      printf( "\n" );
   }

    // done
    return;

} /* process */


// 
// program launcher
// 
main( int argc, char *argv[] )
{
 INT_2   starting;

   // 
   // arg1   = -          any user
   // arg2   = -          any user
   // ....   = ...        ...
   // argn   = filename for autoexecution
   // arg... = filename for autoexecution
   // 
   starting = 1;

   // setup
   if ( argc > starting ) {
      for( INT_2 idx=argc-1; (idx >= starting); idx-- )
         input.push( argv[idx] );
   }

   // main loop
   if ( !init_APP() ) {
      errhdl( "ERROR" );
      printf( "\n" );
   } else {
      process();
   }
   clean_APP();

   // cleanup
   if ( outfp != stdout ) {
      fclose( outfp );
      outfp = stdout;
   }

   // done
   return( 0 );

} /* main */


/*-------------------------------------------------------------------------*/



