/*   wildcard.cc : May 5, 1994   */

/* Copyright (C) 1994-1999  Sekhar Bala,
 *                          Ramchander Balasubramanian, and
 *                          Alphax Systems, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include <stdarg.h>

#include "std.h"
#include "wildcard.h"

/*------------------------------------------------------------------------*/


VOID WC::memset( VOID *ptr, INT_2 fill, SIZE_T len )
{

   if ( (ptr == NULL) || (len <= 0) )
      return;
   ::memset( ptr, fill, len );
   return;

} /* memset */


VOID WC::memcpy( VOID *trg, VOID *src, SIZE_T len )
{

   if ( (len <= 0) || (trg == NULL) || (src == NULL) )
      return;
   ::memcpy( trg, src, len );
   return;

} /* memcpy */


VOID WC::strlwr( CHAR *psrc )
{

   // test validity
   if ( psrc == NULL )
      return;

   // uppercase
   while ( *psrc != 0 ) {
      *psrc = LOWER(*psrc);
      psrc++;
   }

   // done
   return;

} /* strlwr */


VOID WC::strupr( CHAR *psrc )
{

   // test validity
   if ( psrc == NULL )
      return;

   // lowercase
   while ( *psrc != 0 ) {
      *psrc = UPPER(*psrc);
      psrc++;
   }

   // done
   return;

} /* strupr */


STATIC BOOLEAN xequal( CHAR *token, CHAR *keyword, INT_2 token_len )
{
 CHAR      tch;
 CHAR      kch;
 BOOLEAN  ans;

   ans = (*token != (CHAR) 0);
   while ( ans ) {
      if ( (tch = *token++) == 0 )
         break;
      if (
           ( (kch = *keyword++) == 0 )                     ||
           ( (tch & (CHAR) 0xDF) != (kch & (CHAR) 0xDF) )
         ) {
         ans = FALSE;
         break;
      }
      if ( --token_len == 0 )
         break;
   }
   return( ans );

} /* xequal */


BOOLEAN WC::streq( CHAR *word, CHAR *keys )
{

   return( xequal(word,keys,(INT_2) MAX_INT_2) );

} /* streq */


BOOLEAN WC::strneq( CHAR *word, CHAR *keys, INT_2 word_len )
{

   return( xequal(word,keys,word_len) );

} /* strneq */


INT_2 WC::strxfer( CHAR *&trg, CHAR *src )
{
 INT_2   l_ret = 0;

   if ( trg != NULL )
      ::free( trg );
   trg = NULL;
   if ( src != NULL ) {
      trg = (CHAR *) malloc( strlen(src)+1 );
      if ( trg != NULL ) {
         memset( trg, 0, strlen(src)+1 );
         ::strcpy( trg, src );
      } else {
         l_ret = set_errhdl( ERR_SYS_NOMEM );
      }
   }
   return( l_ret );

} /* strxfer */


INT_2 WC::sprintf( CHAR *trg, CHAR *fmt, ... )
{
 INT_2     len    = 0;
 va_list   vargs;

   va_start( vargs, fmt );
   if ( trg != NULL ) {
      vsprintf( trg, fmt, vargs );
      len = strlen( trg );
   }
   va_end( vargs );
   return( len );

} /* sprintf */


/*------------------------------------------------------------------------*/


