/*   parse.cc : May 5, 1994   */

/* Copyright (C) 1994-1999  Sekhar Bala,
 *                          Ramchander Balasubramanian, and
 *                          Alphax Systems, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include <stdarg.h>

#include "std.h"
#include "wildcard.h"
#include "parse.h"

/*-------------------------------------------------------------------------*/

CHAR        PARSE::PP_seps[80] = { DEFAULT_SEPERATORS };

/*-------------------------------------------------------------------------*/


VOID PARSE::izero( VOID )
{

   seps     = NULL;
   cmd_len  = 0;
   cmd      = NULL;
   word     = NULL;
   word_len = 0;
   word_pos = 0;
   word_idx = 0;
   return;

} /* zero */


VOID PARSE::clear( VOID )
{

   if ( cmd != NULL )
      ::free( cmd );
   cmd      = NULL;
   cmd_len  = 0;
   if ( word != NULL )
      ::free( word );
   word     = NULL;
   word_len = 0;
   word_pos = 0;
   word_idx = 0;
   return;

} /* clear */


INT_2 PARSE::command( CHAR *ucmd )
{
 INT_2   l_ret;

   clear();
   if ( ucmd == NULL )
      return( set_errhdl(ERR_P_NOTOKENS) );
   cmd_len = strlen( ucmd );
   word    = (CHAR *) malloc( (cmd_len*2)+1 );
   if ( word == NULL ) {
      return( set_errhdl(ERR_SYS_NOMEM) );
   }
   memset( word, 0, cmd_len+1 );
   l_ret = WC::strxfer( cmd, ucmd );
   return( l_ret );

} /* command */


BOOLEAN PARSE::get( INT_2 umask, ... )
{
                          /* user variables */
 INT_2     upos;
 INT_2     ucount;
 INT_2     uidx;
 BOOLEAN   uasis;
 BOOLEAN   ustrip;
                          /* working variables */
 INT_2     wpos;
 INT_2     wcount;
 INT_2     widx;
 BOOLEAN   werr;
                          /* general working variables */
 BOOLEAN   blanks;
 CHAR      ch;
 CHAR      file_ch = 0;
 va_list   arg;

   /* obtain user information with initialization */
   if ( cmd == NULL )
      return( TRUE );
   va_start( arg, umask);
   uasis = FALSE;
   if ( umask & _ASIS )
      uasis = TRUE;
   if ( umask & _FILENAME ) {
      uasis       = TRUE;
      file_ch     = PP_seps[26];
      PP_seps[26] = 0;
   }
   ustrip = FALSE;
   if ( umask & _STRIP )
      ustrip = TRUE;
   ucount = 1;
   if ( umask & _COUNT )
      ucount = va_arg( arg, INT_2 );
   upos = -1;
   if ( umask & _RANDOM )
      upos = va_arg( arg, INT_2 );

   /* initialization for all options */
   word_len = 0;
   blanks   = TRUE;
   werr     = FALSE;
   wpos     = -1;
   wcount   = ucount;
   widx     = word_idx;

   /* initialization information for determined options */
   if ( upos != -1 )
      widx = 0;
   uidx = widx;

   /* loop while constructing each token */
   while ( wcount > 0 ) {

      ch = cmd[widx++];
      if ( blanks ) {
         if ( ch == ' ' )
            continue;
         if ( (ustrip) && (wcount == ucount) )
            uidx = widx-1;
         if ( ch == 0 ) {
            widx--;
            werr = (wcount == ucount);
            break;
         }
      }

      if ( strchr(seps, ch) != NULL ) {
         if ( upos > wpos ) {
            if ( ++wpos != upos ) {
               word_len = 0;
               if ( !blanks )
                  widx--;
               uidx   = widx;
               blanks = TRUE;
               continue;
            }
         }
         if (blanks) {
            word[word_len++] = ch;
         } else {
            widx--;
         }
         blanks = TRUE;
         if ( --wcount > 0 )
            word[word_len++] = ' ';
         continue;
      }

      word[word_len++] = UPPER(ch);
      blanks = FALSE;
      
   }

   /* clean-up last formats */
   if ( uasis )
      memcpy( word, &cmd[uidx], (word_len = widx-uidx) );
   word[word_len] = 0;

   /* save current parse information */
   if ( upos == -1 ) {
      word_idx  = widx;
      word_pos += ucount;
   }

   va_end(arg);
   if ( umask & _FILENAME )
      PP_seps[26] = file_ch;
   return( werr );

} /* get */


CHAR *PARSE::cmd_ptr( VOID )
{

   if ( cmd == NULL )
      return( NULL );
   return( &cmd[word_idx] );

} /* cmd_ptr */


BOOLEAN PARSE::delimited( BOOLEAN inc_sep )
{
 BOOLEAN   werr;
 INT_2     widx;
 CHAR      ch;

   if ( (cmd == NULL) || (word == NULL) )
      return( FALSE );
   widx = word_idx;
   ch = cmd[widx-1];
   if ( inc_sep ) {
      widx = word_idx - 1;
      ch   = cmd[widx];
   }
   if ( ch == 0 )
      return( FALSE );
   while (TRUE) {
      werr = get();
      if ( werr )
         break;
      if ( word[0] != ch )
         continue;
      word_len = ( (inc_sep) ? (word_idx - widx) : (word_idx - widx - 1) );
      memcpy( word, &cmd[widx], word_len );
      word[word_len] = 0;
      break;
   }
   return( werr );

} /* delimited */


/*-------------------------------------------------------------------------*/


