/*   help.cc : May 5, 1994   */

/* Copyright (C) 1994-1999  Sekhar Bala,
 *                          Ramchander Balasubramanian, and
 *                          Alphax Systems, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <string.h>

#include "std.h"
#include "wildcard.h"
#include "parse.h"
#include "input.h"
#include "cgets.h"


/*-------------------------------------------------------------------------*/

typedef struct {
   CHAR     *keyword;
   CHAR     *desc;
} HELP_TYP;

STATIC INT_2            x_sum_len            = 0;
STATIC CHAR            *x_sum[MAX_APP_CMDS]  = { NULL, };

STATIC INT_2            x_desc_len           = 0;
STATIC HELP_TYP         x_desc[MAX_APP_CMDS] = { {NULL, NULL}, };

/*-------------------------------------------------------------------------*/



GLOBAL BOOLEAN set_sum_help( CHAR *summary_line )
{

   if ( x_sum_len >= MAX_APP_CMDS )
      return( FALSE );
   x_sum[x_sum_len] = summary_line;
   x_sum_len++;
   return( TRUE );

} /* set_sum_help */


GLOBAL BOOLEAN set_desc_help( CHAR *keyword, CHAR *desc )
{

   if ( x_desc_len >= MAX_APP_CMDS )
      return( FALSE );
   x_desc[x_desc_len].keyword = keyword;
   x_desc[x_desc_len].desc    = desc;
   x_desc_len++;
   return( TRUE );

} /* set_desc_help */


STATIC VOID summary( CHAR *kw=NULL )
{
 INT_2  i;

   if ( kw != NULL )
      printf( "Invalid command '%s'!\n", kw );
   printf( "Commands are: \n" );
   printf( "  <type>  var-name         : define variable (help type)\n");
   printf( "  var-name = expression    : usual no-prec (help expressions)\n");
   printf( "  file [opts]              : set output file (help file)\n");
   printf( "  print [opts] <text-expr> : display text-expr\n" );
   printf( "  show [hex] [var-name]    : show variable def & value\n");
   printf( "  delete <var-name>        : delete variable definition\n" );
   printf( "  echo [on | off]          : set echo level (see funct/file)\n" );
   printf( "  quote [on | off]         : use quotes on references or not\n" );
   printf( "  @<file>                  : execute command filename\n" );
   printf( "  return                   : return from command file\n" );
   printf( "  function ...             : define function (help function)\n" );
   printf( "  call func-name(a,b,..)   : execute function with args\n" );
   printf( "  while (expr) { ... }     : loop control (help while)\n" );
   printf( "  if (expr) { ... }        : if control (help if)\n" );
   printf( "  for (...) { ... }        : for contorl\n" );
   printf( "  get <var> [prompt-txt]   : get user input into variable\n" );
   printf( "  shell | ! <sys-cmd>      : execute system command\n" );
   for( i=0; (i < x_sum_len); i++ ) {
      printf( "  %s\n", x_sum[i] );
   }
   printf( "  quit | exit              : terminate programm\n");
   printf( "  #                        : comment (can use ';' at-eol)\n" );
   return;

} /* summary */


GLOBAL BOOLEAN exec_help( VOID )
{
 INT_2  i;

   if ( !WC::streq(P.word, "HELP") )
      return( FALSE );

   if ( (P.get()) || (P.word[0] == ';') ) {
      summary();
      goto x_done;
   }

   if ( WC::streq(P.word, "TYPE") ) {
      printf( "\n"
              "FMT: <type> <uname> [ [#] ]\n"
              "\n"
              "Valid Types are:  \n"
              "   INT      - 2 byte integer\n"
              "   INT32    - 4 byte integer\n"
              "   CHAR     - 1 byte character\n"
              "   CHAR []  - an array of character\n"
              "\n"
              "Examples:\n"
              "  INT   aaa\n"
              "  CHAR  bbb[30]\n"
              "\n" );
      goto x_done;
   }

   if ( WC::streq(P.word, "EXPRESSIONS") ) {
      printf( "\n"
              "- expression can contain  '$<var-nam>' references.\n"
              "- normal ops with no precedence rules\n"
              "  %% * / | & ^ ~ ! + - > < == != >= <= >> << && ||\n"
              "- '()' parenthesis are used for operational precedences\n"
              "- $NOW - current date/time in binary (INT32)\n"
              "   binary = $NOW\n"
              "- built-in functions:\n"
              "   string <= $DT_DATE  ( [binary-value] )\n"
              "           - returns MMM-DD-YY (or $DT_DATEY2)\n"
              "   string <= $DT_DATEY4 ( [binary-value] )\n"
              "           - returns MMM DD, YYYY\n"
              "   string <= $DT_TIME  ( [binary-value] )\n"
              "           - returns hh:mm:ss\n"
              "   string <= $DT_DATETIME  ( [binary-value] )\n"
              "           - returns MMM DD, YYYY hh:mm:ss\n"
              "   string <= $SYS_ENV( \"envvar-name\" )\n"
              "           - returns SHELL environment var value\n"
              "\n"
              "Examples:\n"
              "  aaa = 99 * 10\n"
              "  bbb[10] = 'a'\n"
              "  bbb = \"This is it\"\n"
              "\n" );
      goto x_done;
   }

   if ( WC::streq(P.word, "SHOW") ) {
      printf( "\n"
              "FMT: SHOW [hex] [var-name [, var-name, ...]];\n"
              "\n"
              "- show variable definitions and values\n"
              "- optionally in [hex] or not"
              "- '*' is wildcard (All symbols)\n"
              "\n"
              "Examples:\n"
              "  show aaa\n"
              "  show hex aaa\n"
              "  show \n"
              "  show *\n"
              "\n" );
      goto x_done;
   }

   if ( WC::streq(P.word, "DELETE") ) {
      printf( "\n"
              "FMT: DELETE var-name [, var-name, ...];\n"
              "\n"
              "- delete a variable definition\n"
              "- keyword 'DEL' allowed\n"
              "\n"
              "Examples:\n"
              "  delete aaa;\n"
              "  del aaa;\n"
              "\n" );
      goto x_done;
   }

   if ( WC::streq(P.word, "FUNCTION") ) {
      printf( "\n"
              "FMT: \n"
              "     FUNCTION user-name( #-of-args )\n"
              "     { \n"
              "     ...  ; use $1, $2, $n for arg-reference\n"
              "     } \n"
              "\n"
              "- define a function\n"
              "- NOTE: all variables are global (use del at end)\n"
              "\n" );
      goto x_done;
   }

   if ( WC::streq(P.word, "WHILE") ) {
      printf( "\n"
              "FMT: WHILE (expr)\n"
              "     { \n"
              "     ...  ;\n"
              "     BREAK;\n"
              "     ...  ;\n"
              "     CONTINUE | CONT ;\n"
              "     ...  ;\n"
              "     } \n"
              "\n"
              "- define a conditionally controlled loop\n"
              "\n" );
      goto x_done;
   }

   if ( WC::streq(P.word, "IF") ) {
      printf( "\n"
              "FMT: \n"
              "     IF (expr)  \n"
              "     {          \n"
              "     ...        \n"
              "     } ELSE IF {\n"
              "     ...        \n"
              "     } ELSE {   \n"
              "     ...     ;  \n"
              "     }          \n"
              "\n"
              "- define conditional sequential execution\n"
              "\n" );
      goto x_done;
   }

   if ( WC::streq(P.word, "FOR") ) {
      printf( "\n"
              "FMT: \n"
              "     FOR ( stmt, stmt, ...; (expr); stmt, stmt, ... )\n"
              "     {      \n"
              "     ...  ; \n"
              "     BREAK; \n"
              "     ...  ; \n"
              "     CONTINUE | CONT ;\n"
              "     ...  ;\n"
              "     } \n"
              "\n"
              "- define an extended conditionally controlled loop\n"
              "\n" );
      goto x_done;
   }

   if ( WC::streq(P.word, "GET") ) {
      printf( "\n"
              "FMT: GET <var> [prompt]\n"
              "\n"
              "- get input from user and store in defined variable\n"
              "\n"
              "Examples:\n"
              "  int i;\n"
              "  char name[30];\n"
              "\n"
              "  get i \"Number: \"\n"
              "  get name \"String: \"\n"
              "\n" );
      goto x_done;
   }

   if ( WC::streq(P.word, "PRINT") ) {
      printf( "\n"
              "FMT: PRINT [opts] user-text\n"
              "\n"
              "- display user-text on the screen\n"
              "- [opts] are:\n"
              "  -n     - suppress newline\n"
              "  -e     - translate user-text\n"
              "           /n /r /t /f\n"
              "           /e   = insert escape char\n"
              "  -o     - redirect output to FILE-cmd output\n"
              "\n" );
      goto x_done;
   }

   if ( WC::streq(P.word, "FILE") ) {
      printf( "\n"
              "FMT: FILE [CLOSE | filename]\n"
              "\n"
              "- display current output direction\n"
              "- CLOSE will close current output designation\n"
              "- 'filename' will open for output dumps\n"
              "  optional: -a filename for file appending\n"
              "\n"
              "Examples:\n"
              "  FILE \n"
              "  FILE  CLOSE \n"
              "  FILE  myfile.out \n"
              "  FILE -a myfile.out \n"
              "\n" );
      goto x_done;
   }

   // loop thru all app-defined commands
   for( i=0; (i < x_desc_len); i++ ) {
      if ( WC::streq(P.word, x_desc[i].keyword) ) {
         printf( "\n%s\n", x_desc[i].desc );
         goto x_done;         
      }
   }

   summary( P.word );

x_done:

   return( TRUE );

} /* exec_help */


/*-------------------------------------------------------------------------*/

