/*   symtab.h : May 5, 1994   */

/* Copyright (C) 1994-1999  Sekhar Bala,
 *                          Ramchander Balasubramanian, and
 *                          Alphax Systems, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SYMTAB_H
#define __SYMTAB_H
  

/*-------------------------------------------------------------------------*/

#define ST_TYPE_NONE          0
#define ST_TYPE_INT32         1
#define ST_TYPE_INT           2
#define ST_TYPE_CHAR          3
#define ST_TYPE_FUNCT         4
#define ST_TYPE_MAX           5

#define DEFAULT_STRINGLEN     80

/*-------------------------------------------------------------------------*/


class SYMBOL_TYP {
 PUBLIC:
   STATIC CHAR    *typenames[ST_TYPE_MAX];
   CHAR           *symbol;
   INT_2           type;
   BOOLEAN         value_free;
   INT_2           value_len;
   VOID           *value;
   INT_2           args;
 PUBLIC:
   VOID            zero        ( VOID );
   BOOLEAN         make        ( VOID );
   BOOLEAN         make        ( CHAR       *usymbol,
                                 INT_2       utype,
                                 BOOLEAN     uval_free,
                                 INT_2       uval_len,
                                 VOID       *uval,
                                 INT_2       uargs=0 );
   BOOLEAN         make        ( SYMBOL_TYP *sym );
   VOID            unmake      ( VOID );
 PUBLIC:
   SYMBOL_TYP()          { make(); }
   SYMBOL_TYP( CHAR    *usymbol,
               INT_2    utype,
               BOOLEAN  uval_free,
               INT_2    uval_len,
               VOID    *uval,
               INT_2    uargs=0 )
             { make(usymbol, utype, uval_free, uval_len, uval, uargs); }
   SYMBOL_TYP( SYMBOL_TYP *sym )
                         { make(sym); }
  ~SYMBOL_TYP()          { unmake(); }
};


class SYMTAB_TYP {
 PUBLIC:
   INT_2           table_len;
   SYMBOL_TYP   *(*table)[];
 PROTECTED:
   BOOLEAN         allocate    ( VOID );
   BOOLEAN         deallocate  ( VOID );
   BOOLEAN         sort_idx    ( VOID );
   INT_2           find_idx    ( CHAR *symbol, INT_2 ibeg=0, INT_2 iend=-1 );
 PUBLIC:
   SYMBOL_TYP     *find        ( CHAR *usymbol );
   BOOLEAN         insert      ( SYMBOL_TYP *usym );
   BOOLEAN         remove      ( CHAR *usymbol );
 PUBLIC:
   VOID            zero        ( VOID );
   BOOLEAN         make        ( VOID );
   VOID            unmake      ( VOID );
 PUBLIC:
   SYMTAB_TYP()         { make(); }
  ~SYMTAB_TYP()         { unmake(); }
};


/*-------------------------------------------------------------------------*/

EXTERN SYMTAB_TYP      symtab;

/*-------------------------------------------------------------------------*/
#endif


