/*   parse.h : May 5, 1994   */

/* Copyright (C) 1994-1999  Sekhar Bala,
 *                          Ramchander Balasubramanian, and
 *                          Alphax Systems, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __PARSE_H
#define __PARSE_H


/*------------------------------------------------------------------------*/

#define DEFAULT_SEPERATORS          " !\"#%&'()*+,-;<=>?@[]^~{}|:/\\."

/*------------------------------------------------------------------------*/


class PARSE {
 PUBLIC:
   enum PARSE_OPTS {
     _DEFAULT  =  0,
     _FILENAME =  1,
     _ASIS     =  2,
     _COUNT    =  4,
     _RANDOM   =  8,
     _STRIP    = 16
   };
   CHAR                *seps;
   CHAR                *cmd;
   INT_2                cmd_len;
   CHAR                *word;
   INT_2                word_len;
   INT_2                word_pos;
   INT_2                word_idx;
 PRIVATE:
   STATIC CHAR          PP_seps[80];
 PRIVATE:
   VOID     izero       ( VOID );
   VOID     clear       ( VOID );
 PUBLIC:
   PARSE                ( )
                        { izero(); seps = PP_seps; }
  ~PARSE                ()
                        { clear(); }
 PUBLIC:
   INT_2    command     ( CHAR *ucmd );
   BOOLEAN  get         ( INT_2 umask = _DEFAULT, ... );
   CHAR    *cmd_ptr     ( VOID );
   BOOLEAN  delimited   ( BOOLEAN inc_sep=FALSE );
   VOID     seperators  ( CHAR *useps = PP_seps )
                        { seps = ((useps == NULL) ? PP_seps : useps); }
};


/*------------------------------------------------------------------------*/
#endif


