/*   fnmatch.h : May 5, 1994   */

/* Copyright (C) 1994-1999  Sekhar Bala,
 *                          Ramchander Balasubramanian, and
 *                          Alphax Systems, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __FNMATCH_H
#define __FNMATCH_H


/*------------------------------------------------------------------------*/

/* test for undefine for derivations from other h-files */
#ifdef FNM_PATHNAME
#undef FNM_PATHNAME
#endif
#ifdef FNM_NOESCAPE
#undef FNM_NOESCAPE
#endif
#ifdef FNM_PERIOD
#undef FNM_PERIOD
#endif

/* Bits set in the FLAGS argument to `fnmatch'.  */
#define FNM_FILENAME      (1 << 0)       // No wildcard can ever match /
#define FNM_NOESCAPE      (1 << 1)       // Backslashes do not escape a char
#define FNM_PERIOD        (1 << 2)       // Leading . is matched explicitly
#define FNM_TRAILING_DIR  (1 << 3)       // Ignore /... after a match
#define FNM_CASEFOLD      (1 << 4)       // Compare without regard to case
#define FNM_DEFAULT       (FNM_FILENAME)

/* Values returned by `fnmatch' */
#define FNM_MATCH         0
#define FNM_NOMATCH       1

/*------------------------------------------------------------------------*/

/*------------------------------------------------------*
 |  Match STRING against the filename pattern PATTERN,  |
 |  returning zero if it matches, FNM_NOMATCH if not.   |
 *------------------------------------------------------*/

EXTERN INT_2  fnmatch   ( CHAR   *pattern,
                          CHAR   *string,
                          INT_2   flags=FNM_DEFAULT );

/*------------------------------------------------------------------------*/
#endif

