/*   ext2rst.cc : February 1, 1994    */

/* Copyright (C) 1994-1999  Sekhar Bala, Rama Bala, and
 *                          Alphax System, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <string.h>
#include <sys/stat.h>

#include "std.h"
#include "getopt.h"

/*-------------------------------------------------------------------------*/

STATIC CHAR        buffer[512]      = { 0, };

STATIC CHAR        dospath[128]     = { 0, };
STATIC CHAR        unixpath[128]    = { 0, };

STATIC FILE       *fplst            = NULL;
STATIC CHAR        fprec[5][128];

STATIC BOOLEAN     udebug           = FALSE;
STATIC BOOLEAN     uverbose         = FALSE;

/*-------------------------------------------------------------------------*/


STATIC CHAR *mkfname( int dos, char *fname )
{

   strcpy( buffer, ((dos) ? dospath : unixpath) );
   strcat( buffer, "/" );
   strcat( buffer, fname );
   return( buffer );

} /* mkfname */


STATIC int getrecord( void )
{
 int     i;
 int     len;
 int     idx;
 char   *ptr;

   /* clear */
   for( i=0; (i < 5); i++ )
      memset( fprec[i], 0, sizeof(fprec[0]) );

   /* test for eof */
   if ( feof(fplst) )
      return( TRUE );

   /* read the next record */
   fgets( buffer, sizeof(buffer), fplst );
   if ( feof(fplst) )
      return( TRUE );
   
   /* fixup record */
   len = strlen(buffer);
   if ( (buffer[len-1] == '\n') || (buffer[len-1] == '\r') )
      buffer[len-1] = 0;

   /* parse the record into arguments */
   i   = 0;
   ptr = buffer;
   while ( TRUE ) {
      if ( *ptr == 0 )
         break;
      while ( *ptr == ' ' )
         ptr++;
      idx = 0;
      while ( (*ptr != 0) && (*ptr != ' ') ) {
         fprec[i][idx++] = *ptr++;
      }
      i++;
   }

   /* done */
   return( FALSE );

} /* getrecord */


STATIC int cpyfile( long *fbytes, char *ifile, char *ofile )
{
 int     xch;
 long    flen;
 int     ret_val = FALSE;
 FILE   *ifp     = NULL;
 FILE   *ofp     = NULL;

   flen    = 0;
   *fbytes = 0;
   ifp     = fopen( ifile, "rb" );
   if ( ifp == NULL )
      goto x_err;
   ofp     = fopen( ofile, "wb" );
   if ( ofp == NULL )
      goto x_err;

   /* @@ should setvbuf on both files */

   xch  = fgetc(ifp);
   while ( !feof(ifp) ) {
      flen++;
      fputc( xch, ofp );
      xch = fgetc(ifp);
   }
   goto x_done;

x_err:

   ret_val = TRUE;
   printf("\nError: %s -> %s\n", ifile, ofile );

x_done:

   *fbytes = flen;
   if ( ifp != NULL )
      fclose( ifp );
   if ( ofp != NULL )
      fclose( ofp );
   return( ret_val );

} /* cpyfile */


STATIC int traverse( int *iseof, char *upath )
{
 STATIC char    fpath[512]          = { 0, };
 int            err                 = FALSE;
 long           fbytes              = 0;
 int            fpath_len;
 int            tlen;
 char          *dos_fname;

   if ( fpath[0] == 0 )
      strcpy( fpath, unixpath );
   fpath_len = strlen( fpath );
   if ( upath != NULL ) {
      strcat( fpath, "/" );
      strcat( fpath, upath );
      if ( !udebug )
         mkdir( fpath, (S_IRWXU|S_IRWXG) );
      if ( uverbose )
         printf( "mkdir %s\n", fpath );
   }

   *iseof = getrecord();
   while ( !*iseof ) {

      /* end recursion */
      if ( fprec[0][0] == 'E' )
         break;

      if ( fprec[0][0] == 'F' ) {

	      tlen = strlen( fpath );
         strcat( fpath, "/" );
         strcat( fpath, fprec[1] );
         dos_fname = mkfname( TRUE, fprec[2] );
         if ( uverbose )
            printf( "%12.12s -> %-40.40s", fprec[2], fpath );
         err = FALSE;
         if ( !udebug )
            err = cpyfile( &fbytes, dos_fname, fpath );
         if ( uverbose )
            printf( "(%6ld, %s)\n", fbytes, fprec[3] );
         fpath[tlen] = 0;
         if ( err )
            break;
	 
      } else if ( fprec[0][0] == 'B' ) {
	 
         err = traverse( iseof, fprec[1] );
         if ( err )
            break;
	 
      } else {
	      printf( "command not understood!\n" );
      }

      *iseof = getrecord();

   } /* endwhile */

   /* done */
   fpath[fpath_len] = 0;
   return( FALSE );

} /* traverse */


INT_2 usage( VOID )
{

   printf( "\n" );
   printf( "ext2rst [-dv] <dos-path> <unix-path>\n" );
   printf( "options are:\n" );
   printf( "  -d    - debug mode; just display do not execute\n" );
   printf( "  -v    - be verbose\n" );
   printf( "\n" );
   return( 1 );

} /* usage */


int main( int argc, char *argv[] )
{
 INT_2   retval;
 INT_2   len;
 CHAR   *arg;
 int     iseof = FALSE;

   printf( "\n              "
           "ext2RST V1.00 - Copyright (c) 1994-1999, Sekhar Bala,"
           "\n              "
           "                Ramchander Balasubramanian,"
           "\n              "
           "                and Alphax Systems, Inc."
           "\n              "
           "-----------------------------------------------------"
           "\n\n" );

   // setup args
   while (TRUE) {
      retval = getopt( argc, argv, "dv" );
      if ( retval == 'd' ) {
         udebug = TRUE;
         continue;
      }
      if ( retval == 'v' ) {
         uverbose = TRUE;
         continue;
      }
      if ( retval == -1 )
         break;
      if ( retval != '?' )
         printf( "Unknown option '%c'\n", (CHAR) retval );
      return(  usage()  );
   }

   // dos-path
   arg = argopt( argc, argv );
   if ( arg == NULL ) {
      printf( "Missing argument 'dos-path'\n" );
      return(  usage()  );
   }
   strcpy( dospath, arg );
   len = strlen( dospath );
   if ( dospath[len-1] == '/' )
      dospath[len-1] = 0;

   // unix-path
   arg = argopt( argc, argv );
   if ( arg == NULL ) {
      printf( "Missing argument 'unix-path'\n" );
      return(  usage()  );
   }
   strcpy( unixpath, arg );
   len = strlen( unixpath );
   if ( unixpath[len-1] == '/' )
      unixpath[len-1] = 0;

   fplst = fopen( mkfname(TRUE,"files.lst"), "r" );
   if ( fplst != NULL ) {
      traverse( &iseof, NULL );
      fclose( fplst );
   } else {
      printf( "cannot open files.lst\n" );
   }

   /* done */
   return( 0 );

} /* main */


/*-------------------------------------------------------------------------*/

