/*   ilib3.cc : February 1, 1994    */

/* Copyright (C) 1994-1999  Sekhar Bala, Rama Bala, and
 *                          Alphax System, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>

#include "std.h"

#include "diskio.h"
#include "ext2fs.h"

#include "ilib.h"

/*-------------------------------------------------------------------------*/


GLOBAL INT_2 find_links( INT_4 inode_num )
{
 INT_2 i;

   for( i=0; (i < links_len); i++ ) {
      if ( links[i].inode_num > inode_num )
         break;
      if ( links[i].inode_num == inode_num )
         return( i );
   }
   return( -1 );

} /* find_links */


GLOBAL VOID dump_links( INT_2 idx )
{
 INT_2        i;
 INT_2        cidx;
 LINKS_TYP   *plinks;

   plinks = &links[idx];
   outvfp( "Index %d ", idx );
   if ( plinks->pinode != NULL ) {
      if ( S_ISDIR(plinks->pinode->i_mode) )
         outvfp( "DIR");
      else
         outvfp( "???" );
   } else {
      outvfp( "BAD" );
   }
   outvfp( "\n" );
   outvfp( "         flags: 0x%04X\n",  plinks->flags );
   outvfp( "         inode: %ld\n",     plinks->inode_num );
   outvfp( "  parent_inode: %ld\n",     plinks->parent_inode );
   outvfp( "        parent: %d ",       plinks->parent );
   if ( plinks->parent != -1 ) {
      outvfp( "(inode=%ld)", links[ plinks->parent ].inode_num );
   } else {
      outvfp( "(inode=none)" );
   }
   outvfp( "\n");
   for( i=0; (i < plinks->child_len); i++ ) {
      cidx = (*plinks->child)[i];
      outvfp( "%2d) index %4d Inode %8ld\n",
              i, cidx,  links[cidx].inode_num );
   }
   return;

} /* dump_links */


GLOBAL BOOLEAN setup_links( VOID )
{
 INT_2    l_ret;
 INT_2    flags;
 INT_4    i;
 INT_4    tmp;
 INT_4    skip;
 BOOLEAN  dotest;

   dotest = TRUE;
   skip   = 0;
   for( i=2; (i < (INT_4) sb->s_inodes_count); i++ ) {

      // skip reserved (other than root)
      if ( (i > 2) && (i < 11) )
         continue;

      if ( !skip_bitblock ) {
         // bitblock freedom check
         tmp = (i - 1) / sb->s_inodes_per_group;
         if ( tmp != group_idx ) {
            dotest    = TRUE;
            group_idx = tmp;
            tmp       = groups[group_idx].bg_inode_bitmap ;
            if ( read_LIBIO(pbitblock, blocksize, blocksize*tmp) != 0 ) {
               outvfp( "Bitmap block %ld on inode %ld of group is in error\n",
                       tmp, i, group_idx );
               dotest = FALSE;
            }
         }
         if ( dotest ) {
            tmp = (i - 1) % sb->s_inodes_per_group;
            if ( test_BIT(tmp, pbitblock) == 0 ) {
               continue;
            }
         }
      }

      // read the inode
      flags = _FLG_CLEAR;
      l_ret = readinode_FS(i, &t_inode);
      // if inode==2 (root) make sure we read it in properly
      if ( i == 2 ) {
         while ( (l_ret != 0) || (!S_ISDIR(t_inode.i_mode)) ) {
            l_ret = readinode_FS(i, &t_inode);
            outvfp( "Looping on inode 2 ret=%d\n", l_ret );
         }
         clr_errhdl();
      }
      if ( l_ret != 0 ) {
         flags |= _FLG_BADINODE;
      } else {
         if ( !S_ISDIR(t_inode.i_mode) ) {
#if 1
            if ( (verbose) && (++skip == 100) ) {
               outvfp( "Inode %8ld ... skipping\n", i);
               skip = 0;
            }
#else
            outvfp( "Inode %8ld - is not a directory\n", i );
#endif
            continue;
         }
      }

      if ( verbose )
         outvfp( "Inode %8ld - proces%s ", i, ((dotest) ? "s " : "s*") );
      if ( (flags & _FLG_BADINODE) != 0 )
         outvfp( "Inode trouble at: %ld ", i );

      // load inode info
      links[links_len].flags     = flags;
      links[links_len].inode_num = i;
      links[links_len].pinode    = NULL;
      if ( flags == _FLG_CLEAR ) {
         if ( alloc_inode(&links[links_len].pinode) != 0 )
            return( FALSE );
         memcpy( links[links_len].pinode, &t_inode, sizeof(INODE_TYP) );
      }
      links[links_len].parent    = -1;
      links[links_len].child     = NULL;
      links[links_len].child_len = 0;
      links_len++;

      outvfp( "- as %d\n", links_len );

      // test for too many inodes
      if ( links_len == MAX_LINKS ) {
         outvfp( "OUT of links space!\n" );
         return( FALSE );
      }

   } /* end for */

   // done
   return( TRUE );

} /* setup_links */


GLOBAL BOOLEAN resolve_links( VOID )
{
 INT_2       i;
 INT_4       block_num;
 ENTRY_TYP  *pentry;
 CHAR       *ptr;
 INT_2       total;
 LINKS_TYP  *plinks;

   // for each valid inode, get parent idx
   for( i=0; (i < links_len); i++ ) {

      // validate pinode
      if ( (links[i].flags != _FLG_CLEAR) || (links[i].pinode == NULL) )
         continue;

      // init block reader
      if ( readblock_FS(links[i].pinode, NULL, NULL) != 0 ) {
         outvfp( "Bad block-def1 of Inode %ld\n", links[i].inode_num );
         links[i].flags |= _FLG_BADBLKDEF1;
         continue;
      }

      // get first block #
      if ( readblock_FS(links[i].pinode, &block_num, NULL) != 0 ) {
         outvfp( "Bad block-def2 of Inode %ld\n", links[i].inode_num );
         links[i].flags |= _FLG_BADBLKDEF2;
         continue;
      }

      // read the block as a dir
      if ( read_LIBIO(pblock, blocksize, blocksize*block_num) != 0 ) {
         outvfp( "Bad block-read %ld of Inode %ld\n",
                 block_num, links[i].inode_num );
         links[i].flags |= _FLG_BADBLOCK;
         continue;
      }

      // find the .. entry
      total = 0;
      ptr   = pblock;
      while ( TRUE ) {
         pentry = (ENTRY_TYP *) ptr;
         // test for invalidness
         if ( total >= blocksize ) {
            outvfp( "Dir Block %ld of Inode %ld has no dotdot\n",
                    block_num, links[i].inode_num );
            links[i].flags |= _FLG_NODOTBLOCK;
            break;
         }
         if (
              (pentry->rec_len <= 0)            ||
              (pentry->rec_len >= blocksize)    ||
              (pentry->name_len <= 0)           ||
              (pentry->name_len >= blocksize)   ||
              (pentry->name[0] == 0)
            ) {
            outvfp( "Dir Block %ld of Inode %ld is bad\n",
                    block_num, links[i].inode_num );
            links[i].flags |= _FLG_DATABLOCK;
            break;
         }
         // test for parent entry
         if ( (pentry->name[0] == '.') && (pentry->name[1] == '.') )
            break;
         // update for next go-around
         ptr    = &ptr[pentry->rec_len];
         total += pentry->rec_len;
      }

      // test for errors
      if ( (links[i].flags & (_FLG_DATABLOCK|_FLG_NODOTBLOCK)) != 0 )
         continue;

      // fill in parent
      links[i].parent_inode = pentry->inode_num;
      links[i].parent       = find_links( pentry->inode_num );
      if ( links[i].parent == -1 )
         continue;

      // fill in children
      plinks = &links[links[i].parent];
      if ( alloc_child((INT_2 *(**))&plinks->child,&plinks->child_len) != 0 )
         return( FALSE );
      (*plinks->child)[ plinks->child_len-1 ] = i;

   } /* endfor */

   // done
   return( TRUE );

} /* reslove_links */


/*-------------------------------------------------------------------------*/

