/*   ilib1.cc : February 1, 1994    */

/* Copyright (C) 1994-1999  Sekhar Bala, Rama Bala, and
 *                          Alphax System, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>

#include "std.h"

#include "diskio.h"
#include "ext2fs.h"

#include "ilib.h"

/*-------------------------------------------------------------------------*/


GLOBAL INT_2 alloc_inode( INODE_TYP **pinode )
{

   free_inode( pinode );
   (*pinode) = (INODE_TYP *) ::malloc( sizeof(INODE_TYP) );
   if ( (*pinode) == NULL )
      return( set_errhdl(ERR_SYS_NOMEM) );
   memset( (*pinode), 0, sizeof(INODE_TYP) );
   return( 0 );

} /* alloc_inode */


GLOBAL VOID free_inode( INODE_TYP **pinode )
{

   if ( (*pinode) != NULL )
      ::free( (*pinode) );
   *pinode = NULL;
   return;

} /* free_inode */


GLOBAL INT_2 alloc_child( INT_2 *(**uchild), INT_2 *uchild_len )
{
 int   tsize;

   tsize = sizeof(INT_2) * ( (*uchild_len)+1 );
   if ( (*uchild_len) == 0 ) {
      (*uchild) = (INT_2 (**)) ::malloc( tsize );
   } else {
      (*uchild) = (INT_2 (**)) ::realloc( (*uchild), tsize );
   }
   if ( (*uchild) == NULL )
      return( set_errhdl(ERR_SYS_NOMEM) );
   (*(*(INT_2 (**)[]) uchild))[*uchild_len] = -1;
   (*uchild_len)++;
   return( 0 );

} /* alloc_child */


GLOBAL VOID free_child( INT_2 *(**uchild), INT_2 *uchild_len )
{

   if ( (*uchild) != NULL )
      ::free( (*uchild) );
   (*uchild)     = NULL;
   (*uchild_len) = 0;
   return;

} /* free_child */


/*-------------------------------------------------------------------------*/

