/*   ilib0.cc : February 1, 1994    */

/* Copyright (C) 1994-1999  Sekhar Bala, Rama Bala, and
 *                          Alphax System, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>

#include "std.h"

#include "diskio.h"
#include "ext2fs.h"

#include "ilib.h"

/*-------------------------------------------------------------------------*/

GLOBAL INT_2         links_len         = 0;
GLOBAL LINKS_TYP     links[MAX_LINKS]  = { { 0, }, };

GLOBAL INODE_TYP     t_inode           = { 0, };
GLOBAL INT_2         blocksize         = 0;
GLOBAL CHAR         *pblock            = NULL;

GLOBAL BOOLEAN       skip_bitblock     = FALSE;
GLOBAL INT_4         group_idx         = -1;
GLOBAL CHAR         *pbitblock         = NULL;

GLOBAL BOOLEAN       verbose           = FALSE;
GLOBAL FILE         *log               = NULL;
GLOBAL CHAR          fname[80]         = { "inode.dat" };

/*-------------------------------------------------------------------------*/


GLOBAL VOID outvfp( CHAR *fmt, ... )
{
 CHAR     xbuf[256];
 FILE    *vfp;
 va_list  arg;

   vfp = log;
   if ( vfp == NULL )
      vfp = stdout;
   va_start( arg, fmt );
   vsprintf( xbuf, fmt, arg );
   fprintf( vfp, xbuf );
   va_end( arg );
   return;

} /* outvfp */


GLOBAL VOID outf( CHAR *fmt, ... )
{
 CHAR     xbuf[256];
 va_list  arg;

   if ( log == NULL )
      return;
   va_start( arg, fmt );
   vsprintf( xbuf, fmt, arg );
   fprintf( log, xbuf );
   va_end( arg );
   return;

} /* outf */


GLOBAL BOOLEAN set_BIT( INT_4 nr, VOID *addr )
{
 BOOLEAN    retval;
 INT_4      mask;
 INT_4     *ADDR     = (INT_4 *) addr;

   ADDR  += (nr >> 5);                          // addr = addr[ (nr/16) ]
   mask   = 1 << (nr & 0x1F);                   // mask = 1 << (nr % 16)
   retval = (BOOLEAN) ((mask & *ADDR) != 0);    // retval = was it set or not
   *ADDR |= mask;
   return( retval );

} /* set_BIT */


GLOBAL BOOLEAN clear_BIT( INT_4 nr, VOID *addr )
{
 BOOLEAN    retval;
 INT_4      mask;
 INT_4     *ADDR     = (INT_4 *) addr;

   ADDR   += (nr >> 5);
   mask    = 1 << (nr & 0x1F);
   retval  = (BOOLEAN) ((mask & *ADDR) != 0);
   *ADDR  &= ~mask;
   return( retval );

} /* clear_BIT */


GLOBAL BOOLEAN test_BIT( INT_4 nr, VOID *addr )
{
 BOOLEAN    retval;
 INT_4      mask;
 INT_4     *ADDR     = (INT_4 *) addr;

   ADDR  += (nr >> 5);
   mask   = 1 << (nr & 0x1F);
   retval = (BOOLEAN) ((mask & *ADDR) != 0);
   return( retval );

} /* test_BIT */


/*-------------------------------------------------------------------------*/

