/*   libio.h : February 1, 1994    */

/* Copyright (C) 1994-1999  Sekhar Bala, Rama Bala, and
 *                          Alphax System, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __LIBIO_H
#define __LIBIO_H

/*------------------------------------------------------------------------*/

/* enhanced err numbers */

#define ERR_SYS_NOINIT     1005
#define ERR_SYS_BADINO     1005
#define ERR_SYS_INOLEN     1006
#define ERR_SYS_FILE       1007
#define ERR_IO_FS          8001
#define ERR_IO_PART        8002
#define ERR_IO_EXTPART     8003
#define ERR_IO_NOPART      8004
#define ERR_IO_MAXPART     8005
#define ERR_IO_BLKINIT     8006
#define ERR_IO_NOTDIR      8007
#define ERR_IO_SLINK       8008
#define ERR_IO_BADWRITE    8009
#define ERR_IO_DATA        8010
#define ERR_IO_SEEK        8011
#define ERR_IO_RDONLY      8012

/*------------------------------------------------------------------------*/

/* Disk Numbers */
#define DISK_A             0   /* floppy disk a    */
#define DISK_B             1   /* floppy disk b    */
#define DISK_1           128   /* first hard disk  */
#define DISK_2           129   /* second hard disk */
#define DISK_3           130   /* third hard disk  */
#define DISK_4           131   /* fourth hard disk */

/* Partition Related */
#define MAX_PARTITIONS       16

#define PART_INVALID       0x00
#define PART_EXTENDED      0x05
#define PART_MSDOS         0x06
#define PART_LINUXSWAP     0x82
#define PART_EXT2          0x83
#define PART_WIN95SWAP     0x84

#define PARTF_ACTIVE       0x01

typedef struct partition_typ {
   INT_U2               flags;
   INT_U4               start;
   INT_U4               length;
   INT_U2               type;
} PARTITION_TYP;

#define MAX_RETRIES              6

EXTERN BOOLEAN          g_verbose_libio;
EXTERN INT_2            g_retry;

#if !defined(GO32)
EXTERN BOOLEAN          g_readonly;
EXTERN CHAR             g_devname[20];
EXTERN int              g_dev;
#endif

EXTERN INT_U2           g_disk;
EXTERN INT_U2           g_heads;
EXTERN INT_U2           g_sectors;
EXTERN INT_U2           g_cylinders;

EXTERN INT_2            g_p_idx;
EXTERN INT_2            g_p_len;
EXTERN PARTITION_TYP    g_p[MAX_PARTITIONS];

/*------------------------------------------------------------------------*/
                                 /* libio.c */

EXTERN INT_2  init_LIBIO     ( INT_U2 disk );
EXTERN VOID   clean_LIBIO    ( VOID );

EXTERN INT_2  readbios_LIBIO ( INT_U4 sector, INT_U2 nsectors, VOID *pbuf );
EXTERN INT_2  writebios_LIBIO( INT_U4 sector, INT_U2 nsectors, VOID *pbuf );

EXTERN INT_2  read_LIBIO     ( VOID *upbuf, INT_4 upbuf_len, INT_U4 sector );
EXTERN INT_2  write_LIBIO    ( VOID *upbuf, INT_4 upbuf_len, INT_U4 sector );

/*------------------------------------------------------------------------*/
#endif


