/* keycodes.c -- utility program for the libkb keyboard library
 * Copyright (C) 1995-1998 Markus F.X.J. Oberhumer
 * For conditions of distribution and use, see copyright notice in kb.h
 */


#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <kb.h>
#include "intro.h"


int opt_show_number = 0;


/***********************************************************************
// examine which keycodes are produced by which keys
************************************************************************/

static int try_key(unsigned code, unsigned scan, unsigned shift, int *found)
{
	unsigned key = scan | (shift << 8);

	if (code != kb_keycode(key))
		return 0;

	(*found)++;
	if (opt_show_number)
		printf("  0x%04x ",key);
	else
	{
		printf("   ");
		if (KB_ANY_MASK(shift,KB_SHIFT_ANY_SHIFT))
			printf("S-");
		if (KB_ANY_MASK(shift,KB_SHIFT_ANY_CONTROL))
			printf("C-");
		if (KB_ANY_MASK(shift,KB_SHIFT_ANY_ALT))
			printf("A-");
		printf("%s",kb_keyname(key));
	}
	return 1;
}


static int find_code(unsigned code)
{
	unsigned scan;
	int found = 0;

	if (code >= 32 && code < 127)
		printf("'%c'",(char) code);
	else
		printf("   ");
	printf("  %3d  0x%03x:",code,code);

	for (scan = 0; scan < 128; scan++)
	{
		/* try all keycode tables */
		try_key(code, scan, 0, &found);
		try_key(code, scan, KB_SHIFT_LSHIFT, &found);
		try_key(code, scan, KB_SHIFT_LCONTROL, &found);
		try_key(code, scan, KB_SHIFT_ALT, &found);
	}

	printf("\n");
	return found;
}


/***********************************************************************
//
************************************************************************/

int main(int argc, char *argv[])
{
	int i;
	int codes = 0, keys = 0;
	char s[160+1];

	for (i = 1; i < argc && argv[i][0] == '-'; i++)
	{
		if (argv[i][1] == 'n')
			opt_show_number = 1;
	}

	fputs("\n",stdout);
	fputs(_kb_intro_text(s),stdout);
	fputs("\n\n",stdout);

	kb_init();		/* init tables but don't install keyboard handler */

	/* find all codes */
	for (i = 1; i < 0x300; i++)
	{
		int x = find_code(i);
		if (x > 0)
		{
			codes++;
			keys += x;
		}
	}

	printf("\n%d codes are generated by %d key combinations\n", codes, keys);
	return 0;
}


/*
vi:ts=4
*/
