#include <stdio.h>
#include <unistd.h>
#include <ctype.h>
#include <locale.h>
#include <keyb.h>

extern int __tty_fd;
extern unsigned char ledflagstate;

int main()
{
  unsigned char s, k;
  keyb_key_t key;
  int down;

  setlocale(LC_ALL, "");
  
  if(keyb_init() != 0)
  {
	fprintf(stderr, "Can`t keyb_init()\n");
	exit(1);
  };
  
  keyb_unload();

  while(1)
  {
	if(read(__tty_fd, &s, 1))
	{
	  if(keyb_translate(s, &k, &down))
	  {
		keyb_handle(k, down);
		keyb_process(k, down);
		if(keyb_translatekey(k, down, &key))
		{
		  if(down)
		  {
			switch(KTYP(key))
			{
			 case KT_LATIN:
			  if(isprint(KVAL(key)))
			  {
				printf("'%c' (0x%04x, 0x%02x)\n", KVAL(key), KSHIFT(key), 
					   ledflagstate);
			  }
			  else
			  {
				printf("0x%02x (0x%04x)\n", KVAL(key), KSHIFT(key));
			  };
			  if(KVAL(key) == '\033')
			  {
				keyb_close();
				exit(0);
			  };
			  break;
			 case KT_CUR:
			  switch(key & 0xffff)
			  {
			   case K_DOWN:
				printf("Down ");
				break;
			   case K_UP:
				printf("Up ");
				break;
			   case K_LEFT:
				printf("Left ");
				break;
			   case K_RIGHT:
				printf("Right ");
				break;
			   default:
				printf("Unknown ");
				break;
			  };
			  printf("(0x%04x)\n", KSHIFT(key));
			  break;
			 default:
			  if(KTYP(key) != KT_SHIFT)
				printf("%i %i (0x%04x)\n", KVAL(key), KTYP(key), KSHIFT(key));
			  break;
			};
		  };
		};
	  };
	};
  };

  keyb_close();

  return 0;
};
