#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <linux/kd.h>
#include <linux/vt.h>
#include <ctype.h>

#include "keyb.h"
#include "keyb_internal.h"

void keyb_setconsole(int no)
{
  struct vt_stat vts;
  ioctl(__tty_fd, VT_GETSTATE, &vts);
  if(no + 1 != vts.v_active)
  {
	ioctl(__tty_fd, VT_ACTIVATE, no + 1);
  };
};

void keyb_unload()
{
  int i, j;
  struct kbentry ke;
  unsigned short *map;

  for (j = 0; j < MAX_NR_KEYMAPS; j++)
  {
	ke.kb_index = 0;
	ke.kb_table = j;
	i = ioctl(__tty_fd, KDGKBENT, (unsigned long)&ke);
	if(!i && ke.kb_value != K(KT_SPEC,127))
	{
	  map =	(unsigned short *)calloc(sizeof(unsigned short), NR_KEYS);
	  if(!map)    /* and what to do now? */
	  {
#ifdef DEBUG
		fprintf(stderr, "Can`t calloc() %i bytes\n",
				sizeof(unsigned short) * NR_KEYS);
#endif    /* DEBUG */
		return;
	  };
	  key_maps[j] = map;
	  for(i = 0; i < NR_KEYS; i++)
	  {
		ke.kb_index = i;
		ke.kb_table = j;
		ioctl(__tty_fd, KDGKBENT, (unsigned long)&ke);
		map[i] = ke.kb_value + (0xf0 << 8);   /* can anybody tell me why?! */
	  };
	};
  }
};

int keyb_update(keyb_key_t *key, int *down)
{
  unsigned char s, k;

  if(read(__tty_fd, &s, 1))
  {
	if(keyb_translate(s, &k, down))
	{
	  keyb_handle(k, *down);
	  keyb_process(k, *down);
	  if(keyb_translatekey(k, *down, key))
	  {
		if(*down || opts.show_release)
		{
		  return 1;
		};
	  };
	};
  };
  return 0;
};

keyb_options_t *keyb_getoptions()
{
  return &opts;
};

int keyb_getfd()
{
  return __tty_fd;
};

keyb_key_t keyb_getshiftstate()
{
  return (shift_state << 16);
};

int vc_kbd_led(int flag)
{
  return ((ledflagstate >> flag) & 1);
}

void clr_vc_kbd_led(int flag)
{
  ledflagstate &= ~(1 << flag);
}

void set_vc_kbd_led(int flag)
{
  ledflagstate |= 1 << flag;
}

void chg_vc_kbd_led(int flag)
{
  ledflagstate ^= 1 << flag;
}

void chg_vc_kbd_lock(int flag)
{
  lockstate ^= 1 << flag;
}

void chg_vc_kbd_slock(int flag)
{
  slockstate ^= 1 << flag;
}

int set_bit(int nr, unsigned int *addr)
{
  int     mask, retval;

  addr += nr >> 5;
  mask = 1 << (nr & 0x1f);
  retval = (mask & *addr) != 0;
  *addr |= mask;
  return retval;
}

int clear_bit(int nr, unsigned int *addr)
{
  int     mask, retval;

  addr += nr >> 5;
  mask = 1 << (nr & 0x1f);
  retval = (mask & *addr) != 0;
  *addr &= ~mask;
  return retval;
}

int test_bit(int nr, unsigned int *addr)
{
  int     mask;

  addr += nr >> 5;
  mask = 1 << (nr & 0x1f);
  return ((mask & *addr) != 0);
}
