#include <unistd.h>

#include "keyb.h"
#include "keyb_internal.h"

unsigned char lockstate = 0;
unsigned char slockstate = 0;

unsigned char ledflagstate = 0;

/* shift state counters.. */
unsigned char k_down[NR_SHIFT] =
{
  0,
};

/* keyboard key bitmap */
unsigned int key_down[256/32] =   /* 256/BITS_PER_LONG */
{
  0,
};

int shift_state = 0;
static char rep = 0;			/* flag telling character repeat */

typedef void (*k_hand)(unsigned char value, char up_flag);
typedef void (k_handfn)(unsigned char value, char up_flag);

static k_handfn
  do_shift, do_lock, do_slock, do_ignore, do_spec;

static k_hand key_handler[16] =
{
  do_ignore,	/* KT_LATIN */
	do_ignore,	/* KT_FN */
	do_spec,	/* KT_SPEC */
	do_ignore,	/* KT_PAD */
	do_ignore,	/* KT_DEAD */
	do_ignore,	/* KT_CONS */
	do_ignore,	/* KT_CUR */
	do_shift,	/* KT_SHIFT */
	do_ignore,	/* KT_META */
	do_ignore,	/* KT_ASCII */
	do_lock,	/* KT_LOCK */
	do_ignore,	/* KT_LETTER */
	do_slock,	/* KT_SLOCK */
	do_ignore,	/* ??? */
	do_ignore,	/* ??? */
	do_ignore	/* ??? */
};

void keyb_handle(unsigned char keycode, int down)
{
  char up_flag = down ? 0 : 0200;

  unsigned short keysym;
  unsigned char type;

  int shift_final = shift_state ^ lockstate ^ slockstate;
  unsigned short *key_map = key_maps[shift_final];

  if (up_flag)
  {
	rep = 0;
	test_and_clear_bit(keycode, key_down);
  }
  else
	rep = test_and_set_bit(keycode, key_down);

  if (key_map != NULL)
  {
	keysym = key_map[keycode];
	type = KTYP(keysym);

	if (type >= 0xf0)
	{
	  type -= 0xf0;
	  (*key_handler[type])(keysym & 0xff, up_flag);
	  if (type != KT_SLOCK)
		slockstate = 0;
	};
  };
};

static void do_ignore(unsigned char value, char up_flag)
{
};

static void do_shift(unsigned char value, char up_flag)
{
  if (rep)
	return;

  if (value == KVAL(K_CAPSSHIFT))
  {
	value = KVAL(K_SHIFT);
	if (!up_flag)
	  clr_vc_kbd_led(VC_CAPSLOCK);
  }

  if (up_flag)
  {
	/* handle the case that two shift or control
	 keys are depressed simultaneously */
	if (k_down[value])
	  k_down[value]--;
  }
  else
	k_down[value]++;

  if (k_down[value])
	shift_state |= (1 << value);
  else
	shift_state &= ~ (1 << value);

};

static void do_spec(unsigned char value, char up_flag)
{
  if(rep || up_flag)
	return;
  switch(value)
  {
   case KVAL(K_CAPS):
	chg_vc_kbd_led(VC_CAPSLOCK);
	break;
   case KVAL(K_CAPSON):
	set_vc_kbd_led(VC_CAPSLOCK);
	break;
   case KVAL(K_NUM):
   case KVAL(K_BARENUMLOCK):
	chg_vc_kbd_led(VC_NUMLOCK);
	break;
  };
};

static void do_lock(unsigned char value, char up_flag)
{
  if (up_flag || rep)
	return;
  chg_vc_kbd_lock(value);
};

static void do_slock(unsigned char value, char up_flag)
{
  if (up_flag || rep)
	return;
  chg_vc_kbd_slock(value);
};
