#include <unistd.h>

#include "keyb.h"
#include "keyb_internal.h"

typedef void (*k_proc)(unsigned char value, char up_flag);
typedef void (k_procfn)(unsigned char value, char up_flag);

static k_procfn
  proc_cons, proc_ignore;

static k_proc key_process[16] =
{
  proc_ignore,		/* KT_LATIN */
	proc_ignore,	/* KT_FN */
	proc_ignore,	/* KT_SPEC */
	proc_ignore,	/* KT_PAD */
	proc_ignore,	/* KT_DEAD */
	proc_cons,		/* KT_CONS */
	proc_ignore,	/* KT_CUR */
	proc_ignore,	/* KT_SHIFT */
	proc_ignore,	/* KT_META */
	proc_ignore,	/* KT_ASCII */
	proc_ignore,	/* KT_LOCK */
	proc_ignore,	/* KT_LETTER */
	proc_ignore,	/* KT_SLOCK */
	proc_ignore,	/* ??? */
	proc_ignore,	/* ??? */
	proc_ignore		/* ??? */
};

void keyb_process(unsigned char keycode, int down)
{
  char up_flag = down ? 0 : 0200;

  unsigned short keysym;
  unsigned char type;

  int shift_final = shift_state ^ lockstate ^ slockstate;
  unsigned short *key_map = key_maps[shift_final];

  if (key_map != NULL)
  {
	keysym = key_map[keycode];
	type = KTYP(keysym);

	if (type >= 0xf0)
	{
	  type -= 0xf0;
	  (*key_process[type])(keysym & 0xff, up_flag);
	}
  }
}

static void proc_ignore(unsigned char value, char up_flag)
{
}

static void proc_cons(unsigned char value, char up_flag)
{
  if(up_flag)
	return;
  keyb_setconsole(value);
}
