#ifndef _KEYB_INTERNAL_H
# define _KEYB_INTERNAL_H

extern keyb_options_t opts;

extern int __tty_fd;

extern void keyb_setconsole(int no);

# define NR_SHIFT        9

extern unsigned char k_down[NR_SHIFT];
extern unsigned int key_down[256/32];   /* 256/BITS_PER_LONG */

# define NR_KEYS         128
# define MAX_NR_KEYMAPS  256

extern unsigned short *key_maps[MAX_NR_KEYMAPS];
extern unsigned short plain_map[NR_KEYS];

# define VC_SCROLLOCK    0       /* scroll-lock mode */
# define VC_NUMLOCK      1       /* numeric lock mode */
# define VC_CAPSLOCK     2       /* capslock mode */

extern int shift_state;

extern unsigned char lockstate;
extern unsigned char slockstate;
extern unsigned char ledflagstate;

extern __inline__ int vc_kbd_led(int flag)
{
  return ((ledflagstate >> flag) & 1);
}

extern __inline__ void clr_vc_kbd_led(int flag)
{
  ledflagstate &= ~(1 << flag);
}

extern __inline__ void set_vc_kbd_led(int flag)
{
  ledflagstate |= 1 << flag;
}

extern __inline__ void chg_vc_kbd_led(int flag)
{
  ledflagstate ^= 1 << flag;
}

extern __inline__ void chg_vc_kbd_lock(int flag)
{
  lockstate ^= 1 << flag;
}

extern __inline__ void chg_vc_kbd_slock(int flag)
{
  slockstate ^= 1 << flag;
}

extern __inline__ int set_bit(int nr, unsigned int *addr)
{
  int     mask, retval;

  addr += nr >> 5;
  mask = 1 << (nr & 0x1f);
  retval = (mask & *addr) != 0;
  *addr |= mask;
  return retval;
}

extern __inline__ int clear_bit(int nr, unsigned int *addr)
{
  int     mask, retval;

  addr += nr >> 5;
  mask = 1 << (nr & 0x1f);
  retval = (mask & *addr) != 0;
  *addr &= ~mask;
  return retval;
}

extern __inline__ int test_bit(int nr, unsigned int *addr)
{
  int     mask;

  addr += nr >> 5;
  mask = 1 << (nr & 0x1f);
  return ((mask & *addr) != 0);
}

# define test_and_set_bit(a, b) set_bit(a, b)
# define test_and_clear_bit(a, b) clear_bit(a, b)

#endif    /* _KEYB_INTERNAL_H */
