/*
 * time.c --
 *
 *      Implements support timer functions.
 *
 * Copyright (C) 1995, 1996 Daniel Wu.
 * Distributed under the terms of the GNU Library General Public
 * License.
 *
 * This file is part of SimTos.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation (version 2).
 *
 * This library is distributed "AS IS" in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with Pthreads; see the file COPYING.  If not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA
 * 02139, USA.
 *
 * Author: Daniel Wu (dwu@linus.socs.uts.edu.au)
 *
 */


#include <math.h>
#include <sys/time.h>
#include "mtosux.h"

static struct timeval system_start_time;


void init_timers(void)
{
    gettimeofday(&system_start_time, NULL);
}

long getime(imst_t* msbuf)
{

    struct timeval curtime;    
    double ms;
    
    if (msbuf == NULL)
       return BADPRM;

    gettimeofday(&curtime, NULL);    
    curtime.tv_sec -= system_start_time.tv_sec;
    curtime.tv_usec -= system_start_time.tv_usec;

    ms = (((double)curtime.tv_usec)/1000.0) + ((double)curtime.tv_sec)*1000.0;    
    msbuf->upper = (ULONG) (ms/pow(2,32));
    msbuf->lower = (ULONG) ((ms/pow(2,32) - (double)msbuf->upper) * pow(2,32));

/*    printf("upper = %d, lower = %ld\n",msbuf->upper,msbuf->lower);*/
    
    return NOERR;
}

