/*
 * task.c --
 *
 *      Hedaer file for task control services.
 *
 * Copyright (C) 1995, 1996 Daniel Wu.
 * Distributed under the terms of the GNU Library General Public
 * License.
 *
 * This file is part of SimTos.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation (version 2).
 *
 * This library is distributed "AS IS" in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with Pthreads; see the file COPYING.  If not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA
 * 02139, USA.
 *
 * Author: Daniel Wu (dwu@linus.socs.uts.edu.au)
 *
 */

#ifndef _TASK_H
#define _TASK_H

#include <pthread.h>
#include "mtosux.h"
#include "efg.h"
#include "syscfg.h"
#include "os_timer.h"
#include "symtab.h"

typedef struct {
        sym_t             symtype;    
	pthread_t         lwp_pcb;
        pthread_cond_t    pcond;
        pthread_mutex_t   pmutex;        
	struct tcd*       mtos_tcd;
        OS_EVT_FLAG_TYPE  efgs;
} OS_TSK_TYPE;

long os_pause(pthread_cond_t* cond, pthread_mutex_t* mutex, qual_t interval);

#endif
