/*
 * symtab.h --
 *
 *      Header file for symbol table implementation.
 *
 * Copyright (C) 1995, 1996 Daniel Wu.
 * Distributed under the terms of the GNU Library General Public
 * License.
 *
 * This file is part of SimTos.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation (version 2).
 *
 * This library is distributed "AS IS" in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with Pthreads; see the file COPYING.  If not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA
 * 02139, USA.
 *
 * Author: Daniel Wu (dwu@linus.socs.uts.edu.au)
 *
 */


#ifndef _SYMTAB_H
#define _SYMTAB_H

#include <pthread.h>
#include "mtosux.h"
#include "syscfg.h"

#define MAX_SYMBOLS    512
#define SYM_COUNT_BASE 16

typedef enum sym_t_tag {
    sym_task,
    sym_efg,
    sym_sem,
    sym_msb,
    sym_mbx
} sym_t;

typedef struct sym_tab_t {
    key_t           key;
    void*           sym;
    pthread_mutex_t sym_lock;    
} OS_SYM_TAB_TYPE;

void   init_symtab(void);
uxid_t add_sym(key_t key, void* sym);
long   delete_sym(uxid_t key);

void   lock_sym(uxid_t id);
void   release_sym(uxid_t id);

void*  id2sym(uxid_t id);
void*  key2sym(key_t key);
uxid_t key2id(key_t key);
key_t  id2key(uxid_t id);

int get_symtab_base();
int get_symtab_size();

#endif
