/*
 * prique.h --
 *
 *      Header file for priority queue services.
 *
 * Copyright (C) 1995, 1996 Daniel Wu.
 * Distributed under the terms of the GNU Library General Public
 * License.
 *
 * This file is part of SimTos.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation (version 2).
 *
 * This library is distributed "AS IS" in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with Pthreads; see the file COPYING.  If not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA
 * 02139, USA.
 *
 * Author: Daniel Wu (dwu@linus.socs.uts.edu.au)
 *
 */


#ifndef _PRIQUE_H
#define _PRIQUE_H

typedef struct pri {
	void*       entry;
        int         length;
        int         priority;
	struct pri *pred, *succ;
} OS_PRIENTRY;

OS_PRIENTRY *PriDeleteMax(OS_PRIENTRY** priqueue);
void         PriInsert(OS_PRIENTRY** priqueue, OS_PRIENTRY *x);

#endif
