/*
 * prique.c --
 *
 *      Implements a priority queue.
 *
 * Copyright (C) 1995, 1996 Daniel Wu.
 * Distributed under the terms of the GNU Library General Public
 * License.
 *
 * This file is part of SimTos.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation (version 2).
 *
 * This library is distributed "AS IS" in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with Pthreads; see the file COPYING.  If not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA
 * 02139, USA.
 *
 * Author: Daniel Wu (dwu@linus.socs.uts.edu.au)
 *
 */


#include <stdio.h>
#include "prique.h"

/*
 * PriDeleteMax - this function returns the minimum element of the
 * priority queue priqueue. It returns NULL if the queue is empty.
*/
OS_PRIENTRY *PriDeleteMax(OS_PRIENTRY** priqueue)
{

   OS_PRIENTRY *p = *priqueue;

   if (p != NULL)
   {
     if ( p->succ == p )
       *priqueue = NULL;              /* queue has only one element   */
     else
     {
       *priqueue = (*priqueue)->succ;
       (*priqueue)->pred = p->pred;
       p->pred->succ = (*priqueue);
     }
     p->pred = p->succ = p;          /* detach itself from the queue */
   }
   return (p);

} /* PriDeleteMax */


/*
 * PriInsert - inserts the priority entry into the queue priqueue
 * in priority order. It requires the pointer to the entry to be
 * inserted as the argument.
*/
void PriInsert(OS_PRIENTRY** priqueue, OS_PRIENTRY *x)
{

   OS_PRIENTRY *p = *priqueue;

   if (p == NULL)
      *priqueue = x;
   else
   {
      while (x->priority <= p->priority)
      {
	 p = p->succ;
	 if (p == *priqueue)
	     break;
      }
      x->succ = p->pred->succ;
      x->pred = p->pred;
      p->pred->succ = x;
      x->succ->pred = x;
      if ( (p == *priqueue) && (p->priority < x->priority) )
	 *priqueue = p->pred;
   }

} /* PriInsert */

