/*
 * os_mtosux.h --
 *
 *      Header file for support functions.
 *
 * Copyright (C) 1995, 1996 Daniel Wu.
 * Distributed under the terms of the GNU Library General Public
 * License.
 *
 * This file is part of SimTos.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation (version 2).
 *
 * This library is distributed "AS IS" in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with Pthreads; see the file COPYING.  If not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA
 * 02139, USA.
 *
 * Author: Daniel Wu (dwu@linus.socs.uts.edu.au)
 *
 */

#ifndef __OS_MTOSUX_H
#define __OS_MTOSUX_H

#define PBASIS(pty)	(pty & 0x00000300l)
#define PVALUE(pty)	(pty & 0x000000ffl)

#define CBASIS(qual)	(qual & 0x00020000l)
#define CMODE(qual)	(qual & 0x0001f800l)
#define LUNITS(qual)	(qual & 0x00000700l)
#define LNUM(qual) 	(qual & 0x000000ffl)

/* Message buffer size must fall between these two value */
#define MIN_SIZE        1
#define MAX_SIZE        8191

/* MTOS parameter macros */
#define GLS(attr)       (attr & 0xffff0000l)
#define NUMMSB(attr)    (attr & 0x00001fffl)
#define INTERVAL(qual)  (qual & 0x000003ffl)

#define LUNITS(qual)    (qual & 0x00000700l)
#define LNUM(qual)      (qual & 0x000000ffl)

#ifndef FALSE
#define FALSE     0
#endif
#ifndef TRUE
#define TRUE      !FALSE
#endif

typedef  unsigned char byte;
typedef  unsigned char bool;
    
#endif
