/*
 * mtosux.h --
 *
 *      Header file for the MTOS-UX simulator based on the 
 *      distributed header with the same name.
 *
 * Copyright (C) 1995, 1996 Daniel Wu.
 * Distributed under the terms of the GNU Library General Public
 * License.
 *
 * This file is part of SimTos.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation (version 2).
 *
 * This library is distributed "AS IS" in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with Pthreads; see the file COPYING.  If not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA
 * 02139, USA.
 *
 * Author: Daniel Wu (dwu@linus.socs.uts.edu.au)
 *
 */

#ifndef _MTOSUX_H
#define _MTOSUX_H

/********************************************
 *                                          *
 * Type definitions                         *
 *                                          *
 *******************************************/

typedef long          uxid_t;
typedef unsigned long key_t;
typedef unsigned long qual_t;


typedef char          BYTE;
typedef unsigned char UBYTE;
typedef long          LONG;
typedef unsigned long ULONG;
typedef unsigned long UWORD;
typedef void*         UPTR;
typedef void 	      (* tep_t)(UPTR);


struct tcd {
	key_t		key;
	UBYTE		attr;
	BYTE		lclgbl;
	UBYTE		lang;
	UBYTE		ipr;
	UWORD		copr;
	tep_t		ep;
	ULONG		stklen;
	ULONG		udalen;
	UPTR		ida;
	UWORD		apct;
	BYTE		apci;
	UBYTE		apcl;
	char 	       *pgmfil;
};
    
typedef struct imst_t {
	UWORD	upper;
	ULONG	lower;
} imst_t;


/********************************************
 *                                          *
 * Constant Definitions                     *
 *                                          *
 *******************************************/

/*  SVC Status Values  */
 
#define NOERR 0		
 			
#define DUPTSK 1	
#define DUPPUN 2	
#define NOTDMT 3	
#define NOTFRE 4	
#define NOTOUT 5	
#define TIMCAN 6	
#define UNXEOT 7	
#define MBDLT  8	
#define MBEOF  9	
#define NOTSGI 10	
 			
#define BADPRM -1	
#define QUEFUL -2	
#define BADFUL -3	
#define TIMOUT -4	
#define NOTAVL -5	
#define NOTSUP -6	
#define DLTPND -7	
#define ATMAXI -8	
#define RSVERR -9	
#define PHYFLR -10	
#define BADATT -11	
#define BADKEY -12	
#define BADLNG -13	
#define BADPRC -14	
#define BADSTL -15	
#define BADTIM -16	
#define NEEDFN -17	
#define NOTOPN -18	
#define NOFILE -19	
#define UNIXFL -20	
#define MAGICN -21	
#define NRELOC -22	
#define BADFMT -23
#define NOULDR -24
#define EXPOOL -25
#define PIOCAN -26
#define PWFCAN -27	

/*  Coordination Modes [qual]  */
 
#define WAIFIN ((qual_t) 0x00000)
#define CTUNOC ((qual_t) 0x08000)

/*  Change Priority Basis  */
 
#define ADDVAL ((ULONG) 1)
#define USEVAL ((ULONG) 0)

/*  Event Flag Values  */
 
#define EFAND  (0UL)
#define EFOR   (0x10000UL)
#define EFRST  (0UL)
#define EFSET  (0x10000UL)
#define BIT(x) (1<<x)
 
#define EF0    BIT(15)
#define EF1    BIT(14)
#define EF2    BIT(13)
#define EF3    BIT(12)
#define EF4    BIT(11)
#define EF5    BIT(10)
#define EF6    BIT(9)
#define EF7    BIT(8)
#define EF8    BIT(7)
#define EF9    BIT(6)
#define EF10   BIT(5)
#define EF11   BIT(4)
#define EF12   BIT(3)
#define EF13   BIT(2)
#define EF14   BIT(1)
#define EF15   BIT(0)
#define EFALL  0xFFFF	/* all flags */

/*  Message Buffer Attributes  */
 
#define MSBGBL (0x80000000UL)

/*  Mailbox Open Modes [mode]  */
 
#define MBRCV  (0UL)
#define MBSND  (1UL)

/*  Start-task Parameters  */
 
#define CSTART ((qual_t) 0x00000)
#define CTERM  ((qual_t) 0x20000)
 
#define LRGPTY ((qual_t) 0x0000)
#define GVNPTY ((qual_t) 0x0100)
#define CURPTY ((qual_t) 0x0200)
#define INHPTY ((qual_t) 0x0300)

/*  Task Language Codes (TCD)  */
 
#define ASM  0
#define C    1

/*  Task Attributes  */
 
#define DUR 0x00
#define TRN 0x80
#define REL 0x00
#define ABS 0x40
#define APP 0x00
#define SYS 0x20
#define SUB 0x10
 
/*  Task Restart Parameters  */
 
#define STRTIM ((qual_t) 0x00000000)
#define TRMTIM ((qual_t) 0x80000000)

/*  Time Interval Codes  */
 
#define MS ((qual_t) 256)	/* MS */
#define TMS (2*MS)		/* 10 MS */
#define HMS (3*MS)		/* 100 MS */
#define SEC (4*MS)		/* seconds */
#define MIN (5*MS)		/* minutes */
#define HRS (6*MS)		/* hours */
#define DAY (7*MS)		/* days */
 
#define IMONLY (MS+0)		/* immediate only */
#define NXTICK (MS+1)		/* next tick */
#define NOEND  ((qual_t) 0)	/* no end */


/********************************************
 *                                          *
 * Preprocessor Macros                      *
 *                                          * 
 *******************************************/

#define	KEY(w, x, y, z)	\
    ((key_t)((((key_t)w<<24)+((key_t)x<<16))+((key_t)y<<8))+(key_t)z)


/********************************************
 *                                          *
 * Function Prototypes                      *
 *                                          *
 *******************************************/

/*
** Task services
*/
uxid_t	crtsk(struct tcd* tcdptr);
void    dltsk(long retarg);
long    start(uxid_t tid, ULONG pty, UPTR arg, ULONG* stabfr, qual_t qual);
uxid_t  gettid(key_t key);
key_t   getkey(uxid_t tid);
long    getdad(UPTR buf);
UWORD	setpty(uxid_t tid, ULONG basis, long value);
long	tstart(uxid_t tid);
void    trmrst(long retarg, qual_t intvlb);
long	canpau(uxid_t tid);
void    ux_exit(long retarg);


/*
** Event flag services
*/
uxid_t	crefg(key_t key);
long	dlefg(uxid_t gid);
long    waiefg(uxid_t gid, ULONG opmask, qual_t intrvl);
long    srslef(uxid_t tid, ULONG opmask);
long    srsefg(uxid_t gid, ULONG opmask);
long    sgiefg(uxid_t gid, ULONG mask, qual_t intrvl);

/*
** Mailbox services
*/
uxid_t  opnmbx(key_t key, ULONG mode);
long    clsmbx(key_t key, ULONG mode);
long    dlmbx(uxid_t mbid);
long    sndmbx(uxid_t mbid, UPTR srcadr, ULONG prty,
	                                 ULONG *stabuf, qual_t qual);
long    rcvmbx(uxid_t mbid, UPTR dstadr, ULONG *stabuf, qual_t qual);

/*
** Memory pool services
*/
uxid_t crcmp(pid_t pid, key_t key, UPTR basadr, ULONG len, ULONG ln2blk);
long   dlcmp(uxid_t cpid);
uxid_t getcmp(key_t key);
UPTR   alloc(uxid_t cpid, ULONG numbyt, UPTR* alobfr, qual_t qual);
long   dalloc(uxid_t cpid, ULONG numbyt, UPTR aloadr);
uxid_t crfbp(pid_t pid, key_t key, UPTR basadr, ULONG numblk, ULONG lenblk);
long   dlfbp(uxid_t fpid);
UPTR   alofbp(uxid_t fpid, UPTR* alobfr, qual_t qual);
long   dalfbp(uxid_t fpid, UPTR aloadr);
uxid_t getfbp(key_t key);


/*
** Message buffer services
*/
uxid_t crmsb(key_t key,	ULONG attr);
long   putmsb(uxid_t msbid, UPTR msg);
long   putmse(uxid_t msbid, UPTR msg);
long   dlmsb(uxid_t msbid);
uxid_t getmsb(key_t key);
long   getmsn(uxid_t msbid, UPTR dstadr);
long   getmsw(uxid_t msbid, UPTR dstadr);

/*
** Semaphore services
*/
uxid_t crsem(key_t key);
long   waisem(uxid_t sid, ULONG *stabuf, qual_t qual);
long   rlssem(uxid_t sid);
long   dlsem(uxid_t sid);

/*
** Time services
*/
long   getime(imst_t* msbuf);
long   ux_pause(qual_t intrvl);


/* The following are required to avoid conflict with the standard
   library functions. (dw)
*/

#define pause  ux_pause
#define getuid ux_getuid
#define exit   ux_exit


#endif
