/*
 * Copyright 1988 - 1994, John F. Haugh II
 * All rights reserved.
 *
 * This software is derived from the Shadow Password Suite, version 3.3.2.
 * No portion of this comment block or copyright statement may be altered
 * without the written permission of the copyright holder.
 *
 *    This library is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU Library General Public License as
 *    published by the Free Software Foundation; either version 2 of the
 *    License, or (at your option) any later version.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU Library General Public License for more details.
 *
 *    You should have received a copy of the GNU Library General Public
 *    License along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *	@(#)gshadow.h	1.1	12:22:59	13 Feb 1994	(GNU Shadow Library Suite)
 */

#ifndef	_H_GSHADOW
#define	_H_GSHADOW

/*
 * Shadow group security file structure
 */

struct	sgrp {
	char	*sg_name;	/* group name */
	char	*sg_passwd;	/* group password */
	char	**sg_adm;	/* group administator list */
	char	**sg_mem;	/* group membership list */
};

/*
 * Shadow group security file functions.
 */

#if defined(__STDC__)
struct	sgrp	*getsgent (void);
struct	sgrp	*getsgnam (const char *);
struct	sgrp	*sgetsgent (const char *);
struct	sgrp	*fgetsgent (FILE *);
void	setsgent (void);
void	endsgent (void);
int	putsgent (const struct sgrp *, FILE *);
#else
struct	sgrp	*getsgent ();
struct	sgrp	*getsgnam ();
struct	sgrp	*sgetsgent ();
struct	sgrp	*fgetsgent ();
void	setsgent ();
void	endsgent ();
int	putsgent ();
#endif

#define	GSHADOW	"/etc/gshadow"
#endif
