#include <errno.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <stdarg.h>

/*
  failsafe versions of realloc() and malloc()
*/


static char *RCSID __attribute__ ((unused))="$Id: xfiles.c,v 1.5 2004/07/01 12:57:21 walter Exp $";



void *xrealloc(void *ptr, size_t size)
{
        static void *ret;
        ret=realloc(ptr,size);
        if (ret == NULL ) {
                fprintf(stderr,"%s :%s\n",__func__,strerror(errno));
                exit(EXIT_FAILURE);
                }
        return ret;
}

void *xmalloc(size_t size)
{
        static void *ret;
        ret=malloc(size);
        if (ret == NULL ) {
                fprintf(stderr,"%s :%s\n",__func__,strerror(errno));
                exit(EXIT_FAILURE);
                }
        return ret;
}

/*
  safe version of sprintf() and snprintf()
  char *foo;
  size=xsprintf(&foo,"%s","Hallo Welt");
  snprintf(&foo,maxsize, ) will stop after maxsize
*/

int xsprintf(char **str, const  char  *format, ... ) 
{
	static int size;

	va_list ap;
	va_start(ap,format);
	size=vsnprintf(NULL,0,format,ap);
	size++;
	*str=xmalloc(size);
	size=vsnprintf(*str,size,format,ap);
	va_end(ap);

	return size;
}

int xsnprintf(char **str, int maxsize, const  char  *format, ... ) 
{
	static int size;

	va_list ap;
	va_start(ap,format);
	size=vsnprintf(NULL,0,format,ap);

	if ( ( maxsize != 0 ) && (size>maxsize) )  
			size=maxsize-1;

	size++;     /* trailing 0*/
	*str=xmalloc(size);
	size=vsnprintf(*str,size,format,ap);
	va_end(ap);

	return size;
}

/*
  xfree() makes pointer invalid after use
*/

#define xfree(PTR) { free(PTR); PTR=NULL; } while(0)
