/*
  dump data from TS database to stdio
*/
#define _GNU_SOURCE

#include <stdio.h>
#include <stdlib.h>
#include <getopt.h>
#include <errno.h>
#include <string.h>

#include "header.h"
#include "xfiles.h"
#include "file.h"
#include "arr.h"

void usage()
{
  printf("%s Usage:\n",program_invocation_short_name);
  printf(" -N <Netz>: SIL\n");
  printf(" -M <Methode>: 16-kanal-zaehler\n");  
  printf(" -K <Kennung>: P3_AlphaRnTn\n");
  printf(" -V <Von>: 2004-01-01\n");
  printf(" -B <Bis>: 2004-01-01\n");
  printf("Optional\n");
  printf(" -s sortieren\n");
  printf(" -h usage\n");
  exit(EXIT_FAILURE);
}

time_t a2time(char *zeit)
{
 static struct tm tms;
 if ( strptime(zeit, "%Y-%m-%d", &tms) == NULL) 
          return 0;
  return timegm(&tms);
}


#define OPT_SORT (1<<0)


int parseopt(int argc, char *argv[],struct metadata *meta, struct crit *krit)
{
  int ret;
  int has_v,has_b=0;
  int has_k,has_m,has_n=0;
  static int opt;

  opt=0;

  while(1) 
  {
	  ret=getopt(argc,argv,"K:V:B:N:M:hs");

	  if (ret==-1) break;

	  switch( ret ) {

	  case 'K':		  
		  meta->kennung=strdup(optarg); 
		  has_k=1;
		  break;

	  case 'N': 
		  meta->messnetz=strdup(optarg); 
		  has_n=1;
		  break;

	  case 'M':
		  meta->methode=strdup(optarg); 
		  has_m=1;
		  break;
		  
	  case 'V':
		  krit->von=a2time(optarg);
		  has_v=1;
		  break;

	  case 'B':
		  krit->bis=a2time(optarg);
		  has_b=1;
		  break;

	  case 'h':
		  usage();

	  case 's':
		  opt=opt|OPT_SORT;


	  }
  }

#ifdef DEBUG
  printf("Netz:%s\n",meta->messnetz);
  printf("Methode:%s\n",meta->methode);
  printf("Kennung:%s\n",meta->kennung);
  printf("Von:%s",asctime(gmtime(&krit->von)));
  printf("Bis:%s",asctime(gmtime(&krit->bis)));
#endif


  if (has_n*has_m*has_k*has_v*has_b == 0 )
		  usage();

  return opt;
}


int main(int argc, char *argv[])
{

	struct metadata *meta;
	struct crit *krit;
	struct array *feld;
	int i,ret,opt;

	meta=xmalloc( sizeof ( struct metadata ) );
	krit=xmalloc( sizeof ( struct crit ) );

	opt=parseopt(argc,argv,meta,krit);
	
	feld=xmalloc( sizeof( struct array) );

	ret=aopen(feld,meta,krit);

#ifdef DEBUG
	printf("loaded: %d lines\n",feld->size);
#endif

	if (opt | OPT_SORT )
		areorder(feld);

	for(i=0;i<feld->size;i++) 
		printf("%s",feld->lines[i]);

	return EXIT_SUCCESS;
}
