/*
gcc -g -Wall -DTEST file.c xfiles.o misc.o
*/

#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <search.h>
#include <time.h>
#include <errno.h>
#include <sys/mman.h>
#include <sys/stat.h>

#include "header.h"
#include "xfiles.h"
#include "misc.h"

/* 
   general file handling code
*/
static char *RCSID __attribute__ ((unused))="$Id: file.c,v 2.2 2004/07/04 13:08:12 walter Exp walter $";

/*
  specify WHERE data will be stored
  it returns a valid name every time called
*/

static char *get_TSDIR(void)
{
	static char *val;

	val=getenv("TSDIR");
	if (val == NULL)
		return ".";

	return val;
}

/* 
   translate metadata to path
   NOTE: NOT including filename
   TODO: merge with meta2fullname()
*/

static char *meta2path(struct metadata *meta)
{
        time_t now;
        struct tm *tms;
        static char *dir;
        static char buf[200];

        now=meta->zeit;
        tms=gmtime(&now);
        strftime(buf,sizeof(buf),"%Y/%m/%d",tms);
	xsprintf(&dir,"%s/%s/%s/%s",get_TSDIR(),meta->messnetz,meta->methode,buf);
        return dir;

}


/*
 return full path+name
*/

static char *meta2fullname(struct metadata *meta)
{
	static char *dir;
	time_t now;
	struct tm *tms;
        char buf[200];
        now=meta->zeit;
        tms=gmtime(&now);
        strftime(buf,sizeof(buf),"%Y/%m/%d",tms);
	xsprintf(&dir,"%s/%s/%s/%s/%s",get_TSDIR(),meta->messnetz,meta->methode,buf,meta->kennung);
        return dir;
}


/* 
   if array==NULL oder size==0
   copy file into array
   else
   attach file on array
*/

int file2array(char *name,struct array *feld)
{
        char **lines;
        size_t big;
        ssize_t ret;
        FILE *fp;
        int cnt, max_cnt;
	
	lines=feld->lines;
	cnt=feld->size;
	/*
        lines=*array;
        cnt= *size;
	*/
/*
make propper initialisation 
if lines==NULL then realloc is like malloc 
*/
        if ( (lines == NULL) || ( cnt == 0) ) {
                cnt=0;
                lines=NULL; 
        }
  
        fp=fopen(name,"r");
        if (fp==NULL) {
		fprintf(stderr,"open %s failed\n%s\n",name,strerror(errno));
                exit(EXIT_FAILURE);
        }

        max_cnt = cnt;
        for(;;) {
                if (cnt == max_cnt) {
                        max_cnt+=100;
                        lines=(char **)xrealloc(lines,sizeof(char *)*max_cnt);
                }
                big=0;
                ret=getline(&lines[cnt],&big,fp);
                if (ret <0) break;
                cnt++;
        }  
        lines=(char **)xrealloc(lines,sizeof(char *)*cnt);

	feld->lines=lines;
	feld->size=cnt;

        fclose(fp);
        return EXIT_SUCCESS;
}




/*
   copy filecontent into array
   smallest unit is DAY !!
*/


int 
aopen(struct array *feld , struct metadata *meta, struct crit *krit ) 
{

	time_t ttmp;            /* tempbuffer */
	time_t dvon,dbis;	/* tageszaehler */
	char *name;
	int ret;
	//	char **lines;
	// int size;


/* zeit in reihenfolge */

         if (krit->bis == krit->von) {
                krit->von=0;
        }

        else if ( krit->bis < krit->von) {
                ttmp=krit->bis;
                krit->bis=krit->von;
                krit->von=ttmp;
        }

	dvon=(krit->von)/TAG;
	dbis=(krit->bis)/TAG;

	/* for now we dont append */

	feld->size=0;
	/* loop over days */

	for(ttmp=dvon;ttmp<dbis+1;ttmp++) {
		meta->zeit=ttmp*TAG;
		name=meta2fullname(meta);
		ret=file2array(name,feld);
		free(name);
	       }


	return EXIT_SUCCESS;
}

/*
  cd into dirname
  create if not exists
*/


static int cd_createdir(char *dirname)
{
        int ret=chdir(dirname);

        if (ret == EXIT_SUCCESS)
                return ret;

        ret=-errno;

        if (ret != -ENOENT)
                return ret;

        ret=mkdir(dirname, S_IRWXU | S_IRWXG | S_IROTH | S_IXOTH);
        if ( ret < 0 )
                return ret;

        return chdir(dirname);

}

/*
  input: a/b/c
  wenn eines der verzeichnisse fehlt wird es erstellt
  achtung: / ist IMMER der trenner
  strdupa() gibt man dem return automatisch frei

*/

static int cd_dirs(char *dir)
{
        char *sdir;   /* subdir */
        char *backup=(char *)strdupa(dir);    
        int ret;


        for( sdir=(char *)strsep(&backup,"/"); 
             sdir != NULL ; 
             sdir=(char *)strsep(&backup,"/") )
        {
		if ( sdir[0] == 0 ) 
	                ret=cd_createdir("/");
		else
			ret=cd_createdir(sdir);

                if (ret<0)
                        return ret;

        }

        return EXIT_SUCCESS;
}


static FILE *
data_open(struct metadata *meta,char *mode)
{
        char *dir,*cwd,*path;
        int ret,size;
        cwd=get_current_dir_name();
        dir=meta2path(meta);
        ret=cd_dirs(dir);

        if (ret<0) {
                fprintf(stderr,"%s:%s %s\n",__func__,dir,strerror(errno));
                exit(EXIT_FAILURE);
        }
        chdir(cwd);

/*
  xsprintf(path,"%s/%s",dir,meta->kennung);
*/

        size=snprintf(NULL,0,"%s/%s",dir,meta->kennung);
        path=alloca(size+1);
        snprintf(path,size+1,"%s/%s",dir,meta->kennung);
        free(dir);                 /* free dirname */
        free(cwd);                 /* cwd */
        return fopen(path,mode);
}

/*
write data into file(s)
old content will be deleted

exspect data in ordered state
*/

/* 
freeing written lines disabled 
*/

int 
aclose(struct array *feld, struct metadata *meta, struct crit *krit ) 
{
	time_t cur_time,cur_day;
	time_t xtime,xday;

	FILE *fp;
	char **line;
	int i,size;

	line=feld->lines;
	size=feld->size;

	i=0;

	cur_time=get_messzeit(line[i]);
reinit:
	meta->zeit=cur_time;
	cur_day=cur_time/TAG;
	fp=data_open(meta,"w");

	fputs(line[i],fp);
	free(line[i]);

	while(++i < size ) {
		xtime=get_messzeit(line[i]);
		xday=xtime/TAG;

		if (xday != cur_day) {
			cur_time=xtime;
			fclose(fp);
			goto reinit;
		}

		fputs(line[i],fp);
	        free(line[i]);
	}
	fclose(fp);

	free(line);
	return EXIT_SUCCESS;
}


/* 
   append data to file 
   user must make sure that
   1. file starts with <datum>| entry
   2. metastructure is filled
*/

int 
append(struct metadata *meta,char *line)
{
	FILE *fp;
	fp=data_open(meta,"a");
/*
  if needed:
  add check that timestamp inside line is the same day as in meta->zeit
*/
  	fputs(line,fp);
	fclose(fp);
	return EXIT_SUCCESS;
}


#ifdef TEST
int main()
{

	struct crit krit= {
                .bis = 1083729600L,       /* 2004-05-05 06:00:00 UTC */ 
                .von = 1083297600L        /* 2004-04-30 04:00:00 UTC */
        };

	struct metadata meta= {
                .messnetz="SIL",
                .methode="16-kanal-zaehler",
                .kennung="P3_AlphaRnTn"
        };

	struct array *feld;
	int ret,i;


	feld=xmalloc(sizeof (struct array));
	feld->size=0;

	ret=aopen(feld,&meta,&krit);
	
	printf("loaded: %d lines\n",feld->size);	

	for(i=0;i<feld->size;i++)
		printf("%s",feld->lines[i]);

	meta.messnetz="TEST";
	aclose(feld,&meta,NULL);

	free(feld);
	return EXIT_SUCCESS;
}
#endif
