.\" $Id: xfiles.man,v 0.3 2004/07/04 10:59:57 walter Exp $
.\" (c) w.harms
.\" licence: GPL
.\"
.TH xfiles 2004-07-02 "LIBARRAY" "add-ons"
.SH NAME
xrealloc,xmalloc,xsprintf,xsnprintf,xfree \- memory helper function 
.SH SYNOPSIS

.BR "void *xrealloc(void *" ptr ", size_t " size ");"
.sp
.BR "void *xmalloc(size_t " size ");"
.sp
.BR "int xsprintf(char **" str ", const char *" format "," ... ");"
.sp
.BR "int xsnprintf(char **" str ", int " maxsize ", const char *" format "," ... ");"
.sp
.BR "void xfree(void *" ptr ");"
.SH DESCRIPTION
The helper function are a safe replacement for the corresponding glibc functions.
.SS "xrealloc and xmalloc"
The functions will exit if no memory can be allocated.
.SS "xsprintf and xsnprintf"
simply give a pointer and the memory will be allocated automaticly. The 
.BR snprintf ()
is restricts the amount of memory that can be allocated. the size of 
allocated memory will be returned.
.SH NOTE
There is a also 
.BR xfree ()
macro . It is like the normal 
.BR free ()
but sets also the pointer to NULL to prevent a double free.
.SH "SEE ALSO"
.BR aclose (),
.BR append ()