.\" $Id: aupdate.man,v 0.3 2004/07/04 10:54:50 walter Exp $
.\" (c) w.harms
.\" license: GPL
.\"
.TH aupdate 2004-07-02 "LIBARRAY" "array"
.SH NAME
aupdate,ainsert,aidxfind,areorder \- array manipulation
.SH SYNOPSIS
.BR "int aupdate(struct array *" feld ", char *" line ");"
.sp
.BR "int ainsert(struct array *" feld ", char *" line ");"
.sp
.BR "int aidxfind(struct array *" feld ", char *" line ");"
.sp
.BR "int areorder(struct array *" feld ");"
.SH DESCRIPTION
This is a collection of array handling routines. Since time series data
will never be deleted therefor there is no delete. All order is defined
by the time entry. The used format is described in append(). Since all
data is manipulated in memory the bad things happen when calling aclose().
.sp
.SS "aupdate"
The aupdate() functions searches in
.I feld
for the time described with 
.I line 
and replace it with 
.IR line .
If the entry is not found an error will be returned.
.sp
.SS "ainsert"
The ainsert() function adds 
.I line
into the array
.IR feld .
If the entry is already used an error will be returned.
.SS "aidxfind"
The function searches the array
.I feld
for the time entry in
.IR line .
on success ist returns the entry number or \-1 on error.
.SS "reorder"
if you write data with
.BR aclose ()
you must have an ordered data set. The ordering is done on base
of the time entry.
.SH "RETURN VALUE"
As all other library the functions return EXIT_FAILURE on error. 
Note that 
.BR aidxfind () 
is an exception.
.SH NOTE
Since aopen() simply copies a file into an array. it has no idea about
illegal lines. The user must take care. On the other hand the array functions
expect a time string as first entry with "|" as delimiter.
.SH "SEE ALSO"
.BR aclose (),
.BR append (),
.BR aopen ()