.\" $Id: aclose.man,v 0.4 2004/07/04 13:23:44 walter Exp $
.\" (c) w.harms
.\" license: GPL
.\"
.TH AOPEN 2004-07-02 "LIBARRAY" "BASICS"
.SH NAME
aopen,aclose \- load/save file content described by metadata into/from array
.SH SYNOPSIS

.BR "int aopen(struct array *" feld ","
.BR "struct metadata *" meta "," 
.BR "struct crit *" krit ");"
.sp
.BR "int aclose(struct array *" feld ","
.BR "struct metadata *" meta "," 
.BR "struct crit *" krit ");"

.SH DESCRIPTION
aopen() opens the path as described in struct metadata. The time range is a 
requirement. The data is stored in struct array. memory will be allocated
within aopen(). 
.br
aclose() opens the path as described in struct metadata. The function 
will start with the first time entry in struct array. The corresponding
file will be opened. If the file exists it will be overwritten.
.SS "structures"
A short description of structures used for the functions. LINES are the
start entry for a linear array ordered by the first entry. SIZE is the
current size of the array.
.sp
.nf
struct array {
        int size;
        char **lines;
};
.fi
.sp
The metadata structure describes the way to the file. The path to the file
is defined as messnetz/methode/YYYY/MM/DD/. kennung is used as filename.
zeit is broken down to YYYY/MM/DD.
.sp
.nf
struct metadata {
        char *messnetz;
        char *methode;
        char *kennung;
        time_t zeit;
};
.fi
.sp
The variable \fBTSDIR\fR describes the base of the searchpath.
If the dir does not exists it will be created.
.SH "NOTE"
aopen() and aclose() ignore the zeit entry in struct metadata.
.sp
The aopen() functions are very primitive. It stores
.B every
line in an array. no comments, no empty lines. The user must take care
of the parsing.
.SH "RETURN VALUE"
All library functions return EXIT_SUCCESS on success and EXIT_FAILURE on
failure.
.SH "SEE ALSO"
.BR append (),
.BR areorder (),
.BR file2array ()