/* 
collection of funktions that work only on the loaded array
*/

#include <stdio.h>
#include <stdlib.h>
#include <search.h>
#include <string.h>

#include "xfiles.h"
#include "misc.h"
#include "header.h"

static char *RCSID __attribute__ ((unused))="$Id: arr.c,v 2.0 2004/06/30 21:11:23 walter Exp walter $";


static int 
_cmp_time(const void *date1,const void *date2)
{
        return cmp_time(*(char **)date1,*(char **)date2);
};

/*
  copie von lfind()
  achtung:
  size ist size_t damit unsigned 
  die rueckgabe ist ssize_t und damit signed und nur
  halb so gross.

*/

static ssize_t idxfind (const void *key, const void *base, size_t *nmemb, size_t size,
       __compar_fn_t compar)
{
	const void *result = base;
	size_t cnt = 0;
	while (cnt < *nmemb && (*compar) (key, result) != 0)
	{
		result += size;
		++cnt;
	}

	return cnt < *nmemb ? cnt: -1;
}




int aupdate(struct array *feld,char *line)
{
        char **res,**lines; 
	int cnt;
	cnt=feld->size;
	lines=feld->lines;

	/* 
	   update an with an empty line is an error 
	*/

        if (line==NULL) {
                return EXIT_FAILURE;
        }

        res=lfind(&line,lines,&cnt,sizeof(char *),_cmp_time);

        if ( res == NULL) {
                return EXIT_FAILURE;
        }

        free(*res);
	xsprintf(&(*res),"%s\n",line);
        return EXIT_SUCCESS;
  
}


int aidxfind(struct array *feld ,char *line)
{
 
       if (line==NULL) {
                return EXIT_FAILURE;
        }

        return idxfind(&line,feld->lines,&feld->size,sizeof(char *),_cmp_time);
  
}




int ainsert(struct array *feld,char *line)
{

        char **res,**lines;
        int cnt2;

	cnt2=feld->size;
	lines=feld->lines;

        res=lfind(&line,lines,&cnt2,sizeof(char *),_cmp_time);

        if ( res != NULL) 
                return EXIT_FAILURE;

        /* append at end */

        cnt2++;
        lines=(char **)xrealloc(lines,sizeof(char *)*cnt2);

	xsprintf(&(lines[cnt2-1]),"%s\n",line);

	feld->size=cnt2;
	feld->lines=lines;

        return EXIT_SUCCESS;
}

/*
  qsort() is void therefor we will return SUCCESS forever
  perhaps we can add some errorcheck in the future
*/

int areorder(struct array *feld)
{

  qsort(feld->lines,feld->size,sizeof(char *),_cmp_time);
  return EXIT_SUCCESS;

}
